/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import org.orecruncher.LibBase;
import org.orecruncher.lib.Translations;
import org.orecruncher.lib.compat.I18nUtil;
import org.orecruncher.lib.compat.LocaleUtil;

public final class Localization {
    private static Local impl;

    public static void initialize(@Nonnull Side side, @Nonnull String modId) {
        if (impl == null) {
            impl = side == Side.SERVER ? new ServerImpl() : new ClientImpl();
        }
        ResourceLocation loc = new ResourceLocation(modId, "en_us");
        LibBase.log().info("Loading language resources [%s]", loc.toString());
        impl.loadResources(loc);
    }

    @Nonnull
    public static String format(@Nonnull String translateKey, Object ... parameters) {
        return impl.format(translateKey, parameters);
    }

    public static String loadString(@Nonnull String translateKey) {
        return impl.loadString(translateKey);
    }

    private static class ServerImpl
    extends Local {
        private final Translations xlate = new Translations();

        private ServerImpl() {
        }

        @Override
        public String format(String translateKey, Object ... parameters) {
            return this.xlate.format(translateKey, parameters);
        }

        @Override
        public String loadString(String translateKey) {
            return this.xlate.loadString(translateKey);
        }

        @Override
        public void loadResources(@Nonnull ResourceLocation loc) {
            this.xlate.load(loc);
        }
    }

    private static class ClientImpl
    extends Local {
        private ClientImpl() {
        }

        @Override
        public String format(String translateKey, Object ... parameters) {
            return I18n.func_135052_a((String)translateKey, (Object[])parameters);
        }

        @Override
        public String loadString(String translateKey) {
            Locale locale = I18nUtil.getLocale();
            return LocaleUtil.translateKeyPrivate(locale, translateKey);
        }
    }

    private static abstract class Local {
        private Local() {
        }

        public abstract String format(String var1, Object ... var2);

        public abstract String loadString(String var1);

        public void loadResources(@Nonnull ResourceLocation loc) {
        }
    }
}

