/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.world.village;

import einstein.jmc.JMCBlockRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class CakeBakeryVillagePart
extends StructureVillagePieces.Village {
    public static final int WIDTH = 8;
    public static final int HEIGHT = 7;
    public static final int DEPTH = 8;
    public static final IBlockState[] CAKES = new IBlockState[]{JMCBlockRegistry.CHOCOLATE_CAKE.func_176223_P(), JMCBlockRegistry.APPLE_CAKE.func_176223_P(), JMCBlockRegistry.CARROT_CAKE.func_176223_P()};
    private static final ResourceLocation STRUCTURE = new ResourceLocation("jmc", "cake_bakery");
    private int count;
    private EnumFacing coordBaseMode;
    private Mirror mirror;
    private Rotation rotation;

    public CakeBakeryVillagePart() {
    }

    public CakeBakeryVillagePart(StructureVillagePieces.Start start, int type, StructureBoundingBox bounds, EnumFacing facing) {
        super(start, type);
        this.func_186164_a(facing);
        this.field_74887_e = bounds;
    }

    public void func_186164_a(EnumFacing facing) {
        super.func_186164_a(facing);
        this.coordBaseMode = facing;
        if (facing == null) {
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
        } else {
            switch (facing) {
                case SOUTH: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.NONE;
                }
            }
        }
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bounds) {
        throw new IllegalStateException("An error occurred while decompiling this method.");
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("count", this.count);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        super.func_143011_b(tagCompound, p_143011_2_);
        this.count = tagCompound.func_74762_e("count");
    }

    public void clearCurrentPositionBlocksUpwards(World world, BlockPos pos, StructureBoundingBox boundingBox) {
        if (boundingBox.func_175898_b((Vec3i)pos)) {
            while (!world.func_175623_d(pos) && pos.func_177956_o() < 255) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                pos = pos.func_177984_a();
            }
        }
    }

    public void replaceAirAndLiquidDownwards(World world, IBlockState blockstate, BlockPos pos, StructureBoundingBox boundingBox) {
        if (boundingBox.func_175898_b((Vec3i)pos)) {
            while ((world.func_175623_d(pos) || world.func_180495_p(pos).func_185904_a().func_76224_d()) && pos.func_177956_o() > 1) {
                world.func_180501_a(pos, blockstate, 2);
                pos = pos.func_177977_b();
            }
        }
    }

    public EnumFacing rotate(EnumFacing facing, boolean clockwise) {
        if (!clockwise) {
            switch (facing) {
                case NORTH: {
                    return EnumFacing.EAST;
                }
                case EAST: {
                    return EnumFacing.SOUTH;
                }
                case SOUTH: {
                    return EnumFacing.WEST;
                }
                case WEST: {
                    return EnumFacing.NORTH;
                }
            }
            throw new IllegalStateException("Rotation failed while generation for: " + facing);
        }
        switch (facing) {
            case NORTH: {
                return EnumFacing.WEST;
            }
            case EAST: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
            case WEST: {
                return EnumFacing.SOUTH;
            }
        }
        throw new IllegalStateException("Rotation failed while generation for: " + facing + " which is clockwise");
    }

    public static class CreationHandler
    implements VillagerRegistry.IVillageCreationHandler {
        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int size) {
            return new StructureVillagePieces.PieceWeight(CakeBakeryVillagePart.class, 1, MathHelper.func_76136_a((Random)random, (int)0, (int)1));
        }

        public Class<?> getComponentClass() {
            return CakeBakeryVillagePart.class;
        }

        public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int minX, int minY, int minZ, EnumFacing facing, int componentType) {
            StructureBoundingBox bounds = StructureBoundingBox.func_175897_a((int)minX, (int)minY, (int)minZ, (int)0, (int)0, (int)0, (int)8, (int)7, (int)8, (EnumFacing)facing);
            return StructureComponent.func_74883_a(pieces, (StructureBoundingBox)bounds) == null ? new CakeBakeryVillagePart(startPiece, componentType, bounds, facing) : null;
        }
    }
}

