/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mobrebirth.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import the_fireplace.mobrebirth.MobRebirth;
import the_fireplace.mobrebirth.common.ConfigValues;

public class MobRebirthConfigGui
extends GuiConfig {
    public MobRebirthConfigGui(GuiScreen parentScreen) {
        super(parentScreen, MobRebirthConfigGui.getConfigElements(), "mobrebirth", false, false, GuiConfig.getAbridgedConfigPath((String)MobRebirth.mobcontrols.toString()));
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("mobCfg", "mobCfg", MobEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("chanceCfg", "chanceCfg", ChanceEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("behaviorCfg", "behaviorCfg", BehaviorEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("debugCfg", "debugCfg", DebugEntry.class));
        list.addAll(new ConfigElement(MobRebirth.general.getCategory("general")).getChildElements());
        if (MobRebirth.instance.getHasCustomMobSettings()) {
            list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("customMobs", "customMobs", CustomMobEntry.class));
        }
        return list;
    }

    public static class DebugEntry
    extends GuiConfigEntries.CategoryEntry {
        public DebugEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            return new GuiConfig((GuiScreen)this.owningScreen, new ConfigElement(MobRebirth.debugcontrols.getCategory("general")).getChildElements(), "mobrebirth", false, false, GuiConfig.getAbridgedConfigPath((String)MobRebirth.debugcontrols.toString()));
        }
    }

    public static class BehaviorEntry
    extends GuiConfigEntries.CategoryEntry {
        public BehaviorEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            return new GuiConfig((GuiScreen)this.owningScreen, new ConfigElement(MobRebirth.behaviorcontrols.getCategory("general")).getChildElements(), "mobrebirth", false, false, GuiConfig.getAbridgedConfigPath((String)MobRebirth.behaviorcontrols.toString()));
        }
    }

    public static class ChanceEntry
    extends GuiConfigEntries.CategoryEntry {
        public ChanceEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            return new GuiConfig((GuiScreen)this.owningScreen, new ConfigElement(MobRebirth.chancecontrols.getCategory("general")).getChildElements(), "mobrebirth", false, false, GuiConfig.getAbridgedConfigPath((String)MobRebirth.chancecontrols.toString()));
        }
    }

    public static class MobEntry
    extends GuiConfigEntries.CategoryEntry {
        public MobEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            return new GuiConfig((GuiScreen)this.owningScreen, new ConfigElement(MobRebirth.mobcontrols.getCategory("general")).getChildElements(), "mobrebirth", false, false, GuiConfig.getAbridgedConfigPath((String)MobRebirth.mobcontrols.toString()));
        }
    }

    public static class CustomMobEntry
    extends GuiConfigEntries.CategoryEntry {
        public CustomMobEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            return new GuiConfig((GuiScreen)this.owningScreen, CustomMobEntry.getConfigElements(), "mobrebirth", false, false, I18n.func_135052_a((String)"customMobs.tooltip", (Object[])new Object[0]));
        }

        public static List<IConfigElement> getConfigElements() {
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
            for (String mobstring : ConfigValues.CUSTOMENTITIES) {
                list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(mobstring, mobstring, new ConfigElement(MobRebirth.mobConfigs.get(mobstring).getCategory("general")).getChildElements()));
            }
            return list;
        }
    }
}

