/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mobrebirth.common;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;
import the_fireplace.mobrebirth.MobRebirth;
import the_fireplace.mobrebirth.common.ConfigValues;

public class CommonEvents {
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("mobrebirth")) {
            MobRebirth.syncConfig();
            MobRebirth.syncMobConfigs();
            MobRebirth.createMobConfigs();
            MobRebirth.syncMobConfigs();
        }
    }

    @SubscribeEvent
    public void onEntityLivingDeath(LivingDropsEvent event) {
        if (MobRebirth.instance.getHasCustomMobSettings() && EntityList.func_191301_a((Entity)event.getEntityLiving()) != null && ArrayUtils.contains((Object[])ConfigValues.CUSTOMENTITIES, (Object)EntityList.func_191301_a((Entity)event.getEntityLiving()).func_110623_a())) {
            if (ConfigValues.REBIRTHFROMNONPLAYERMAP.get(EntityList.func_191301_a((Entity)event.getEntityLiving())).booleanValue()) {
                this.transition(event);
            } else if (event.getSource().func_76346_g() instanceof EntityPlayer) {
                this.transition(event);
            }
            return;
        }
        if (ConfigValues.REBIRTHFROMNONPLAYER) {
            this.transition(event);
        } else if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            this.transition(event);
        }
    }

    private void transition(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof IMob) {
            this.makeMobRebornTransition(event);
        } else if (event.getEntityLiving() instanceof IAnimals && ConfigValues.ANIMALREBIRTH) {
            this.makeMobRebornTransition(event);
        }
    }

    private void makeMobRebornTransition(LivingDropsEvent event) {
        if (ConfigValues.ALLOWBOSSES) {
            if (event.getEntityLiving() instanceof EntityWither || event.getEntityLiving() instanceof EntityDragon) {
                this.makeMobReborn(event);
                return;
            }
        } else if (event.getEntityLiving() instanceof EntityWither || event.getEntityLiving() instanceof EntityDragon) {
            return;
        }
        if (ConfigValues.ALLOWSLIMES) {
            if (event.getEntityLiving() instanceof EntitySlime) {
                this.makeMobReborn(event);
                return;
            }
        } else if (event.getEntityLiving() instanceof EntitySlime) {
            return;
        }
        if (ConfigValues.VANILLAONLY) {
            if (CommonEvents.isVanilla(event.getEntityLiving())) {
                this.makeMobReborn(event);
            }
        } else {
            this.makeMobReborn(event);
        }
    }

    private void makeMobReborn(LivingDropsEvent event) {
        block20: {
            double rand2;
            block22: {
                block21: {
                    double rand = Math.random();
                    ResourceLocation name = EntityList.func_191301_a((Entity)event.getEntityLiving());
                    if (MobRebirth.instance.getHasCustomMobSettings() && ArrayUtils.contains((Object[])ConfigValues.CUSTOMENTITIES, (Object)name.func_110623_a())) {
                        if (rand <= ConfigValues.REBIRTHCHANCEMAP.get(name)) {
                            if (ConfigValues.DROPEGGMAP.get(name).booleanValue() && EntityList.field_75627_a.containsKey(name)) {
                                CommonEvents.dropMobEgg(event, name);
                            } else {
                                this.createEntity(event);
                                if (ConfigValues.EXTRAMOBCOUNTMAP.get(name) > 0) {
                                    double rand22 = Math.random();
                                    if (ConfigValues.MULTIMOBMODE.toLowerCase().equals("all")) {
                                        if (rand22 <= ConfigValues.MULTIMOBCHANCEMAP.get(name)) {
                                            for (int i = 0; i < ConfigValues.EXTRAMOBCOUNTMAP.get(name); ++i) {
                                                this.createEntity(event);
                                            }
                                        }
                                    } else if (ConfigValues.MULTIMOBMODE.toLowerCase().equals("per-mob")) {
                                        for (int i = 0; i < ConfigValues.EXTRAMOBCOUNTMAP.get(name); ++i) {
                                            if (rand22 <= ConfigValues.MULTIMOBCHANCEMAP.get(name)) {
                                                this.createEntity(event);
                                            }
                                            rand22 = new Random().nextDouble();
                                        }
                                    } else {
                                        for (int i = 0; i < ConfigValues.EXTRAMOBCOUNTMAP.get(name) && rand22 <= ConfigValues.MULTIMOBCHANCEMAP.get(name); ++i) {
                                            this.createEntity(event);
                                            rand22 = new Random().nextDouble();
                                        }
                                    }
                                }
                            }
                        }
                        return;
                    }
                    if (!(rand <= ConfigValues.REBIRTHCHANCE)) break block20;
                    if (!ConfigValues.DROPEGG || !EntityList.field_75627_a.containsKey(name)) break block21;
                    CommonEvents.dropMobEgg(event, name);
                    break block20;
                }
                this.createEntity(event);
                if (ConfigValues.EXTRAMOBCOUNT <= 0) break block20;
                rand2 = Math.random();
                if (!ConfigValues.MULTIMOBMODE.toLowerCase().equals("all")) break block22;
                if (!(rand2 <= ConfigValues.MULTIMOBCHANCE)) break block20;
                for (int i = 0; i < ConfigValues.EXTRAMOBCOUNT; ++i) {
                    this.createEntity(event);
                }
                break block20;
            }
            if (ConfigValues.MULTIMOBMODE.toLowerCase().equals("per-mob")) {
                for (int i = 0; i < ConfigValues.EXTRAMOBCOUNT; ++i) {
                    if (rand2 <= ConfigValues.MULTIMOBCHANCE) {
                        this.createEntity(event);
                    }
                    rand2 = new Random().nextDouble();
                }
            } else {
                for (int i = 0; i < ConfigValues.EXTRAMOBCOUNT && rand2 <= ConfigValues.MULTIMOBCHANCE; ++i) {
                    this.createEntity(event);
                    rand2 = new Random().nextDouble();
                }
            }
        }
    }

    private static void dropMobEgg(LivingDropsEvent event, ResourceLocation name) {
        ItemStack dropEgg = new ItemStack(Items.field_151063_bx);
        NBTTagCompound eggData = new NBTTagCompound();
        NBTTagCompound mobData = new NBTTagCompound();
        mobData.func_74778_a("id", name.toString());
        eggData.func_74782_a("EntityTag", (NBTBase)mobData);
        dropEgg.func_77982_d(eggData);
        event.getEntityLiving().func_70099_a(dropEgg, 0.0f);
    }

    private void createEntity(LivingDropsEvent event) {
        World worldIn = event.getEntityLiving().field_70170_p;
        ResourceLocation sid = EntityList.func_191301_a((Entity)event.getEntityLiving());
        NBTTagCompound storedData = event.getEntityLiving().getEntityData();
        event.getEntityLiving().func_70014_b(storedData);
        ItemStack weapon = event.getEntityLiving().func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offhand = event.getEntityLiving().func_184586_b(EnumHand.OFF_HAND);
        float health = event.getEntityLiving().func_110138_aP();
        EntityLivingBase entity = (EntityLivingBase)EntityList.func_188429_b((ResourceLocation)sid, (World)worldIn);
        if (entity == null) {
            return;
        }
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70761_aq = entity.field_70177_z;
        storedData.func_74768_a("Health", (int)health);
        entity.func_70020_e(storedData);
        entity.func_70606_j(health);
        if (!weapon.func_190926_b()) {
            entity.func_184201_a(EntityEquipmentSlot.MAINHAND, weapon);
        }
        if (!offhand.func_190926_b()) {
            entity.func_184201_a(EntityEquipmentSlot.OFFHAND, offhand);
        }
        entity.func_70107_b(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v);
        worldIn.func_72838_d((Entity)entity);
    }

    @SubscribeEvent
    public void entityDamaged(LivingHurtEvent event) {
        if (event.getSource().func_76347_k() && !ConfigValues.DAMAGEFROMSUNLIGHT && event.getEntityLiving().func_70662_br() && !event.getEntityLiving().func_180799_ab() && event.getEntityLiving().field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)event.getEntityLiving().field_70165_t), MathHelper.func_76128_c((double)event.getEntityLiving().field_70163_u), MathHelper.func_76128_c((double)event.getEntityLiving().field_70161_v)))) {
            event.setCanceled(true);
        }
    }

    public static boolean isVanilla(EntityLivingBase entity) {
        return EntityList.func_191301_a((Entity)entity) != null && EntityList.func_191301_a((Entity)entity).func_110624_b().matches("minecraft");
    }
}

