/*
 * Decompiled with CFR 0.152.
 */
package snownee.nimble;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;
import snownee.nimble.ModConfig;

@Mod.EventBusSubscriber(value={Side.CLIENT})
@Mod(modid="nimble", name="Nimble", version="0.0.2", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class Nimble {
    public static final String MODID = "nimble";
    public static final String NAME = "Nimble";
    private static Logger logger;
    private static final KeyBinding kbFrontView;
    private static boolean useFront;
    private static boolean flag;
    static int actualCameraMode;
    static float distance;
    static boolean elytraFlying;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ClientRegistry.registerKeyBinding((KeyBinding)kbFrontView);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @SubscribeEvent
    public static void cameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (!ModConfig.enable) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        if (mc.field_71439_g == null) {
            return;
        }
        if (ModConfig.nimbleElytra || ModConfig.elytraRollScreen) {
            if (mc.field_71439_g.func_184613_cA()) {
                if (ModConfig.elytraRollScreen) {
                    Vec3d look = mc.field_71439_g.func_70040_Z();
                    look = new Vec3d(look.field_72450_a, 0.0, look.field_72449_c);
                    Vec3d move = new Vec3d(mc.field_71439_g.field_70159_w, 0.0, mc.field_71439_g.field_70179_y).func_72432_b();
                    event.setRoll((float)look.func_72431_c((Vec3d)move).field_72448_b * 10.0f);
                }
                if (ModConfig.nimbleElytra && mc.field_71439_g.func_184599_cB() == ModConfig.elytraTickDelay) {
                    elytraFlying = true;
                    Nimble.setCameraMode(1);
                    actualCameraMode = 1;
                }
            } else if (ModConfig.nimbleElytra && elytraFlying) {
                actualCameraMode = 0;
                elytraFlying = false;
            }
        }
        if (kbFrontView.func_151470_d()) {
            return;
        }
        if (Nimble.getCameraMode() == 1) {
            float ptick = mc.func_184121_ak();
            float delta = 0.05f + (float)Math.sin((double)(distance / 3.0f) * Math.PI) * 0.15f * ptick;
            distance += actualCameraMode == 1 ? delta : -delta;
        } else {
            distance = 0.0f;
            return;
        }
        if (distance < 0.0f) {
            Nimble.setCameraMode(0);
        }
        if ((distance = Math.min(distance, 3.0f)) < 3.0f) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(3.0f - distance));
            Nimble.resetView();
        }
    }

    @SubscribeEvent
    public static void onFrame(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!ModConfig.enable) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        if (mc.field_71439_g == null) {
            return;
        }
        if (!ModConfig.frontKeyToggleMode && kbFrontView.func_151470_d()) {
            Nimble.setCameraMode(2);
            return;
        }
        if (ModConfig.frontKeyToggleMode && kbFrontView.func_151468_f()) {
            boolean bl = useFront = !useFront;
            if (useFront) {
                Nimble.setCameraMode(2);
            }
        }
        if (Nimble.getCameraMode() == 2 && !useFront) {
            Nimble.setCameraMode(0);
        }
        if (Nimble.getCameraMode() == 0) {
            actualCameraMode = 0;
            if (distance > 0.0f) {
                Nimble.setCameraMode(1);
            }
        } else if (distance == 0.0f) {
            actualCameraMode = 1;
        }
    }

    @SubscribeEvent
    public static void mountEvent(EntityMountEvent event) {
        if (ModConfig.nimbleMounting) {
            Minecraft mc = Minecraft.func_71410_x();
            if (event.getEntity() == mc.field_71439_g) {
                Nimble.setCameraMode(event.isMounting() ? 1 : 0);
            }
        }
    }

    private static void setCameraMode(int mode) {
        Minecraft.func_71410_x().field_71474_y.field_74320_O = mode;
        Nimble.resetView();
    }

    private static void resetView() {
        flag = !flag;
        Minecraft.func_71410_x().field_71439_g.field_70125_A = (float)((double)Minecraft.func_71410_x().field_71439_g.field_70125_A + (flag ? 1.0E-6 : -1.0E-6));
    }

    private static int getCameraMode() {
        return Minecraft.func_71410_x().field_71474_y.field_74320_O;
    }

    static {
        kbFrontView = new KeyBinding("nimble.keybind.frontView", 62, "nimble.gui.keygroup");
        useFront = false;
        flag = false;
        actualCameraMode = 0;
        distance = 0.0f;
        elytraFlying = false;
    }
}

