/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation;

import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.INameTaggable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.network.VanillaPacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockRightClickHandler {
    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tileEntity;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        if (BlockRightClickHandler.tryNameTile(player, world, pos, event.getItemStack())) {
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (!world.field_72995_K && player.func_70093_af() && (tileEntity = world.func_175625_s(pos)) != null && tileEntity.hasCapability(Capabilities.ROOT_FILTER, null)) {
            RefinedRelocationAPI.openRootFilterGui(player, tileEntity);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private static boolean tryNameTile(EntityPlayer player, World world, BlockPos pos, ItemStack heldItem) {
        if (heldItem.func_190926_b() || heldItem.func_77973_b() != Items.field_151057_cb) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        INameTaggable nameTaggable = (INameTaggable)tileEntity.getCapability(Capabilities.NAME_TAGGABLE, null);
        if (nameTaggable == null && tileEntity instanceof INameTaggable) {
            nameTaggable = (INameTaggable)tileEntity;
        }
        if (nameTaggable != null) {
            nameTaggable.setCustomName(heldItem.func_82833_r());
            VanillaPacketHandler.sendTileEntityUpdate(tileEntity);
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        return false;
    }
}

