/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.client.gui.GuiRootFilter;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiImageButton;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiFilterSlot;
import net.blay09.mods.refinedrelocation.container.ContainerRootFilter;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class GuiWhitelistButton
extends GuiImageButton {
    private final GuiRootFilter parentGui;
    private final GuiFilterSlot parentSlot;
    private boolean lastBlacklist;

    public GuiWhitelistButton(int x, int y, GuiRootFilter parentGui, GuiFilterSlot parentSlot) {
        super(x, y, "filter_whitelist");
        this.parentGui = parentGui;
        this.parentSlot = parentSlot;
        this.setSize(8, 8);
        this.setVisible(false);
    }

    @Override
    public void update() {
        super.update();
        boolean nowBlacklist = ((ContainerRootFilter)this.parentGui.getContainer()).getRootFilter().isBlacklist(this.parentSlot.getFilterIndex());
        if (this.lastBlacklist != nowBlacklist) {
            this.setButtonTexture(nowBlacklist ? "filter_blacklist" : "filter_whitelist");
            this.lastBlacklist = nowBlacklist;
        }
        this.setVisible(this.parentSlot.hasFilter());
    }

    @Override
    public void actionPerformed(int mouseButton) {
        boolean isBlacklist = !((ContainerRootFilter)this.parentGui.getContainer()).getRootFilter().isBlacklist(this.parentSlot.getFilterIndex());
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("FilterIndex", this.parentSlot.getFilterIndex());
        tagCompound.func_74757_a("Blacklist", isBlacklist);
        RefinedRelocationAPI.sendContainerMessageToServer("Blacklist", tagCompound);
        ((ContainerRootFilter)this.parentGui.getContainer()).getRootFilter().setIsBlacklist(this.parentSlot.getFilterIndex(), isBlacklist);
    }

    @Override
    public void addTooltip(List<String> list) {
        boolean nowBlacklist = ((ContainerRootFilter)this.parentGui.getContainer()).getRootFilter().isBlacklist(this.parentSlot.getFilterIndex());
        list.add(TextFormatting.WHITE + (nowBlacklist ? I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.blacklist", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.whitelist", (Object[])new Object[0])));
        list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.click_to_toggle", (Object[])new Object[0]));
    }
}

