/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.compat.ironchest;

import com.google.common.primitives.SignedBytes;
import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocationConfig;
import net.blay09.mods.refinedrelocation.client.render.ModelLidOverlay;
import net.blay09.mods.refinedrelocation.client.render.RenderUtils;
import net.blay09.mods.refinedrelocation.client.render.SafeTESR;
import net.blay09.mods.refinedrelocation.compat.ironchest.TileSortingIronChest;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class RenderSortingIronChest
extends SafeTESR<TileSortingIronChest> {
    private static final ResourceLocation[] OVERLAY = new ResourceLocation[]{new ResourceLocation("refinedrelocation", "textures/blocks/iron_chest_overlay.png"), new ResourceLocation("refinedrelocation", "textures/blocks/gold_chest_overlay.png"), new ResourceLocation("refinedrelocation", "textures/blocks/diamond_chest_overlay.png"), new ResourceLocation("refinedrelocation", "textures/blocks/copper_chest_overlay.png"), new ResourceLocation("refinedrelocation", "textures/blocks/silver_chest_overlay.png"), new ResourceLocation("refinedrelocation", "textures/blocks/crystal_chest_overlay.png"), new ResourceLocation("refinedrelocation", "textures/blocks/obsidian_chest_overlay.png"), new ResourceLocation("refinedrelocation", "textures/blocks/dirt_chest_overlay.png")};
    private static float[][] shifts = new float[][]{{0.3f, 0.45f, 0.3f}, {0.7f, 0.45f, 0.3f}, {0.3f, 0.45f, 0.7f}, {0.7f, 0.45f, 0.7f}, {0.3f, 0.1f, 0.3f}, {0.7f, 0.1f, 0.3f}, {0.3f, 0.1f, 0.7f}, {0.7f, 0.1f, 0.7f}, {0.5f, 0.32f, 0.5f}};
    private static final float halfPI = 1.5707964f;
    private static EntityItem entityItem;
    private final Random random = new Random();
    private final ModelChest model = new ModelChest();
    private final ModelLidOverlay modelLidOverlay = new ModelLidOverlay();
    private RenderEntityItem itemRenderer;

    public RenderSortingIronChest(Block block) {
        super(block);
    }

    @Override
    protected void renderTileEntityAt(TileSortingIronChest tileEntity, double x, double y, double z, float partialTicks, int destroyStage, @Nullable IBlockState state) {
        if (tileEntity.func_145837_r()) {
            return;
        }
        EnumFacing facing = EnumFacing.SOUTH;
        IronChestType type = tileEntity.getType();
        if (state != null) {
            facing = tileEntity.getFacing();
            type = tileEntity.getType();
        }
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(type.modelTexture);
        }
        GlStateManager.func_179094_E();
        if (type == IronChestType.CRYSTAL) {
            GlStateManager.func_179129_p();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)RenderUtils.getFacingAngle(facing), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (type == IronChestType.CRYSTAL) {
            GlStateManager.func_179152_a((float)1.0f, (float)0.99f, (float)1.0f);
        }
        float lidAngle = tileEntity.prevLidAngle + (tileEntity.lidAngle - tileEntity.prevLidAngle) * partialTicks;
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        this.model.field_78234_a.field_78795_f = -lidAngle * 1.5707964f;
        this.model.func_78231_a();
        if (destroyStage == -1) {
            this.func_147499_a(OVERLAY[type.ordinal()]);
            this.modelLidOverlay.chestLid.field_78795_f = -lidAngle * 1.5707964f;
            this.modelLidOverlay.renderAll();
        }
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        if (type == IronChestType.CRYSTAL) {
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type == IronChestType.CRYSTAL && tileEntity.func_145835_a(this.field_147501_a.field_147560_j, this.field_147501_a.field_147561_k, this.field_147501_a.field_147558_l) < 128.0) {
            this.random.setSeed(254L);
            int shift = 0;
            float blockScale = 0.7f;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
            if (((ItemStack)tileEntity.getTopItems().get(1)).func_190926_b()) {
                shift = 8;
                blockScale = 0.85f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            if (entityItem == null) {
                entityItem = new EntityItem(this.func_178459_a());
            }
            RenderSortingIronChest.entityItem.field_70290_d = 0.0f;
            for (ItemStack item : tileEntity.getTopItems()) {
                if (shift > shifts.length) break;
                if (item.func_190926_b()) {
                    ++shift;
                    continue;
                }
                float shiftX = shifts[shift][0];
                float shiftY = shifts[shift][1];
                float shiftZ = shifts[shift][2];
                ++shift;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)shiftX, (float)shiftY, (float)shiftZ);
                GlStateManager.func_179114_b((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)blockScale, (float)blockScale, (float)blockScale);
                entityItem.func_92058_a(item);
                if (this.itemRenderer == null) {
                    this.itemRenderer = new RenderEntityItem(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()){

                        public int func_177078_a(ItemStack stack) {
                            return SignedBytes.saturatedCast((long)(Math.min(stack.func_190916_E() / 32, 15) + 1));
                        }

                        public boolean shouldBob() {
                            return false;
                        }

                        public boolean shouldSpreadItems() {
                            return true;
                        }
                    };
                }
                this.itemRenderer.func_76986_a(entityItem, 0.0, 0.0, 0.0, 0.0f, partialTicks);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    protected boolean shouldRenderNameTag(TileSortingIronChest tileEntity) {
        return tileEntity.func_145818_k_() && RefinedRelocationConfig.renderChestNameTags;
    }
}

