/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.client.IFilterIcon;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.client.ClientProxy;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SameModFilter
implements IFilter {
    public static final String ID = "refinedrelocation:same_mod_filter";

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileEntity tileEntity) {
        return tileEntity.hasCapability(Capabilities.SORTING_INVENTORY, null);
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack otherStack = itemHandler.getStackInSlot(i);
                if (otherStack.func_190926_b()) continue;
                if (itemStack.func_77973_b() == otherStack.func_77973_b()) {
                    return true;
                }
                String modId = itemStack.func_77973_b().getCreatorModId(itemStack);
                String otherModId = otherStack.func_77973_b().getCreatorModId(otherStack);
                if (modId == null && otherModId == null) {
                    return true;
                }
                if (modId == null || !modId.equals(otherModId)) continue;
                return true;
            }
        }
        return false;
    }

    public NBTBase serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTBase nbt) {
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:same_mod_filter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:same_mod_filter.description";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IFilterIcon getFilterIcon() {
        return ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:icon_same_mod_filter");
    }
}

