/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth;

import com.mactso.regrowth.config.MyConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;

public class RegrowthCommands
implements ICommand {
    public int compareTo(ICommand o) {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return "Gives Regrowth Info.";
    }

    public String func_71517_b() {
        return "/Regrowth";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(3, "SetDebugLevel");
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayer player = (EntityPlayer)sender;
            if (args[0].equalsIgnoreCase("info")) {
                RegrowthCommands.showInfo(player);
            } else if (args[0].equalsIgnoreCase("debug")) {
                RegrowthCommands.setDebugLevel(args, player);
            }
        }
    }

    public static void showInfo(EntityPlayer player) {
        int meta = 0;
        TextComponentString component = new TextComponentString("\n Current Values");
        component.func_150256_b().func_150238_a(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)component);
        IBlockState bs = player.field_70170_p.func_180495_p(player.func_180425_c());
        Block block = bs.func_177230_c();
        meta = block.func_176201_c(bs);
        if (block instanceof BlockAir) {
            bs = player.field_70170_p.func_180495_p(player.func_180425_c().func_177977_b());
            block = bs.func_177230_c();
            meta = block.func_176201_c(bs);
        }
        String blockKey = block.getRegistryName().toString() + ">" + meta;
        component = new TextComponentString("\n  Standing On.............: " + blockKey + "\n  Debug Level...........: " + MyConfig.aDebugLevel);
        component.func_150256_b().func_150238_a(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)component);
    }

    public static void setDebugLevel(String[] args, EntityPlayer player) {
        if (args[1] != null) {
            int debugLevel = MyConfig.aDebugLevel;
            try {
                debugLevel = Integer.valueOf(args[1]);
                if (debugLevel >= 0 && debugLevel <= 2) {
                    MyConfig.setaDebugLevel(debugLevel);
                    ConfigManager.sync((String)"regrowth", (Config.Type)Config.Type.INSTANCE);
                    TextComponentString component = new TextComponentString("Debug Value set to : " + debugLevel);
                    component.func_150256_b().func_150238_a(TextFormatting.GREEN);
                    player.func_145747_a((ITextComponent)component);
                    if (MyConfig.getaDebugLevel() > 0) {
                        System.out.println(component.toString());
                    }
                }
            }
            catch (NumberFormatException e) {
                TextComponentString component = new TextComponentString("Debug Values should be : 0 to 2");
                component.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)component);
            }
        }
    }

    public List<String> func_71514_a() {
        ArrayList<String> commandAliases = new ArrayList<String>();
        commandAliases.add("regrowth");
        commandAliases.add("/regrowth");
        return commandAliases;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> commandTabCompletions = new ArrayList<String>();
        commandTabCompletions.add("info");
        commandTabCompletions.add("debug");
        return commandTabCompletions;
    }
}

