/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="regrowth")
@Mod.EventBusSubscriber
public class MyConfig {
    @Config.Comment(value={"Debug Level"})
    @Config.Name(value="Debug Level   0 to 2 : 'Off', 'Log', 'Chat & Log'")
    @Config.RangeInt(min=0, max=2)
    public static int aDebugLevel = 0;
    @Config.Comment(value={"Improve Torch Light Level"})
    @Config.Name(value="Improve Torch Light Level 1 to 10 ")
    @Config.RangeInt(min=1, max=10)
    public static int improveTorchLightLevel = 9;
    @Config.Comment(value={"Mushroom Density Along X Coordinate."})
    @Config.Name(value="mushroomDensityX")
    @Config.RangeInt(min=3, max=11)
    private static int mushroomXDensity = 6;
    @Config.Comment(value={"Mushroom Density Along Z Coordinate."})
    @Config.Name(value="mushroomDensityZ")
    @Config.RangeInt(min=3, max=11)
    private static int mushroomZDensity = 6;
    @Config.Comment(value={"Mushroom Minimum Biome Temperature"})
    @Config.Name(value="MushroomMinTemp")
    @Config.RangeDouble(min=-2.0, max=2.0)
    private static double mushroomMinTemp = 0.2;
    @Config.Comment(value={"Mushroom Maximum Biome Temperature"})
    @Config.Name(value="MushroomMaxTemp")
    @Config.RangeDouble(min=-2.0, max=2.0)
    private static double mushroomMaxTemp = 1.2;
    @Config.Comment(value={"Eating Heals: 0-No, 1-yes"})
    @Config.Name(value="eatingHeals")
    @Config.RangeDouble(min=1.0, max=11.0)
    public static double aEatingHeals = 0.99;
    @Config.Comment(value={"Regrowth Mobs and Actions"})
    @Config.Name(value="Regrowth Mobs and Actions:")
    public static String[] defaultRegrowthMobs = new String[]{"minecraft:cow,both,480.0", "minecraft:horse,eat,360.0", "minecraft:donkey,eat,360.0", "minecraft:sheep,eat,240.0", "minecraft:pig,reforest,900.0", "minecraft:bee,grow,1000.0", "minecraft:chicken,grow,640.0", "minecraft:villager,crwplvt,5.0", "minecraft:creeper,tall,120.0", "minecraft:zombie,stumble, 60.0", "minecraft:bat,stumble, 60.0", "minecraft:skeleton,mushroom, 60.0"};
    @Config.Comment(value={"List of Wall Foundation Blocks"})
    @Config.Name(value="Wall Foundation Block List:")
    public static String[] defaultWallFoundations = new String[]{"minecraft:grass>0", "minecraft:sand>0", "minecraft:sand>1", "minecraft:netherrack>0", "minecraft:sandstone>0", "minecraft:podzol>2", "minecraft:dirt>0", "minecraft:stone>0", "minecraft:dirt>1"};
    @Config.Comment(value={"List of Wall Block Definitions By Biome"})
    @Config.Name(value="Biome Wall Block List:")
    public static String[] defaultWallBiomeData = new String[]{"Regrowth:default,48,minecraft:cobblestone_wall", "minecraft:plains,48,minecraft:cobblestone_wall", "minecraft:desert,48,minecraft:fence", "minecraft:extreme_hills,48,minecraft:cobblestone_wall", "minecraft:taiga,48,minecraft:cobblestone_wall", "minecraft:savanna,48,minecraft:fence", "minecraft:icy,40,minecraft:cobblestone_wall", "minecraft:the_end,40,minecraft:cobblestone_wall", "minecraft:beach,48,minecraft:fence", "minecraft:forest,48,minecraft:cobblestone_wall", "minecraft:mesa,48,minecraft:cobblestone_wall", "minecraft:jungle,48,minecraft:cobblestone_wall", "minecraft:river,48,minecraft:cobblestone_wall", "minecraft:nether,40,minecraft:cobblestone_wall"};
    @Config.Ignore
    public static boolean serverSide = false;

    public static int getaDebugLevel() {
        return aDebugLevel;
    }

    public static void setaDebugLevel(int aDebugLevel) {
        MyConfig.aDebugLevel = aDebugLevel;
    }

    public static int getImproveTorchLightLevel() {
        return improveTorchLightLevel;
    }

    public static double getaEatingHeals() {
        return aEatingHeals;
    }

    public static void setaEatingHeals(double aEatingHeals) {
        MyConfig.aEatingHeals = aEatingHeals;
    }

    public static int getMushroomXDensity() {
        return mushroomXDensity;
    }

    public static int getMushroomZDensity() {
        return mushroomZDensity;
    }

    public static double getMushroomMinTemp() {
        return mushroomMinTemp;
    }

    public static double getMushroomMaxTemp() {
        return mushroomMaxTemp;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("regrowth")) {
            RegrowthEntitiesManager.regrowthMobInit();
            WallFoundationDataManager.wallFoundationsInit();
            WallBiomeDataManager.wallBiomeDataInit();
            if (serverSide && aDebugLevel > 0) {
                System.out.println("Server: Regrowth ConfigurationChangedEvent.");
            }
            if (!serverSide && aDebugLevel > 0) {
                System.out.println("Client: Regrowth ConfigurationChangedEvent.");
            }
        }
    }

    public static void debugMsg(int level, String dMsg) {
        if (aDebugLevel > level - 1) {
            System.out.println("L" + level + ":" + dMsg);
        }
    }

    public static void debugMsg(int level, BlockPos pos, String dMsg) {
        if (aDebugLevel > level - 1) {
            System.out.println("L" + level + " (" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "): " + dMsg);
        }
    }

    public static void sendChat(EntityPlayer p, String chatMessage, TextFormatting textColor) {
        TextComponentString component = new TextComponentString(chatMessage);
        component.func_150256_b().func_150238_a(textColor);
        p.func_145747_a((ITextComponent)component);
    }

    public static void sendBoldChat(EntityPlayer p, String chatMessage, TextFormatting textColor) {
        TextComponentString component = new TextComponentString(chatMessage);
        component.func_150256_b().func_150227_a(Boolean.valueOf(true));
        component.func_150256_b().func_150238_a(textColor);
        p.func_145747_a((ITextComponent)component);
    }
}

