/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.events;

import com.mactso.regrowth.config.MyConfig;
import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MoveEntityEvent {
    private static int TICKS_PER_SECOND = 20;
    private static int[][] facingArray = new int[][]{{0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}};
    static final int WALL_CENTER = 0;
    static final int WALL_TYPE_WALL = -1;
    static final IBlockState RED_STEM = Blocks.field_150419_aX.func_176203_a(BlockHugeMushroom.EnumType.STEM.func_176896_a());
    static final IBlockState BROWN_STEM = Blocks.field_150420_aW.func_176203_a(BlockHugeMushroom.EnumType.STEM.func_176896_a());
    static final IBlockState OAK_SAPLING = Blocks.field_150345_g.func_176203_a(0);
    static final IBlockState SPRUCE_SAPLING = Blocks.field_150345_g.func_176203_a(1);
    static final IBlockState BIRCH_SAPLING = Blocks.field_150345_g.func_176203_a(2);
    static final IBlockState JUNGLE_SAPLING = Blocks.field_150345_g.func_176203_a(3);
    static final IBlockState ACACIA_SAPLING = Blocks.field_150345_g.func_176203_a(4);
    static final IBlockState DARK_OAK_SAPLING = Blocks.field_150345_g.func_176203_a(5);

    private void helperAgeChildEntity(Entity ent) {
        EntityAgeable aEnt;
        if (ent instanceof EntityAgeable && (aEnt = (EntityAgeable)ent).func_70631_g_()) {
            aEnt.func_70873_a(aEnt.func_70874_b() + 30);
        }
    }

    private boolean mobEatPlantsAction(Entity eventEntity, Block footBlock, Block groundBlock, String key, String regrowthType, double regrowthEventOdds, double randomD100Roll) {
        double eatingOdds = regrowthEventOdds;
        boolean ate = false;
        if (regrowthType.contentEquals("both")) {
            eatingOdds = regrowthEventOdds * 15.0;
        }
        if (eventEntity instanceof AbstractHorse) {
            AbstractHorse h = (AbstractHorse)eventEntity;
            eatingOdds = !h.func_110204_cc() ? 0.0 : regrowthEventOdds * 25.0;
        }
        if (randomD100Roll <= eatingOdds && this.mobEatGrassOrFlower(eventEntity, regrowthType, footBlock, groundBlock)) {
            MyConfig.debugMsg(2, this.helperGetBlockPos(eventEntity), key + " ate plants. ");
            ate = true;
        }
        return ate;
    }

    @SubscribeEvent
    public void handleEntityMoveEvents(LivingEvent.LivingUpdateEvent event) {
        MyConfig.setaDebugLevel(0);
        if (event.getEntity() == null) {
            return;
        }
        Entity eventEntity = event.getEntity();
        if (EntityList.func_191301_a((Entity)eventEntity) == null) {
            return;
        }
        String registryNameAsString = EntityList.func_191301_a((Entity)eventEntity).toString();
        World world = eventEntity.field_70170_p;
        if (world == null) {
            return;
        }
        if (!(world instanceof WorldServer)) {
            return;
        }
        IBlockState footIBlockState = world.func_180495_p(this.helperGetBlockPos(eventEntity));
        if (footIBlockState == null) {
            return;
        }
        Block footBlock = footIBlockState.func_177230_c();
        if (footBlock == null) {
            return;
        }
        IBlockState groundIBlockState = null;
        Block groundBlock = null;
        if (footBlock == Blocks.field_185774_da) {
            groundIBlockState = footIBlockState;
            groundBlock = footBlock;
        } else {
            groundIBlockState = world.func_180495_p(this.helperGetBlockPos(eventEntity).func_177977_b());
            if (groundIBlockState == null) {
                return;
            }
            groundBlock = groundIBlockState.func_177230_c();
        }
        if (groundBlock == null) {
            return;
        }
        if (eventEntity instanceof EntityBat) {
            // empty if block
        }
        BlockPos ePos = this.helperGetBlockPos(eventEntity);
        Biome localBiome = world.func_180494_b(ePos);
        RegrowthEntitiesManager.RegrowthMobItem currentRegrowthMobItem = RegrowthEntitiesManager.getRegrowthMobInfo(registryNameAsString);
        if (currentRegrowthMobItem == null) {
            return;
        }
        String regrowthActions = currentRegrowthMobItem.getRegrowthActions();
        if (this.isImpossibleRegrowthEvent(footBlock, regrowthActions)) {
            return;
        }
        double regrowthEventOdds = 2.0 / currentRegrowthMobItem.getRegrowthEventSeconds() * (double)TICKS_PER_SECOND;
        double randomD100Roll = eventEntity.field_70170_p.field_73012_v.nextDouble() * 100.0;
        if (randomD100Roll <= regrowthEventOdds && eventEntity instanceof EntityVillager) {
            this.doVillagerRegrowthEvents(eventEntity, footBlock, groundBlock, ePos, registryNameAsString, regrowthActions, localBiome);
        }
        this.doMobRegrowthEvents(eventEntity, footBlock, groundBlock, registryNameAsString, regrowthActions, regrowthEventOdds, randomD100Roll, localBiome);
    }

    private boolean mobGrowPlantsAction(Entity eventEntity, Block footBlock, Block groundBlock, String key) {
        IGrowable ib;
        boolean triedToGrow = false;
        if (footBlock instanceof BlockAir && (ib = (IGrowable)groundBlock) != null) {
            BlockPos ePos = this.helperGetBlockPos(eventEntity);
            ib.func_176474_b((World)((WorldServer)eventEntity.field_70170_p), eventEntity.field_70170_p.field_73012_v, this.helperGetBlockPos(eventEntity), eventEntity.field_70170_p.func_180495_p(this.helperGetBlockPos(eventEntity)));
            MyConfig.debugMsg(2, ePos, key + " tried to grow plants.");
            triedToGrow = true;
        }
        return triedToGrow;
    }

    private void helperHealEntity(Entity ent, int amt) {
        EntityLiving lEnt = (EntityLiving)ent;
        if (lEnt.func_110138_aP() > lEnt.func_110143_aJ() && MyConfig.aEatingHeals == 1.0) {
            PotionEffect ei = new PotionEffect(Potion.func_188412_a((int)6), amt, 0, false, true);
            lEnt.func_70690_d(ei);
        }
    }

    private void doMobRegrowthEvents(Entity ent, Block footBlock, Block groundBlock, String key, String regrowthType, double regrowthEventOdds, double randomD100Roll, Biome localBiome) {
        BlockPos ePos = this.helperGetBlockPos(ent);
        World world = ent.field_70170_p;
        if (footBlock instanceof BlockTorch && randomD100Roll <= regrowthEventOdds) {
            if (regrowthType.equals("stumble")) {
                this.mobStumbleAction(ent, key, world);
            }
            return;
        }
        if (regrowthType.equals("mushroom") && randomD100Roll <= 0.1 + regrowthEventOdds) {
            this.mobGrowMushroomsAction(ent, groundBlock, key, world);
            return;
        }
        if (regrowthType.equals("reforest") && randomD100Roll <= regrowthEventOdds) {
            this.mobReforestAction(ent, footBlock, groundBlock, key, localBiome);
            return;
        }
        if (!(groundBlock instanceof BlockGrass)) {
            return;
        }
        if (!(footBlock instanceof BlockAir)) {
            if (regrowthType.equals("tall") && randomD100Roll <= regrowthEventOdds) {
                this.mobGrowTallAction(ent, footBlock, key);
                return;
            }
            if ((regrowthType.contentEquals("eat") || regrowthType.contentEquals("both")) && this.mobEatPlantsAction(ent, footBlock, groundBlock, key, regrowthType, regrowthEventOdds, randomD100Roll)) {
                return;
            }
        }
        if (footBlock instanceof BlockAir && (regrowthType.equals("grow") || regrowthType.equals("both")) && randomD100Roll <= regrowthEventOdds && this.mobGrowPlantsAction(ent, footBlock, groundBlock, key)) {
            return;
        }
    }

    private void mobGrowMushroomsAction(Entity ent, Block groundBlock, String key, World world) {
        BlockPos ePos = this.helperGetBlockPos(ent);
        int eX = ePos.func_177958_n();
        int eY = ePos.func_177956_o();
        int eZ = ePos.func_177952_p();
        if (world.func_175678_i(ePos)) {
            return;
        }
        float temp = world.func_180494_b(ePos).func_180626_a(ePos);
        if ((double)temp < MyConfig.getMushroomMinTemp()) {
            return;
        }
        if ((double)temp > MyConfig.getMushroomMaxTemp()) {
            return;
        }
        MyConfig.debugMsg(1, ePos, key + " Biome temp: " + temp + ".");
        if (Math.abs(eX + eZ + eY) % MyConfig.getMushroomXDensity() != 1) {
            return;
        }
        if ((Math.abs(eX) + Math.abs(eZ)) % MyConfig.getMushroomZDensity() == 1) {
            return;
        }
        if (this.helperCountBlocksOrthagonalBB(Blocks.field_150420_aW, 1, world, ePos, 1) > 0) {
            return;
        }
        if (this.helperCountBlocksOrthagonalBB(Blocks.field_150419_aX, 1, world, ePos, 1) > 0) {
            return;
        }
        for (int mY = -1; mY < 7; ++mY) {
            for (int mX = -5; mX < 6; ++mX) {
                for (int mZ = -5; mZ < 6; ++mZ) {
                    if (!(world.func_180495_p(new BlockPos(mX, mY, mZ)).func_177230_c() instanceof BlockMushroom)) continue;
                    MyConfig.debugMsg(1, ePos, key + " mushroom too crowded.");
                    return;
                }
            }
        }
        boolean growMushroom = false;
        if (groundBlock == Blocks.field_150348_b) {
            growMushroom = true;
        }
        for (EntityPlayer player : world.field_73010_i) {
            if (!(ePos.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) < 144.0)) continue;
            growMushroom = false;
        }
        if (growMushroom) {
            boolean red = false;
            BlockPos mtBP = this.helperGetBlockPos(ent);
            ent.field_70159_w += 0.5;
            ent.field_70181_x += -0.3;
            ent.field_70179_y += -0.3;
            world.func_175656_a(mtBP.func_177977_b(), Blocks.field_150391_bh.func_176223_P());
            if (world.field_73012_v.nextDouble() * 100.0 > 75.0) {
                world.func_175656_a(mtBP, Blocks.field_150337_Q.func_176223_P());
                red = true;
            } else {
                world.func_175656_a(mtBP, Blocks.field_150338_P.func_176223_P());
            }
            BlockMushroom mb = (BlockMushroom)world.func_180495_p(this.helperGetBlockPos(ent)).func_177230_c();
            mb.func_176474_b(world, world.field_73012_v, mtBP, world.func_180495_p(this.helperGetBlockPos(ent)));
            if (red) {
                for (int y = 9; y > 2; --y) {
                    if (world.func_180495_p(mtBP.func_177981_b(y)) != RED_STEM) continue;
                    world.func_175656_a(mtBP.func_177981_b(y), Blocks.field_150426_aN.func_176223_P());
                    break;
                }
            }
        }
        MyConfig.debugMsg(1, ePos, key + " grow mushroom.");
    }

    private void mobReforestAction(Entity ent, Block footBlock, Block groundBlock, String key, Biome localBiome) {
        if (footBlock != Blocks.field_150350_a) {
            return;
        }
        if (!(groundBlock instanceof BlockGrass) && !(groundBlock instanceof BlockDirt)) {
            return;
        }
        BlockPos ePos = this.helperGetBlockPos(ent);
        int eX = ePos.func_177958_n();
        int eY = ePos.func_177956_o();
        int eZ = ePos.func_177952_p();
        if (Math.abs(eX) % 2 + Math.abs(eZ) % 2 != 0) {
            return;
        }
        double sinY = Math.sin((double)((eY + 64) % 256) / 256.0);
        if (ent.field_70170_p.field_73012_v.nextDouble() > Math.abs(sinY)) {
            return;
        }
        IBlockState sapling = null;
        if ((sapling = this.helperSaplingState(ePos, localBiome, sapling)) == null) {
            return;
        }
        if (this.helperCountBlocksBB(Blocks.field_150345_g, 1, ent.field_70170_p, ePos, 5, 0) > 0) {
            return;
        }
        int leafCount = 0;
        if (sapling == ACACIA_SAPLING || sapling == DARK_OAK_SAPLING) {
            leafCount = this.helperCountBlocksBB((Block)Blocks.field_150361_u, 1, ent.field_70170_p, ePos.func_177981_b(5), 7, 0);
            if (leafCount > 0) {
                leafCount = this.helperCountBlocksBB((Block)Blocks.field_150361_u, 1, ent.field_70170_p, ePos.func_177981_b(6), 7, 0);
            }
        } else {
            leafCount = this.helperCountBlocksBB((Block)Blocks.field_150362_t, 1, ent.field_70170_p, ePos.func_177981_b(4), 7, 0);
        }
        if (leafCount > 0) {
            return;
        }
        ent.field_70170_p.func_175656_a(ePos, sapling);
        MyConfig.debugMsg(1, ePos, key + " planted sapling.");
    }

    private void mobStumbleAction(Entity eventEntity, String key, World sWorld) {
        BlockPos ePos = this.helperGetBlockPos(eventEntity);
        int eX = ePos.func_177958_n();
        int eY = ePos.func_177956_o();
        int eZ = ePos.func_177952_p();
        sWorld.func_175655_b(ePos, true);
        MyConfig.debugMsg(1, ePos, key + " stumbled over torch.");
    }

    private void mobGrowTallAction(Entity eventEntity, Block footBlock, String key) {
        BlockPos ePos;
        if (footBlock instanceof BlockTallGrass && this.helperCountBlocksBB((Block)Blocks.field_150398_cm, 3, eventEntity.field_70170_p, ePos = this.helperGetBlockPos(eventEntity), 5, 1) < 3) {
            this.mobGrowTallGrassToDoubleGrass(eventEntity, footBlock);
            MyConfig.debugMsg(1, ePos, key + " grew and hid in tall plant.");
        }
    }

    private void mobTrodGrassBlock(World world, Block groundBlock, BlockPos ePos) {
        if (groundBlock instanceof BlockGrass) {
            int dirtCount = 0;
            world.func_175656_a(ePos.func_177977_b(), Blocks.field_150346_d.func_176223_P());
            if (this.isBlockGrassPathOrDirt(world.func_180495_p(ePos.func_177965_g(1)).func_177230_c())) {
                ++dirtCount;
            }
            if (this.isBlockGrassPathOrDirt(world.func_180495_p(ePos.func_177985_f(1)).func_177230_c())) {
                ++dirtCount;
            }
            if (this.isBlockGrassPathOrDirt(world.func_180495_p(ePos.func_177964_d(1)).func_177230_c())) {
                ++dirtCount;
            }
            if (this.isBlockGrassPathOrDirt(world.func_180495_p(ePos.func_177970_e(1)).func_177230_c())) {
                ++dirtCount;
            }
            if (dirtCount == 4) {
                world.func_175656_a(ePos, Blocks.field_185774_da.func_176223_P());
            }
        }
    }

    private void doVillagerRegrowthEvents(Entity eventEntity, Block footBlock, Block groundBlock, BlockPos eventEntityPos, String key, String regrowthType, Biome localBiome) {
        EntityVillager ve = (EntityVillager)eventEntity;
        if (!this.isOnGround((Entity)ve)) {
            return;
        }
        if (footBlock.getRegistryName().toString().equals("minecraft:snow_layer")) {
            footBlock = Blocks.field_150350_a;
        }
        if (regrowthType.contains("v")) {
            this.vImproveLeaves(ve, groundBlock, key);
        }
        if (regrowthType.contains("c")) {
            this.vImproveGrass(ve, footBlock, key);
        }
        if (regrowthType.contains("r")) {
            this.vImproveRoads(ve, footBlock, groundBlock, key, localBiome);
        }
        if (regrowthType.contains("w")) {
            this.vImproveWalls(ve, footBlock, groundBlock, key, regrowthType, localBiome);
        }
        if (regrowthType.contains("t")) {
            this.vImproveLighting(ve, footBlock, groundBlock, localBiome);
        }
    }

    private boolean mobEatGrassOrFlower(Entity ent, String regrowthType, Block footBlock, Block groundBlock) {
        BlockPos ePos = this.helperGetBlockPos(ent);
        MyConfig.debugMsg(2, ePos, "entityEatGrassOrFlower");
        if (!this.isGrassOrFlower(footBlock)) {
            return false;
        }
        if (!regrowthType.equals("eat") && !regrowthType.equals("both")) {
            return false;
        }
        World world = ent.field_70170_p;
        ent.field_70170_p.func_175655_b(ePos, false);
        double randomD100Roll = ent.field_70170_p.field_73012_v.nextDouble() * 100.0;
        if (randomD100Roll > 40.0) {
            this.mobTrodGrassBlock(world, groundBlock, ePos);
        }
        this.helperAgeChildEntity(ent);
        this.helperHealEntity(ent, 1);
        return true;
    }

    private boolean mobGrowTallGrassToDoubleGrass(Entity eventEntity, Block footBlock) {
        if (footBlock instanceof BlockTallGrass) {
            IGrowable ib = (IGrowable)footBlock;
            ib.func_176474_b((World)((WorldServer)eventEntity.field_70170_p), eventEntity.field_70170_p.field_73012_v, this.helperGetBlockPos(eventEntity), eventEntity.field_70170_p.func_180495_p(this.helperGetBlockPos(eventEntity)));
            return true;
        }
        return false;
    }

    private IBlockState helperBiomeRoadBlockType(Biome localBiome) {
        IBlockState roadBlockType = Blocks.field_185774_da.func_176223_P();
        if (localBiome instanceof BiomeDesert) {
            roadBlockType = Blocks.field_150351_n.func_176223_P();
        }
        return roadBlockType;
    }

    private BlockPos helperGetBlockPos(Entity e) {
        return e.func_180425_c();
    }

    public int helperCountBlocksBB(Block searchBlock, int maxCount, World w, BlockPos bPos, int boxSize) {
        return this.helperCountBlocksBB(searchBlock, maxCount, w, bPos, boxSize, boxSize);
    }

    public int helperCountBlocksBB(Block searchBlock, int maxCount, World w, BlockPos bPos, int boxSize, int ySize) {
        int count = 0;
        int minX = bPos.func_177958_n() - boxSize;
        int maxX = bPos.func_177958_n() + boxSize;
        int minZ = bPos.func_177952_p() - boxSize;
        int maxZ = bPos.func_177952_p() + boxSize;
        int minY = bPos.func_177956_o() - ySize;
        int maxY = bPos.func_177956_o() + ySize;
        int dx = minX;
        while (dx <= maxX) {
            int dz = minZ;
            while (dz <= maxZ) {
                for (int dy = minY; dy <= maxY; ++dy) {
                    Block b = w.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c();
                    MyConfig.debugMsg(2, "dx:" + dx + ", dz:" + dz + ", dy:" + dy + "  Block:" + b.getRegistryName().toString() + ", count:" + count);
                    if (w.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c() == searchBlock) {
                        ++count;
                    }
                    if (count < maxCount) continue;
                    return count;
                }
                int n = dz++;
            }
            int n = dx++;
        }
        MyConfig.debugMsg(1, bPos, searchBlock.getRegistryName().toString() + " Sparse count:" + count + " countBlockBB ");
        return count;
    }

    public int helperCountBlocksOrthagonalBB(Block searchBlock, int maxCount, World w, BlockPos bPos, int boundY) {
        return this.helperCountBlocksOrthagonalBB(searchBlock, maxCount, w, bPos, 0 - boundY, 0 + boundY);
    }

    public int helperCountBlocksOrthagonalBB(Block searchBlock, int maxCount, World w, BlockPos bPos, int lowerBoundY, int upperBoundY) {
        int count = 0;
        for (int j = lowerBoundY; j <= upperBoundY; ++j) {
            if (w.func_180495_p(bPos.func_177981_b(j).func_177965_g(1)).func_177230_c() == searchBlock) {
                ++count;
            }
            if (w.func_180495_p(bPos.func_177981_b(j).func_177985_f(1)).func_177230_c() == searchBlock) {
                ++count;
            }
            if (w.func_180495_p(bPos.func_177981_b(j).func_177964_d(1)).func_177230_c() == searchBlock) {
                ++count;
            }
            if (w.func_180495_p(bPos.func_177981_b(j).func_177970_e(1)).func_177230_c() == searchBlock) {
                ++count;
            }
            if (count < maxCount) continue;
            return count;
        }
        return count;
    }

    private BlockPos helperFindRealVillageCenter(EntityVillager ve) {
        BlockPos villagePos = ve.func_180486_cf();
        if (villagePos != BlockPos.field_177992_a) {
            int vCenterX = ve.func_180486_cf().func_177958_n();
            int vCenterY = ve.func_180486_cf().func_177956_o();
            int vCenterZ = ve.func_180486_cf().func_177952_p();
            if (ve.field_70170_p.func_180495_p(new BlockPos(vCenterX, 1, vCenterZ)).func_177230_c() != Blocks.field_150463_bK) {
                boolean villageMarkerFound = false;
                block0: for (int i = -9; i <= 9; ++i) {
                    for (int j = -9; j <= 9; ++j) {
                        if (ve.field_70170_p.func_180495_p(new BlockPos(vCenterX + i, 1, vCenterZ + j)).func_177230_c() != Blocks.field_150463_bK) continue;
                        vCenterX += i;
                        vCenterZ += j;
                        villageMarkerFound = true;
                        continue block0;
                    }
                }
                villagePos = new BlockPos(vCenterX, vCenterY, vCenterZ);
                if (!villageMarkerFound) {
                    ve.field_70170_p.func_175656_a(new BlockPos(vCenterX, 1, vCenterZ), Blocks.field_150463_bK.func_176223_P());
                }
            }
        }
        return villagePos;
    }

    private boolean helperPlaceWallPiece(EntityVillager ve, IBlockState gateBlockType, boolean buildCenterGate, IBlockState wallType, int absva) {
        if (absva == 0) {
            if (buildCenterGate) {
                ve.field_70170_p.func_175656_a(this.helperGetBlockPos((Entity)ve).func_177977_b(), gateBlockType);
                return true;
            }
            return false;
        }
        IBlockState b = ve.field_70170_p.func_180495_p(this.helperGetBlockPos((Entity)ve).func_177977_b());
        Block block = b.func_177230_c();
        if (block instanceof BlockAir || block instanceof BlockTallGrass || block instanceof BlockFlower || block instanceof BlockDoublePlant) {
            ve.field_70170_p.func_175656_a(this.helperGetBlockPos((Entity)ve).func_177977_b(), wallType);
        } else {
            ve.field_70170_p.func_175656_a(this.helperGetBlockPos((Entity)ve), wallType);
        }
        return true;
    }

    private boolean vImproveRoadsFixUnfinished(EntityVillager ve, Block groundBlock, Biome localBiome) {
        if (groundBlock instanceof BlockAir) {
            return false;
        }
        int fixHeight = 4;
        if (localBiome instanceof BiomeTaiga) {
            fixHeight = 6;
        }
        BlockPos vePos = this.helperGetBlockPos((Entity)ve);
        Block biomeRoadBlock = this.helperBiomeRoadBlockType(localBiome).func_177230_c();
        if (groundBlock != biomeRoadBlock && this.helperCountBlocksOrthagonalBB(biomeRoadBlock, 3, ve.field_70170_p, vePos, -1, fixHeight) > 2) {
            ve.field_70170_p.func_175656_a(this.helperGetBlockPos((Entity)ve).func_177977_b(), biomeRoadBlock.func_176223_P());
            return true;
        }
        return false;
    }

    private boolean vImproveRoadsSmoothHeight(EntityVillager ve, Block footBlock, Block groundBlock, Biome localBiome) {
        if (!(footBlock instanceof BlockAir)) {
            return false;
        }
        if (ve.field_70170_p.func_175642_b(EnumSkyBlock.SKY, this.helperGetBlockPos((Entity)ve)) < 14) {
            return false;
        }
        Block biomeRoadBlock = this.helperBiomeRoadBlockType(localBiome).func_177230_c();
        if (groundBlock != biomeRoadBlock) {
            return false;
        }
        IBlockState smoothingIBlockState = biomeRoadBlock.func_176223_P();
        Block smoothingBlock = biomeRoadBlock;
        BlockPos vePos = this.helperGetBlockPos((Entity)ve);
        if (this.helperCountBlocksOrthagonalBB(smoothingBlock, 1, ve.field_70170_p, vePos, 1, 5) > 0) {
            ve.field_70170_p.func_175656_a(vePos, smoothingIBlockState);
            ve.field_70159_w += 0.1;
            ve.field_70181_x += 0.6;
            ve.field_70179_y += 0.1;
            return true;
        }
        return false;
    }

    private boolean vImproveVillageWall(EntityVillager ve, String regrowthActions, BlockPos villageMeetingPlaceBlockPos, Block groundBlock, Block footBlock, Biome localBiome) {
        int absvz;
        int absvx;
        String key = localBiome.getRegistryName().toString();
        BlockPos vePos = this.helperGetBlockPos((Entity)ve);
        int veX = vePos.func_177958_n();
        int veY = vePos.func_177956_o();
        int veZ = vePos.func_177952_p();
        MyConfig.debugMsg(2, vePos, " Improve Walls Key: " + key + ".");
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem(key);
        int wallPerimeter = currentWallBiomeDataItem.getWallDiameter();
        if (wallPerimeter < 32) {
            wallPerimeter = 32;
        }
        if (wallPerimeter > 80) {
            wallPerimeter = 80;
        }
        if (this.isOnWallPerimeter(wallPerimeter = wallPerimeter / 2 - 1, absvx = Math.abs(veX - villageMeetingPlaceBlockPos.func_177958_n()), absvz = Math.abs(veZ - villageMeetingPlaceBlockPos.func_177952_p()))) {
            MyConfig.debugMsg(2, vePos, "Villager on wall perimeter " + wallPerimeter + ".");
            boolean buildWall = this.isOkayToBuildWallHere(ve, footBlock, groundBlock);
            if (buildWall) {
                boolean buildCenterGate;
                IBlockState wallTypeBlockState = currentWallBiomeDataItem.getWallBlockState();
                if (wallTypeBlockState == null) {
                    wallTypeBlockState = Blocks.field_150463_bK.func_176223_P();
                }
                IBlockState wallBlock = wallTypeBlockState;
                int wallTorchSpacing = (wallPerimeter + 1) / 4;
                IBlockState gateBlockType = this.helperBiomeRoadBlockType(localBiome);
                if (this.helperPlaceOneWallPiece(ve, regrowthActions, wallPerimeter, wallTorchSpacing, gateBlockType, buildCenterGate = true, wallBlock, absvx, absvz, groundBlock, footBlock)) {
                    MyConfig.debugMsg(2, vePos, "Villager built Wall .");
                    if (regrowthActions.contains("t") && this.isValidTorchLocation(wallPerimeter, wallTorchSpacing, absvx, absvz, ve.field_70170_p.func_180495_p(this.helperGetBlockPos((Entity)ve)).func_177230_c())) {
                        ve.field_70170_p.func_175656_a(this.helperGetBlockPos((Entity)ve).func_177984_a(), Blocks.field_150478_aa.func_176223_P());
                    }
                    if (footBlock instanceof BlockWall || footBlock instanceof BlockFence) {
                        float veYaw = ve.field_70177_z / 45.0f;
                        int facingNdx = Math.round(veYaw);
                        if (facingNdx < 0) {
                            facingNdx = Math.abs(facingNdx);
                        }
                        double dx = (double)facingArray[facingNdx %= 8][0] / 2.0;
                        double dz = (double)facingArray[facingNdx][1] / 2.0;
                        ve.field_70159_w = dx;
                        ve.field_70181_x = 0.55;
                        ve.field_70179_y = dz;
                    }
                    return true;
                }
                MyConfig.debugMsg(2, vePos, " Wall NOT built.");
            }
        } else if (footBlock instanceof BlockWall || footBlock instanceof BlockFence) {
            ve.field_70170_p.func_175655_b(vePos.func_177984_a(), false);
            ve.field_70170_p.func_175655_b(vePos, false);
        }
        return false;
    }

    private boolean isBlockGrassPathOrDirt(Block tempBlock) {
        return tempBlock == Blocks.field_185774_da || tempBlock == Blocks.field_150346_d;
    }

    private boolean isFootBlockOkayToBuildIn(Block footBlock) {
        return footBlock instanceof BlockAir || this.isGrassOrFlower(footBlock);
    }

    private boolean isGrassOrFlower(Block footBlock) {
        if (footBlock instanceof BlockFlower) {
            return true;
        }
        if (footBlock instanceof BlockTallGrass) {
            return true;
        }
        return footBlock instanceof BlockDoublePlant;
    }

    private boolean isImpossibleRegrowthEvent(Block footBlock, String regrowthType) {
        if (regrowthType.equals("eat") && footBlock instanceof BlockAir) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof BlockTallGrass) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof BlockFlower) {
            return true;
        }
        return regrowthType.equals("tall") && !(footBlock instanceof BlockTallGrass);
    }

    private boolean isOkayToBuildWallHere(EntityVillager ve, Block footBlock, Block groundBlock) {
        boolean okayToBuildWalls = true;
        if (!this.isOnGround((Entity)ve)) {
            okayToBuildWalls = false;
        }
        if (!this.isFootBlockOkayToBuildIn(footBlock)) {
            okayToBuildWalls = false;
        }
        if (!this.isValidGroundBlockToBuildWallOn(ve, groundBlock)) {
            okayToBuildWalls = false;
        }
        return okayToBuildWalls;
    }

    private boolean isOnGround(Entity e) {
        return e.field_70122_E;
    }

    private boolean isOnWallPerimeter(int wallPerimeter, int absvx, int absvz) {
        boolean scratch = false;
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            scratch = true;
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            scratch = true;
        }
        return scratch;
    }

    private boolean isValidGroundBlockToBuildWallOn(EntityVillager ve, Block groundBlock) {
        int blockSkyLightValue = ve.field_70170_p.func_175642_b(EnumSkyBlock.SKY, this.helperGetBlockPos((Entity)ve));
        if (blockSkyLightValue < 13) {
            return false;
        }
        String key = groundBlock.getRegistryName().toString();
        WallFoundationDataManager.WallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private boolean isValidGroundBlockToPlaceTorchOn(EntityVillager ve, Block groundBlock) {
        String key = groundBlock.getRegistryName().toString();
        if (key.equals("minecraft:cobblestone")) {
            return true;
        }
        if (key.equals("minecraft:planks")) {
            return true;
        }
        WallFoundationDataManager.WallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private boolean isValidTorchLocation(int wallPerimeter, int wallTorchSpacing, int absvx, int absvz, Block wallBlockFence) {
        boolean hasAWallUnderIt = false;
        if (wallBlockFence instanceof BlockWall) {
            hasAWallUnderIt = true;
        }
        if (wallBlockFence instanceof BlockFence) {
            hasAWallUnderIt = true;
        }
        if (!hasAWallUnderIt) {
            return false;
        }
        if (absvx == wallPerimeter && absvz % wallTorchSpacing == 1) {
            return true;
        }
        if (absvx % wallTorchSpacing == 1 && absvz == wallPerimeter) {
            return true;
        }
        return absvx == wallPerimeter && absvz == wallPerimeter;
    }

    private boolean helperPlaceOneWallPiece(EntityVillager ve, String regrowthType, int wallPerimeter, int wallTorchSpacing, IBlockState gateBlockType, boolean buildCenterGate, IBlockState wallType, int absvx, int absvz, Block groundBlock, Block footBlock) {
        BlockPos vePos = this.helperGetBlockPos((Entity)ve);
        int veX = vePos.func_177958_n();
        int veY = vePos.func_177956_o();
        int veZ = vePos.func_177952_p();
        MyConfig.debugMsg(2, vePos, "placeOneWallPiece.");
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            MyConfig.debugMsg(2, "N / S placeWallHelper Z: " + veX + ", " + veY + ", " + veZ + ".");
            return this.helperPlaceWallPiece(ve, gateBlockType, buildCenterGate, wallType, absvz);
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            if (MyConfig.aDebugLevel > 1) {
                MyConfig.debugMsg(2, "E / W placeWallHelper X : " + veX + ", " + veY + ", " + veZ + ".");
            }
            return this.helperPlaceWallPiece(ve, gateBlockType, buildCenterGate, wallType, absvx);
        }
        return false;
    }

    private IBlockState helperSaplingState(BlockPos pos, Biome localBiome, IBlockState sapling) {
        if (localBiome.getRegistryName().func_110623_a().contains("roofed")) {
            sapling = OAK_SAPLING;
        }
        if (localBiome.getRegistryName().func_110623_a().contains("birch")) {
            sapling = BIRCH_SAPLING;
        }
        if (localBiome.getRegistryName().func_110623_a().contains("taiga")) {
            sapling = SPRUCE_SAPLING;
        }
        if (localBiome.getRegistryName().func_110623_a().contains("jungle")) {
            sapling = JUNGLE_SAPLING;
        }
        if (localBiome.getRegistryName().func_110623_a().contains("savanna")) {
            sapling = ACACIA_SAPLING;
        }
        if (localBiome.getRegistryName().func_110623_a().contains("forest")) {
            sapling = OAK_SAPLING;
        }
        if (localBiome.getRegistryName().func_110623_a().contains("plains")) {
            sapling = OAK_SAPLING;
        }
        return sapling;
    }

    private void vImproveGrass(EntityVillager ve, Block footBlock, String key) {
        BlockPos vePos = this.helperGetBlockPos((Entity)ve);
        int veX = vePos.func_177958_n();
        int veY = vePos.func_177956_o();
        int veZ = vePos.func_177952_p();
        if (footBlock instanceof BlockTallGrass || footBlock instanceof BlockDoublePlant) {
            ve.field_70170_p.func_175655_b(vePos, false);
            MyConfig.debugMsg(1, vePos, key + " cut grass.");
        }
    }

    private void vImproveLeaves(EntityVillager ve, Block groundBlock, String key) {
        BlockPos vePos = this.helperGetBlockPos((Entity)ve);
        int veX = vePos.func_177958_n();
        int veY = vePos.func_177956_o();
        int veZ = vePos.func_177952_p();
        float veYaw = ve.field_70177_z / 45.0f;
        int facingNdx = Math.round(veYaw);
        if (facingNdx < 0) {
            facingNdx = Math.abs(facingNdx);
        }
        int dx = facingArray[facingNdx %= 8][0];
        int dz = facingArray[facingNdx][1];
        BlockPos tmpBP = null;
        IBlockState tempBS = null;
        Block tempBlock = null;
        boolean destroyBlock = false;
        for (int iY = 0; iY < 2; ++iY) {
            tmpBP = new BlockPos(veX + dx, veY + iY, veZ + dz);
            tempBS = ve.field_70170_p.func_180495_p(tmpBP);
            tempBlock = tempBS.func_177230_c();
            if (tempBlock instanceof BlockLeaves) {
                destroyBlock = true;
                if (!((Boolean)tempBS.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
                    destroyBlock = false;
                }
            }
            if (tempBlock instanceof BlockCactus) {
                destroyBlock = true;
            }
            if (!destroyBlock) continue;
            ve.field_70170_p.func_175655_b(tmpBP, false);
            destroyBlock = false;
            MyConfig.debugMsg(2, key + " clear " + tempBlock.func_149732_F() + " at" + veX + ", " + (veY + iY) + ", " + veZ + ", ");
        }
    }

    private boolean vImproveLighting(EntityVillager ve, Block footBlock, Block groundBlock, Biome localBiome) {
        if (footBlock == Blocks.field_150478_aa) {
            return false;
        }
        int blockLightValue = ve.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, this.helperGetBlockPos((Entity)ve));
        if (blockLightValue >= MyConfig.getImproveTorchLightLevel()) {
            return false;
        }
        int skyLightValue = ve.field_70170_p.func_175642_b(EnumSkyBlock.SKY, this.helperGetBlockPos((Entity)ve));
        if (skyLightValue > 13) {
            return false;
        }
        if (this.isValidGroundBlockToPlaceTorchOn(ve, groundBlock) && footBlock instanceof BlockAir) {
            ve.field_70170_p.func_175656_a(this.helperGetBlockPos((Entity)ve), Blocks.field_150478_aa.func_176223_P());
        }
        return true;
    }

    private void vImproveRoads(EntityVillager ve, Block footBlock, Block groundBlock, String key, Biome localBiome) {
        BlockPos vePos = this.helperGetBlockPos((Entity)ve);
        if (this.vImproveRoadsFixUnfinished(ve, groundBlock, localBiome)) {
            MyConfig.debugMsg(1, vePos, key + " fix unfinished road spots.");
        }
        if (this.vImproveRoadsSmoothHeight(ve, footBlock, groundBlock, localBiome)) {
            MyConfig.debugMsg(1, vePos, key + " smooth road slopes.");
        }
    }

    private void vImproveWalls(EntityVillager ve, Block footBlock, Block groundBlock, String key, String regrowthType, Biome localBiome) {
        BlockPos vePos = this.helperGetBlockPos((Entity)ve);
        BlockPos villagePos = this.helperFindRealVillageCenter(ve);
        if (villagePos != BlockPos.field_177992_a) {
            MyConfig.debugMsg(2, villagePos, key + " Try to Improve Town Wall.");
            if (this.vImproveVillageWall(ve, regrowthType, villagePos, groundBlock, footBlock, localBiome)) {
                MyConfig.debugMsg(1, villagePos, key + " Improved Town Wall.");
            }
        }
    }
}

