/*
 * Decompiled with CFR 0.152.
 */
package shieldbreak.handlers;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="shieldbreak")
public class ModConfig {
    @Config.Comment(value={"Server Config"})
    @Config.Name(value="Server")
    public static final ServerConfig server = new ServerConfig();

    @Mod.EventBusSubscriber(modid="shieldbreak")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("shieldbreak")) {
                ConfigManager.sync((String)"shieldbreak", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ServerConfig {
        @Config.Comment(value={"Minimum amount of damage any shield will withstand before chance of cooldown."})
        @Config.Name(value="Damage Minimum Threshold")
        public float damageMinimumThreshold = 1.0f;
        @Config.Comment(value={"Maximum amount of damage any shield will withstand before chance of cooldown."})
        @Config.Name(value="Damage Maximum Threshold")
        public float damageMaximumThreshold = 20.0f;
        @Config.Comment(value={"Scaling for how much damage a shield will withstand before chance of cooldown based on max durability. (Durability/This = Damage)"})
        @Config.Name(value="Damage Durability Scaling")
        public float damageDurabilityScaling = 100.0f;
        @Config.Comment(value={"Minimum amount of cooldown ticks a shield break will cause."})
        @Config.Name(value="Cooldown Minimum Ticks")
        public int cooldownTicksMinimum = 10;
        @Config.Comment(value={"Maximum amount of cooldown ticks a shield break will cause."})
        @Config.Name(value="Cooldown Maximum Ticks")
        public int cooldownTicksMaximum = 200;
        @Config.Comment(value={"Multiplier for cooldown ticks per point of damage."})
        @Config.Name(value="Cooldown Ticks Scaling")
        public float cooldownTicksScaling = 10.0f;
        @Config.Comment(value={"Range for how long the shield can be held up and still parry the attack. (Counted after the initial shield delay, if any)"})
        @Config.Name(value="Parry Tick Range")
        public int parryTickRange = 10;
        @Config.Comment(value={"How much durability a shield should have for the purpose of scaling if it's max durability is 0."})
        @Config.Name(value="Shield Durability Fallback")
        public int unbreakableShieldDurability = 3000;
        @Config.Comment(value={"How many ticks should it take when raising a shield for it to become active."})
        @Config.Name(value="Shield Raise Tick Delay")
        public int shieldRaiseTickDelay = 5;
        @Config.Comment(value={"Base chance for a weapon that can break shields to ignore shield protection and cause a cooldown. (Ex. Axe and Halberd)"})
        @Config.Name(value="Shield Bypass Chance")
        public float shieldBypassChance = 0.25f;
        @Config.Comment(value={"How long should the cooldown be if a weapon that can break shields bypasses the shield. (Ex. Axe and Halberd)"})
        @Config.Name(value="Shield Bypass Cooldown")
        public int shieldBypassCooldown = 100;
    }
}

