/*
 * Decompiled with CFR 0.152.
 */
package alexiy.projectile.preview;

import alexiy.projectile.preview.Options;
import alexiy.projectile.preview.TP;
import alexiy.projectile.preview.api.PreviewEntity;
import alexiy.projectile.preview.api.PreviewProvider;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientEvents {
    @SubscribeEvent
    public void drawPreview(RenderGameOverlayEvent.Pre drawScreenEvent) {
        if (drawScreenEvent.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            World world = entityPlayer.field_70170_p;
            ItemStack rightStack = entityPlayer.func_184614_ca();
            Item item = rightStack.func_77973_b();
            Color currentColor = Color.decode("0x" + Options.pointColor1);
            Color color2 = Color.decode("0x" + Options.pointColor2);
            Class<? extends Entity> entityClass = null;
            for (PreviewProvider multipleAssociation : TP.previewProviders) {
                Class<? extends Entity> cl = multipleAssociation.getPreviewEntityFor((EntityPlayer)entityPlayer, item);
                if (cl == null) continue;
                entityClass = cl;
                break;
            }
            if (entityClass != null) {
                try {
                    Entity entity = (Entity)entityClass.getConstructor(World.class).newInstance(world);
                    if (entity instanceof PreviewEntity) {
                        PreviewEntity previewEntity = (PreviewEntity)entity;
                        Entity target = previewEntity.initializeEntity((EntityPlayer)entityPlayer, rightStack);
                        if (target != null) {
                            entity.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                            entity.field_70181_x = target.field_70181_x;
                            entity.field_70159_w = target.field_70159_w;
                            entity.field_70179_y = target.field_70179_y;
                            entity.field_70177_z = target.field_70177_z;
                            entity.field_70125_A = target.field_70125_A;
                            entity.field_70127_C = target.field_70127_C;
                            entity.field_70126_B = target.field_70126_B;
                            world.func_72838_d(entity);
                            ArrayList<Vec3d> trajectory = new ArrayList<Vec3d>(128);
                            int cycle = 0;
                            while (!entity.field_70128_L) {
                                previewEntity.simulateShot(target);
                                if (cycle > 512) break;
                                trajectory.add(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                                cycle = (short)(cycle + 1);
                            }
                            float scale = Options.pointScalingStep;
                            List<Object> subList = trajectory.size() > Options.previewStartPoint ? trajectory.subList(Options.previewStartPoint, trajectory.size()) : trajectory;
                            for (Vec3d vec3d : subList) {
                                Particle point = particleManager.func_178927_a(51, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                                if (point == null) continue;
                                point.func_82338_g(1.0f);
                                if (subList.indexOf(vec3d) % 2 == 0) {
                                    point.func_70538_b((float)currentColor.getRed() / 255.0f, (float)currentColor.getGreen() / 255.0f, (float)currentColor.getBlue() / 255.0f);
                                } else {
                                    point.func_70538_b((float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f);
                                }
                                if (!(entityPlayer.func_70011_f(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c) > (double)Options.pointsEnlargeAfterThisDistance)) continue;
                                point.func_70541_f(scale);
                                scale += Options.pointScalingStep;
                            }
                        }
                    } else {
                        FMLLog.log.warn("Class " + entityClass.getCanonicalName() + " doesn't implement PreviewEntity");
                    }
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

