/*
 * Decompiled with CFR 0.152.
 */
package alexiy.projectile.preview.tconstruct;

import alexiy.projectile.preview.api.Constants;
import alexiy.projectile.preview.api.InvisibleEntity;
import alexiy.projectile.preview.api.PreviewEntity;
import alexiy.projectile.preview.tconstruct.TinkersConstruct;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.library.traits.IProjectileTrait;

@InvisibleEntity
public class ProjectilePreview
extends Entity
implements PreviewEntity {
    private int ticksInAir;
    private Entity shootingEntity;

    public ProjectilePreview(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    @Override
    public Entity initializeEntity(EntityPlayer player, ItemStack associatedItem) {
        this.shootingEntity = player;
        if (associatedItem.func_77973_b() == TinkersConstruct.shuriken) {
            return TinkersConstruct.shuriken.getProjectile(associatedItem, associatedItem, player.field_70170_p, player, 2.1f, 0.0f, 1.0f, false);
        }
        if (associatedItem.func_77973_b() instanceof BowCore && (player.func_184605_cv() > 0 || associatedItem.func_77973_b() == TinkersConstruct.crossbow)) {
            BowCore bowCore = (BowCore)associatedItem.func_77973_b();
            try {
                Method pull = BowCore.class.getDeclaredMethod("getDrawbackProgress", ItemStack.class, Integer.TYPE);
                pull.setAccessible(true);
                float drawProgress = ((Float)pull.invoke((Object)bowCore, associatedItem, associatedItem.func_77988_m() - player.func_184605_cv())).floatValue();
                Method method = BowCore.class.getDeclaredMethod("baseProjectileSpeed", new Class[0]);
                method.setAccessible(true);
                float power = ItemBow.func_185059_b((int)((int)(20.0f * drawProgress))) * drawProgress * ((Float)method.invoke((Object)bowCore, new Object[0])).floatValue();
                ItemStack ammo = bowCore.findAmmo(associatedItem, (EntityLivingBase)player);
                EntityArrow entityArrow = bowCore.getProjectileEntity(ammo, associatedItem, player.field_70170_p, player, power *= ProjectileLauncherNBT.from((ItemStack)associatedItem).range, 0.0f, drawProgress * drawProgress, false);
                if (entityArrow != null) {
                    return entityArrow;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void simulateShot(Entity simulatedEntity) {
        if (simulatedEntity instanceof EntityProjectileBase) {
            AxisAlignedBB axisalignedbb;
            this.func_70030_z();
            EntityProjectileBase projectileBase = (EntityProjectileBase)simulatedEntity;
            for (IProjectileTrait trait : projectileBase.tinkerProjectile.getProjectileTraits()) {
                trait.onProjectileUpdate((EntityProjectileBase)simulatedEntity, this.func_130014_f_(), projectileBase.tinkerProjectile.getItemStack());
            }
            if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
                float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
            }
            BlockPos blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            IBlockState iblockstate = this.func_130014_f_().func_180495_p(blockpos);
            if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.func_130014_f_(), blockpos)) != null && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                this.func_70106_y();
            }
            if (!this.field_70128_L) {
                this.updateInAir(simulatedEntity);
            }
            ++simulatedEntity.field_70173_aa;
        }
    }

    private void updateInAir(Entity simulatedEntity) {
        Entity entity;
        EntityProjectileBase projectileBase = (EntityProjectileBase)simulatedEntity;
        ++this.ticksInAir;
        Vec3d oldPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d newPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceResult = this.field_70170_p.func_147447_a(oldPos, newPos, false, true, false);
        if (raytraceResult != null) {
            newPos = new Vec3d(raytraceResult.field_72307_f.field_72450_a, raytraceResult.field_72307_f.field_72448_b, raytraceResult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(oldPos, newPos)) != null) {
            raytraceResult = new RayTraceResult(entity);
        }
        if (raytraceResult != null && raytraceResult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceResult.field_72308_g;
            if (entityplayer.field_71075_bZ.field_75102_a || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                raytraceResult = null;
            }
        }
        if (raytraceResult != null) {
            this.func_70106_y();
        }
        if (!this.field_70128_L) {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            double f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            double slowdown = 1.0 - projectileBase.getSlowdown();
            if (this.func_70090_H()) {
                slowdown *= 0.6;
            }
            this.field_70159_w *= slowdown;
            this.field_70181_x *= slowdown;
            this.field_70179_y *= slowdown;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= projectileBase.getGravity();
            }
            for (IProjectileTrait trait : projectileBase.tinkerProjectile.getProjectileTraits()) {
                trait.onMovement(projectileBase, this.field_70170_p, slowdown);
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    @Nullable
    private Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), Constants.ARROW_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shootingEntity && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }
}

