/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.checker;

import com.dynious.versionchecker.api.Update;
import com.dynious.versionchecker.checker.NEMModInfo;
import com.dynious.versionchecker.checker.NEMUtils;
import com.dynious.versionchecker.handler.UpdateHandler;
import com.dynious.versionchecker.helper.ModHelper;
import com.dynious.versionchecker.lib.Strings;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Scanner;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.ModContainer;

public class NEMChecker
implements Runnable {
    private static NEMChecker instance = new NEMChecker();
    private final Gson gson = new Gson();

    public static String getMcVersion() {
        return "1.12.2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream inputStream = null;
        Scanner s = null;
        try {
            NEMModInfo[] mods;
            URL url = new URL("http://bot.notenoughmods.com/" + NEMChecker.getMcVersion() + ".json");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            inputStream = (InputStream)conn.getContent();
            s = new Scanner(inputStream).useDelimiter("\\A");
            String string = s.next();
            for (NEMModInfo mod : mods = (NEMModInfo[])this.gson.fromJson(string, NEMModInfo[].class)) {
                ModContainer container = ModHelper.getModContainer(mod.getModid());
                if (container == null || mod.isUpToDate(container.getVersion(), container.getDisplayVersion())) continue;
                Update update = new Update(container.getModId());
                update.displayName = container.getName();
                update.oldVersion = mod.getActualModVersion() != null ? mod.getActualModVersion() : NEMUtils.patchVersion(mod.getVersion());
                update.newVersion = mod.getVersion();
                update.changeLog = I18n.func_74838_a((String)Strings.NEM_UPDATE);
                update.isDirectLink = false;
                if (mod.getLongurl() != null && !mod.getLongurl().isEmpty()) {
                    update.updateURL = mod.getLongurl();
                }
                update.updateType = Update.UpdateType.NOT_ENOUGH_MODS;
                UpdateHandler.addUpdate(update);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                s.close();
                inputStream.close();
            }
            catch (Throwable e) {}
        }
    }

    public static void execute() {
        new Thread(instance).start();
    }
}

