/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.bottledair.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="bottledair")
@Config.LangKey(value="Bottled Air Config")
public class ModConfig {
    @Config.Comment(value={"Whether the creation of water bottles should be prevented (evaporated) when holding a fire type block in the offhand."})
    public static boolean holdFireTypeItemInOffhandToPreventWaterBottleCreation = true;
    @Config.Comment(value={"The chance a glass bottle breaks when the item in the offhand evaporates the water, giving back an empty (air) bottle."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static double chanceGlassBottleBreaksWithFireTypeInOffhand = 0.5;
    @Config.Comment(value={"The amount of air an empty bottle contains. In vanilla Minecraft, 300 is the maximum air supply."})
    @Config.RangeInt(min=0, max=1000)
    public static int amountOfAirInBottles = 150;

    @Mod.EventBusSubscriber(modid="bottledair")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("bottledair")) {
                ConfigManager.sync((String)"bottledair", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

