/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.events;

import com.natamus.collective.check.RegisterMod;
import com.natamus.collective.config.ModConfig;
import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.collective.functions.EntityFunctions;
import com.natamus.collective.objects.SAMObject;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EntityEvents {
    @SubscribeEvent
    public void onMobSpawnerSpawn(LivingSpawnEvent.SpecialSpawn e) {
        World world = e.getWorld();
        if (world == null) {
            return;
        }
        if (e.getSpawner() != null && !e.isCanceled()) {
            e.getEntity().func_184211_a("collective.spawner");
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        if (RegisterMod.shouldDoCheck && entity instanceof EntityPlayer) {
            RegisterMod.joinWorldProcess(world, (EntityPlayer)entity);
        }
        if (e.isCanceled()) {
            return;
        }
        if (GlobalVariables.samobjects.isEmpty()) {
            return;
        }
        Set tags = entity.func_184216_O();
        if (tags.contains("collective.checked")) {
            return;
        }
        entity.func_184211_a("collective.checked");
        ResourceLocation entitytype = EntityList.func_191306_a(entity.getClass());
        if (entitytype == null || !GlobalVariables.activesams.contains(entitytype)) {
            return;
        }
        boolean isspawner = tags.contains("collective.spawner");
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject samobject : GlobalVariables.samobjects) {
            if (samobject == null || samobject.fromtype == null || !samobject.fromtype.equals((Object)entitytype) || samobject.spawner && !isspawner || !samobject.spawner && isspawner) continue;
            possibles.add(samobject);
        }
        int size = possibles.size();
        if (size == 0) {
            return;
        }
        for (SAMObject sam : possibles) {
            EntityLiving le;
            Entity to;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.chance) continue;
            Vec3d evec = entity.func_174791_d();
            if (sam.surface && !BlockPosFunctions.isOnSurface(world, evec).booleanValue() || (to = EntityList.func_188429_b((ResourceLocation)sam.totype, (World)world)) == null) continue;
            to.func_70029_a(world);
            to.func_70107_b(evec.field_72450_a, evec.field_72448_b, evec.field_72449_c);
            if (sam.helditem != null && to instanceof EntityLiving && !(le = (EntityLiving)to).func_184614_ca().func_77973_b().equals(sam.helditem)) {
                le.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(sam.helditem, 1));
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideable) {
                AbstractHorse ah = (AbstractHorse)to;
                ah.func_110234_j(true);
                to = ah;
                ride = true;
            } else if (ModConfig.transferItemsBetweenReplacedEntities) {
                EntityFunctions.transferItemsBetweenEntities(entity, to);
            }
            to.func_184211_a("collective.checked");
            world.func_72838_d(to);
            if (ride) {
                entity.func_184220_m(to);
                break;
            }
            e.setCanceled(true);
            break;
        }
    }
}

