/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.functions.NumberFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class PlayerFunctions {
    public static boolean respawnPlayer(World world, EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            return false;
        }
        MinecraftServer server = world.func_73046_m();
        EntityPlayerMP serverplayer = (EntityPlayerMP)player;
        if (serverplayer.field_71136_j) {
            serverplayer.field_71136_j = false;
            serverplayer = server.func_184103_al().func_72368_a(serverplayer, 0, true);
            CriteriaTriggers.field_193134_u.func_193143_a(serverplayer, DimensionType.THE_END, DimensionType.OVERWORLD);
        } else if (serverplayer.func_110143_aJ() <= 0.0f) {
            serverplayer = server.func_184103_al().func_72368_a(serverplayer, player.field_71093_bK, false);
        }
        return true;
    }

    public static EntityPlayer matchPlayer(EntityPlayer player, String other) {
        return PlayerFunctions.matchPlayer(player.func_130014_f_(), other);
    }

    public static EntityPlayer matchPlayer(World world, String other) {
        List players = world.field_73010_i;
        for (EntityPlayer onlineplayer : players) {
            if (!onlineplayer.func_70005_c_().toLowerCase().equals(other)) continue;
            return onlineplayer;
        }
        return null;
    }

    public static boolean isHoldingWater(EntityPlayer player) {
        return player.func_184586_b(EnumHand.OFF_HAND).func_77973_b().equals(Items.field_151131_as) || player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b().equals(Items.field_151131_as);
    }

    public static boolean isJoiningWorldForTheFirstTime(EntityPlayer player, String modid) {
        String firstjointag = "collective.firstJoin." + modid;
        Set tags = player.func_184216_O();
        if (tags.contains(firstjointag)) {
            return false;
        }
        player.func_184211_a(firstjointag);
        InventoryPlayer inv = player.field_71071_by;
        boolean isempty = true;
        for (int i = 0; i < 36; ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            isempty = false;
            break;
        }
        if (!isempty) {
            return false;
        }
        World world = player.func_130014_f_();
        BlockPos wspos = world.func_175694_M();
        BlockPos ppos = player.func_180425_c();
        BlockPos cpos = new BlockPos(ppos.func_177958_n(), wspos.func_177956_o(), ppos.func_177952_p());
        return cpos.func_185332_f(wspos.func_177958_n(), wspos.func_177956_o(), wspos.func_177952_p()) <= 50.0;
    }

    public static BlockPos getSpawnPoint(World world, EntityPlayer player) {
        Vec3d spawnvec = PlayerFunctions.getSpawnVec(world, player);
        return new BlockPos(spawnvec.field_72450_a, spawnvec.field_72448_b, spawnvec.field_72449_c);
    }

    public static Vec3d getSpawnVec(World world, EntityPlayer player) {
        BlockPos respawnlocation = world.func_175694_M();
        Vec3d respawnvec = new Vec3d((double)respawnlocation.func_177958_n(), (double)respawnlocation.func_177956_o(), (double)respawnlocation.func_177952_p());
        BlockPos bedpos = player.getBedLocation(player.field_71093_bK);
        if (bedpos != null) {
            for (BlockPos np : BlockPos.func_191532_a((int)(bedpos.func_177958_n() - 1), (int)(bedpos.func_177956_o() - 1), (int)(bedpos.func_177952_p() - 1), (int)(bedpos.func_177958_n() + 1), (int)(bedpos.func_177956_o() + 1), (int)(bedpos.func_177952_p() + 1))) {
                IBlockState state = world.func_180495_p(np);
                Block block = state.func_177230_c();
                if (!(block instanceof BlockBed)) continue;
                respawnvec = new Vec3d((double)bedpos.func_177958_n(), (double)bedpos.func_177956_o(), (double)bedpos.func_177952_p());
                break;
            }
        }
        return respawnvec;
    }

    public static EnumHand getOtherHand(EnumHand hand) {
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            return EnumHand.OFF_HAND;
        }
        return EnumHand.MAIN_HAND;
    }

    public static String getPlayerGearString(EntityPlayer player) {
        String skconfig = "";
        ItemStack offhand = player.func_184582_a(EntityEquipmentSlot.OFFHAND);
        if (!offhand.func_190926_b()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt = offhand.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig = skconfig + "'offhand' : '" + nbtstring + "',";
        } else {
            skconfig = skconfig + "'offhand' : '',";
        }
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (!head.func_190926_b()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt = head.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig = skconfig + "\n'head' : '" + nbtstring + "',";
        } else {
            skconfig = skconfig + "\n'head' : '',";
        }
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (!chest.func_190926_b()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt = chest.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig = skconfig + "\n'chest' : '" + nbtstring + "',";
        } else {
            skconfig = skconfig + "\n'chest' : '',";
        }
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        if (!legs.func_190926_b()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt = legs.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig = skconfig + "\n'legs' : '" + nbtstring + "',";
        } else {
            skconfig = skconfig + "\n'legs' : '',";
        }
        ItemStack feet = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!feet.func_190926_b()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt = feet.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig = skconfig + "\n'feet' : '" + nbtstring + "',";
        } else {
            skconfig = skconfig + "\n'feet' : '',";
        }
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < 36; ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (!slot.func_190926_b()) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt = slot.func_77955_b(nbt);
                String nbtstring = nbt.toString();
                skconfig = skconfig + "\n" + i + " : '" + nbtstring + "',";
                continue;
            }
            skconfig = skconfig + "\n" + i + " : '',";
        }
        return skconfig;
    }

    public static String getPlayerGearStringFromHashMap(HashMap<String, ItemStack> gear) {
        NBTTagCompound nbt;
        String gearstring = "";
        ArrayList<String> specialslots = new ArrayList<String>(Arrays.asList("offhand", "head", "chest", "legs", "feet"));
        for (String specialslot : specialslots) {
            String specialslotstring = "";
            if (gear.containsKey(specialslot)) {
                nbt = new NBTTagCompound();
                nbt = gear.get(specialslot).func_77955_b(nbt);
                specialslotstring = nbt.toString();
            }
            if (gearstring != "") {
                gearstring = gearstring + "\n";
            }
            gearstring = gearstring + "'" + specialslot + "' : '" + specialslotstring + "',";
        }
        NonNullList emptyinventory = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < emptyinventory.size(); ++i) {
            String itemstring = "";
            if (gear.containsKey("" + i)) {
                nbt = new NBTTagCompound();
                nbt = gear.get("" + i).func_77955_b(nbt);
                itemstring = nbt.toString();
            }
            gearstring = gearstring + "\n" + i + " : '" + itemstring + "',";
        }
        return gearstring;
    }

    public static void setPlayerGearFromString(EntityPlayer player, String gearconfig) {
        String[] gearspl = gearconfig.split("\n");
        int newlinecount = gearspl.length;
        if (newlinecount < 40) {
            System.out.println("[Error] setPlayerGearFromString: The gear config does not contain 40 lines and is invalid.");
            return;
        }
        boolean cleared = false;
        for (String line : gearspl) {
            String[] lspl;
            if ((line = line.trim().replaceAll("\n", "")).endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            if ((lspl = line.split(" : ")).length != 2) {
                System.out.println("[Error] setPlayerGearFromString: The line '" + line + "' is invalid.");
                return;
            }
            String slotstring = lspl[0].replace("'", "");
            String data = lspl[1];
            if ((data = data.substring(1, data.length() - 1)).length() < 2) continue;
            ItemStack itemstack = null;
            try {
                NBTTagCompound newnbt = JsonToNBT.func_180713_a((String)data);
                itemstack = new ItemStack(newnbt);
            }
            catch (Exception newnbt) {
                // empty catch block
            }
            if (itemstack == null) {
                System.out.println("[Error] setPlayerGearFromString: Unable to get the correct itemstack data from '" + line + "'.");
                return;
            }
            if (!cleared) {
                cleared = true;
                player.field_71071_by.func_174888_l();
            }
            if (NumberFunctions.isNumeric(slotstring)) {
                int slot = Integer.parseInt(slotstring);
                player.field_71071_by.func_70299_a(slot, itemstack);
                continue;
            }
            EntityEquipmentSlot type = null;
            if (slotstring.equals("offhand")) {
                type = EntityEquipmentSlot.OFFHAND;
            } else if (slotstring.equals("head")) {
                type = EntityEquipmentSlot.HEAD;
            } else if (slotstring.equals("chest")) {
                type = EntityEquipmentSlot.CHEST;
            } else if (slotstring.equals("legs")) {
                type = EntityEquipmentSlot.LEGS;
            } else {
                if (!slotstring.equals("feet")) continue;
                type = EntityEquipmentSlot.FEET;
            }
            if (type == null) continue;
            player.func_184201_a(type, itemstack);
        }
    }
}

