/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WorldFunctions {
    public static void setWorldTime(World world, Integer time) {
        if (time < 0 || time > 24000) {
            return;
        }
        Integer days = WorldFunctions.getTotalDaysPassed(world);
        world.func_82738_a((long)(time + days * 24000));
    }

    public static int getTotalTimePassed(World world) {
        return (int)world.func_82737_E();
    }

    public static int getTotalDaysPassed(World world) {
        Integer currenttime = WorldFunctions.getTotalTimePassed(world);
        Integer days = (int)Math.floor((double)currenttime.intValue() / 24000.0);
        return days;
    }

    public static int getWorldTime(World world) {
        return WorldFunctions.getTotalTimePassed(world) - WorldFunctions.getTotalDaysPassed(world) * 24000;
    }

    public static String getWorldDimensionName(World world) {
        return world.field_73011_w.func_186058_p().toString();
    }

    public static boolean isOverworld(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("overworld");
    }

    public static boolean isNether(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("nether");
    }

    public static boolean isEnd(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("end");
    }

    public static String getWorldPath(WorldServer serverworld) {
        return serverworld.func_72860_G().func_75765_b().getPath();
    }
}

