/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.erodingstoneentities.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="erodingstoneentities")
@Config.LangKey(value="Eroding Stone Entities Config")
public class ModConfig {
    @Config.Comment(value={"The duration in seconds after a stone-type item entity in the world erodes to sand if it's in a water stream."})
    @Config.RangeInt(min=1, max=3600)
    public static int durationInSecondsStoneErodes = 150;
    @Config.Comment(value={"If enabled, prevents the erosion of stone blocks if the item entity is above an ice block. Useful for when you use water streams to transport items you don't want to have eroded, just place ice underneath the streams."})
    public static boolean preventErosionIfAboveIceBlock = true;
    @Config.Comment(value={"If enabled, the items specified in 'itemsWhichErodeIntoClay' will erode into a clay block instead of the default clay ball."})
    public static boolean erodeIntoClayBlockInsteadOfClayBall = false;
    @Config.Comment(value={"The items which erode into normal sand when left in flowing water. Divided by a comma."})
    public static String itemsWhichErodeIntoSand = "minecraft:cobblestone,minecraft:mossy_cobblestone,minecraft:stone,minecraft:stone_bricks,minecraft:chiseled_stone_bricks,minecraft:cracked_stone_bricks,minecraft:smooth_stone,minecraft:gravel,minecraft:andesite,minecraft:polished_andesite,minecraft:diorite,minecraft:polished_diorite,minecraft:granite,minecraft:polished_granite,minecraft:sandstone,minecraft:chiseled_sandstone,minecraft:cut_sandstone,minecraft:smooth_sandstone";
    @Config.Comment(value={"The items which erode into red sand when left in flowing water. Divided by a comma."})
    public static String itemsWhichErodeIntoRedSand = "minecraft:red_sandstone,minecraft:chiseled_red_sandstone,minecraft:cut_red_sandstone,minecraft:smooth_red_sandstone,minecraft:netherrack,minecraft:nether_bricks,minecraft:red_nether_bricks";
    @Config.Comment(value={"The items which erode into clay balls when left in flowing water. Divided by a comma."})
    public static String itemsWhichErodeIntoClay = "minecraft:terracotta,minecraft:white_terracotta,minecraft:orange_terracotta,minecraft:magenta_terracotta,minecraft:light_blue_terracotta,minecraft:yellow_terracotta,minecraft:lime_terracotta,minecraft:pink_terracotta,minecraft:gray_terracotta,minecraft:light_gray_terracotta,minecraft:cyan_terracotta,minecraft:purple_terracotta,minecraft:blue_terracotta,minecraft:brown_terracotta,minecraft:green_terracotta,minecraft:red_terracotta,minecraft:black_terracotta";

    @Mod.EventBusSubscriber(modid="erodingstoneentities")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("erodingstoneentities")) {
                ConfigManager.sync((String)"erodingstoneentities", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

