/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.gui;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FirstaidIngameGui {
    private static final Field eventParentField;

    public static void renderHealth(GuiIngame gui, int width, int height) {
        boolean highlight;
        int criticalHalfHearts;
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_76320_a("health");
        AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)mc.field_71439_g.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null);
        if (damageModel != null) {
            float criticalHealth = Float.MAX_VALUE;
            for (AbstractDamageablePart part : damageModel) {
                if (!part.canCauseDeath) continue;
                criticalHealth = Math.min(criticalHealth, part.currentHealth);
            }
            criticalHealth = criticalHealth / (float)damageModel.getCurrentMaxHealth() * mc.field_71439_g.func_110138_aP();
            criticalHalfHearts = MathHelper.func_76123_f((float)criticalHealth);
        } else {
            criticalHalfHearts = 0;
        }
        GlStateManager.func_179147_l();
        EntityPlayer player = (EntityPlayer)mc.func_175606_aa();
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean bl = highlight = gui.field_175191_F > (long)gui.field_73837_f && (gui.field_175191_F - (long)gui.field_73837_f) / 3L % 2L == 1L;
        if (health < gui.field_175194_C && player.field_70172_ad > 0) {
            gui.field_175190_E = Minecraft.func_71386_F();
            gui.field_175191_F = gui.field_73837_f + 20;
        } else if (health > gui.field_175194_C && player.field_70172_ad > 0) {
            gui.field_175190_E = Minecraft.func_71386_F();
            gui.field_175191_F = gui.field_73837_f + 10;
        }
        if (Minecraft.func_71386_F() - gui.field_175190_E > 1000L) {
            gui.field_175194_C = health;
            gui.field_175189_D = health;
            gui.field_175190_E = Minecraft.func_71386_F();
        }
        gui.field_175194_C = health;
        int healthLast = gui.field_175189_D;
        IAttributeInstance attrMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        gui.field_73842_c.setSeed(gui.field_73837_f * 312871);
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.left_height;
        GuiIngameForge.left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            GuiIngameForge.left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.func_70644_a(MobEffects.field_76428_l)) {
            regen = gui.field_73837_f % 25;
        }
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            MARGIN += 36;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            float oldBlitOffset;
            boolean thisHalfCritical = i * 2 + 1 == criticalHalfHearts;
            int TOP = 9 * (i * 2 < criticalHalfHearts && !thisHalfCritical ? 5 : 0);
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += gui.field_73842_c.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            gui.func_73729_b(x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (thisHalfCritical) {
                    oldBlitOffset = gui.field_73735_i;
                    gui.field_73735_i += 1000.0f;
                    gui.func_73729_b(x, y, MARGIN + 63, 45, 9, 9);
                    gui.field_73735_i = oldBlitOffset;
                }
                if (i * 2 + 1 < healthLast) {
                    gui.func_73729_b(x + (thisHalfCritical ? 5 : 0), y, MARGIN + 54 + (thisHalfCritical ? 5 : 0), TOP, 9 - (thisHalfCritical ? 5 : 0), 9);
                } else if (i * 2 + 1 == healthLast) {
                    gui.func_73729_b(x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    gui.func_73729_b(x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                gui.func_73729_b(x, y, MARGIN + 144, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (thisHalfCritical) {
                oldBlitOffset = gui.field_73735_i;
                gui.field_73735_i += 1000.0f;
                gui.func_73729_b(x, y, MARGIN + 45, 45, 9, 9);
                gui.field_73735_i = oldBlitOffset;
            }
            if (i * 2 + 1 < health) {
                gui.func_73729_b(x + (thisHalfCritical ? 5 : 0), y, MARGIN + 36 + (thisHalfCritical ? 5 : 0), TOP, 9 - (thisHalfCritical ? 5 : 0), 9);
                continue;
            }
            if (i * 2 + 1 != health || thisHalfCritical) continue;
            gui.func_73729_b(x, y, MARGIN + 45, TOP, 9, 9);
        }
        GlStateManager.func_179084_k();
        mc.field_71424_I.func_76319_b();
        if (eventParentField != null) {
            RenderGameOverlayEvent event;
            try {
                event = (RenderGameOverlayEvent)eventParentField.get(gui);
            }
            catch (IllegalAccessException e) {
                FirstAid.LOGGER.error("Failed to access eventParentField", (Throwable)e);
                event = null;
            }
            if (event != null) {
                MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(event, RenderGameOverlayEvent.ElementType.HEALTH));
            }
        }
    }

    static {
        Field f;
        try {
            f = GuiIngameForge.class.getDeclaredField("eventParent");
            f.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            FirstAid.LOGGER.error("Failed to get eventParent", (Throwable)e);
            f = null;
        }
        eventParentField = f;
    }
}

