/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.debuff;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.common.damagesystem.debuff.AbstractDebuff;
import ichttt.mods.firstaid.common.network.MessagePlayHurtSound;
import it.unimi.dsi.fastutil.floats.Float2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class OnHitDebuff
extends AbstractDebuff {
    @Nullable
    private final SoundEvent sound;

    public OnHitDebuff(@Nonnull String potionName, @Nonnull Float2IntLinkedOpenHashMap map, @Nonnull BooleanSupplier isEnabled, @Nullable SoundEvent sound) {
        super(potionName, map, isEnabled);
        this.sound = sound;
    }

    @Override
    public void handleDamageTaken(float damage, float healthPerMax, EntityPlayerMP player) {
        if (!this.isEnabled.getAsBoolean()) {
            return;
        }
        int value = -1;
        for (Float2IntMap.Entry entry : this.map.float2IntEntrySet()) {
            if (!(damage >= entry.getFloatKey())) continue;
            value = Math.max(value, entry.getIntValue());
            player.func_70690_d(new PotionEffect(this.effect, entry.getIntValue(), 0, false, false));
        }
        if (value != -1 && this.sound != null) {
            FirstAid.NETWORKING.sendTo((IMessage)new MessagePlayHurtSound(this.sound, value), player);
        }
    }

    @Override
    public void handleHealing(float healingDone, float healthPerMax, EntityPlayerMP player) {
    }
}

