/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.potion;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.RandomDamageDistribution;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class PotionPoisonPatched
extends Potion {
    public static final PotionPoisonPatched INSTANCE = new PotionPoisonPatched(true, 5149489);
    private static final Method getHurtSound = ObfuscationReflectionHelper.findMethod(EntityLivingBase.class, (String)"func_184601_bQ", SoundEvent.class, (Class[])new Class[]{DamageSource.class});
    private static final Method getSoundVolume = ObfuscationReflectionHelper.findMethod(EntityLivingBase.class, (String)"func_70599_aP", Float.TYPE, (Class[])new Class[0]);
    private static final Method getSoundPitch = ObfuscationReflectionHelper.findMethod(EntityLivingBase.class, (String)"func_70647_i", Float.TYPE, (Class[])new Class[0]);

    protected PotionPoisonPatched(boolean isBadEffectIn, int liquidColorIn) {
        super(isBadEffectIn, liquidColorIn);
        this.func_76390_b("effect.poison");
        this.func_76399_b(6, 0);
        this.func_76404_a(0.25);
        this.setRegistryName(new ResourceLocation("minecraft", "poison"));
        FirstAid.LOGGER.info("Don't worry, the minecraft poison override IS intended.");
    }

    public void func_76394_a(@Nonnull EntityLivingBase entity, int amplifier) {
        if (entity instanceof EntityPlayer && !(entity instanceof FakePlayer) && (FirstAidConfig.damageSystem.causeDeathBody || FirstAidConfig.damageSystem.causeDeathHead)) {
            if (entity.field_70170_p.field_72995_K || entity.field_70128_L || entity.func_180431_b(DamageSource.field_76376_m)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            AbstractPlayerDamageModel playerDamageModel = (AbstractPlayerDamageModel)Objects.requireNonNull(player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null));
            if (DamageDistribution.handleDamageTaken(RandomDamageDistribution.ANY_NOKILL, playerDamageModel, 1.0f, player, DamageSource.field_76376_m, true, false) != 1.0f) {
                if (player.func_70608_bn()) {
                    player.func_70999_a(true, true, false);
                }
                try {
                    SoundEvent sound = (SoundEvent)getHurtSound.invoke((Object)player, DamageSource.field_76376_m);
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, player.func_184176_by(), ((Float)getSoundVolume.invoke((Object)player, new Object[0])).floatValue(), ((Float)getSoundPitch.invoke((Object)player, new Object[0])).floatValue());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    FirstAid.LOGGER.error("Could not play hurt sound!", (Throwable)e);
                }
            }
        } else {
            super.func_76394_a(entity, amplifier);
        }
    }
}

