/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged.asm;

import com.google.common.collect.Lists;
import git.jbredwards.fluidlogged.asm.OFReflector;
import git.jbredwards.fluidlogged.common.block.AbstractFluidloggedBlock;
import git.jbredwards.fluidlogged.common.block.BlockFluidloggedTE;
import git.jbredwards.fluidlogged.common.block.IParticleColor;
import git.jbredwards.fluidlogged.common.block.TileEntityFluidlogged;
import git.jbredwards.fluidlogged.util.FluidloggedConstants;
import git.jbredwards.fluidlogged.util.FluidloggedUtils;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public enum ASMHooks {


    public static boolean setStoredOrRealSimple(World world, BlockPos pos, IBlockState state, int flags) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFluidlogged) {
            ((TileEntityFluidlogged)te).setStored(state, true);
            return true;
        }
        return world.func_180501_a(pos, state, flags);
    }

    public static int getQuantaValue(BlockFluidClassic fluid, IBlockState state, int quantaPerBlock) {
        if (state.func_177230_c() instanceof BlockFluidBase && fluid.getFluid().getBlock() instanceof BlockFluidBase) {
            int level = (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL);
            return ((BlockFluidBase)state.func_177230_c()).getFluid().getBlock() == fluid.getFluid().getBlock() ? quantaPerBlock - level : -1;
        }
        if (state.func_177230_c() instanceof BlockLiquid && fluid.getFluid().getBlock() instanceof BlockLiquid) {
            int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            return state.func_185904_a() == fluid.func_176223_P().func_185904_a() ? quantaPerBlock - level : -1;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBuiltinBlocks(BlockModelShapes shapes) {
        for (BlockFluidloggedTE block : FluidloggedConstants.FLUIDLOGGED_TE_LOOKUP.values()) {
            if (block.fluid == FluidRegistry.WATER || block.fluid == FluidRegistry.LAVA) continue;
            shapes.func_178123_a(new Block[]{block});
        }
    }

    public static boolean absorb(BlockSponge sponge, World world, BlockPos posIn) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(Pair.of((Object)posIn, (Object)0));
        int blocksDrained = 0;
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.poll();
            BlockPos pos = (BlockPos)pair.getLeft();
            int distance = (Integer)pair.getRight();
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos offset = pos.func_177972_a(facing);
                IBlockState state = world.func_180495_p(offset);
                if (state.func_185904_a() != Material.field_151586_h) continue;
                if (state.func_177230_c() instanceof AbstractFluidloggedBlock) {
                    ((AbstractFluidloggedBlock)state.func_177230_c()).drain(world, offset, true);
                } else {
                    world.func_175656_a(offset, Blocks.field_150350_a.func_176223_P());
                }
                ++blocksDrained;
                if (distance >= 6) continue;
                queue.add(Pair.of((Object)offset, (Object)(distance + 1)));
            }
            if (blocksDrained <= 64) continue;
            break;
        }
        return blocksDrained > 0;
    }

    public static BlockStairs.EnumShape getShape(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing neighborFace;
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a);
        IBlockState neighbor = FluidloggedUtils.getStoredOrReal(world, pos.func_177972_a(face));
        if (neighbor.func_177230_c() instanceof BlockStairs && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == neighbor.func_177229_b((IProperty)BlockStairs.field_176308_b) && (neighborFace = (EnumFacing)neighbor.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176740_k() != face.func_176740_k() && ASMHooks.isDifferentStairs(state, world, pos, neighborFace.func_176734_d())) {
            if (neighborFace == face.func_176735_f()) {
                return BlockStairs.EnumShape.OUTER_LEFT;
            }
            return BlockStairs.EnumShape.OUTER_RIGHT;
        }
        neighbor = FluidloggedUtils.getStoredOrReal(world, pos.func_177972_a(face.func_176734_d()));
        if (neighbor.func_177230_c() instanceof BlockStairs && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == neighbor.func_177229_b((IProperty)BlockStairs.field_176308_b) && (neighborFace = (EnumFacing)neighbor.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176740_k() != face.func_176740_k() && ASMHooks.isDifferentStairs(state, world, pos, neighborFace)) {
            if (neighborFace == face.func_176735_f()) {
                return BlockStairs.EnumShape.INNER_LEFT;
            }
            return BlockStairs.EnumShape.INNER_RIGHT;
        }
        return BlockStairs.EnumShape.STRAIGHT;
    }

    public static boolean isDifferentStairs(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing offset) {
        IBlockState neighbor = FluidloggedUtils.getStoredOrReal(world, pos.func_177972_a(offset));
        return !(neighbor.func_177230_c() instanceof BlockStairs) || state.func_177229_b((IProperty)BlockStairs.field_176309_a) != neighbor.func_177229_b((IProperty)BlockStairs.field_176309_a) || state.func_177229_b((IProperty)BlockStairs.field_176308_b) != neighbor.func_177229_b((IProperty)BlockStairs.field_176308_b);
    }

    public static void registerFluidloggedBlock(Fluid fluid) {
        if (fluid.getName() != null && FluidRegistry.isFluidRegistered((Fluid)fluid) && fluid.getBlock() instanceof BlockFluidClassic && !FluidloggedConstants.FLUIDLOGGED_TE_LOOKUP.containsKey(fluid)) {
            BlockFluidloggedTE block = new BlockFluidloggedTE(fluid, fluid.getBlock().func_176223_P().func_185904_a());
            FluidloggedConstants.FLUIDLOGGED_TE_LOOKUP.put(fluid, block);
            ForgeRegistries.BLOCKS.register(block.setRegistryName(fluid.getName() + "logged_te"));
        }
    }

    public static void fluidBlockErrorSpamFix(Logger logger, String message, Block block, String fluidName, Block old) {
    }

    @SideOnly(value=Side.CLIENT)
    public static int getColor(BlockColors old, IBlockState state, World world, BlockPos pos, int index) {
        if (state.func_177230_c() instanceof IParticleColor) {
            return ((IParticleColor)state.func_177230_c()).getParticleColor(state, world, pos);
        }
        return old.func_186724_a(state, (IBlockAccess)world, pos, index);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderFluidloggedBlock(boolean[] array, ChunkCompileTaskGenerator generator, CompiledChunk compiledChunk, Block block, IBlockAccess world, BlockPos pos, BlockPos chunkPos) {
        if (block instanceof BlockFluidloggedTE) {
            BlockRendererDispatcher renderer = Minecraft.func_71410_x().func_175602_ab();
            IBlockState stored = Objects.requireNonNull(FluidloggedUtils.getStored(world, pos)).func_185899_b(world, pos);
            if (stored.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!stored.func_177230_c().canRenderInLayer(stored, layer)) continue;
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                    BufferBuilder buffer = generator.func_178545_d().func_179038_a(layer);
                    if (!compiledChunk.func_178492_d(layer)) {
                        compiledChunk.func_178493_c(layer);
                        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                        buffer.func_178969_c((double)(-chunkPos.func_177958_n()), (double)(-chunkPos.func_177956_o()), (double)(-chunkPos.func_177952_p()));
                    }
                    IBakedModel model = renderer.func_184389_a(stored);
                    if ((stored = stored.func_177230_c().getExtendedState(stored, world, pos)).func_177230_c() instanceof BlockWall && ((Boolean)stored.func_177229_b((IProperty)BlockWall.field_176256_a)).booleanValue()) {
                        boolean north = (Boolean)stored.func_177229_b((IProperty)BlockWall.field_176254_b);
                        boolean south = (Boolean)stored.func_177229_b((IProperty)BlockWall.field_176258_N);
                        boolean east = (Boolean)stored.func_177229_b((IProperty)BlockWall.field_176257_M);
                        boolean west = (Boolean)stored.func_177229_b((IProperty)BlockWall.field_176259_O);
                        if (north && south && !east && !west || !north && !south && east && west) {
                            IBlockState up = FluidloggedUtils.getStoredOrReal(world, pos.func_177984_a());
                            stored = stored.func_177226_a((IProperty)BlockWall.field_176256_a, (Comparable)Boolean.valueOf(!up.func_185904_a().func_76224_d() && up.func_177230_c() != Blocks.field_150350_a));
                        }
                    }
                    int n = layer.ordinal();
                    array[n] = array[n] | renderer.func_175019_b().func_178267_a(world, model, stored, pos, buffer, true);
                }
                ForgeHooksClient.setRenderLayer(null);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderFluidloggedBlockOF(boolean[] array, RenderChunk renderChunk, ChunkCompileTaskGenerator generator, CompiledChunk compiledChunk, Block block, IBlockAccess chunkCacheOF, BlockPos pos, BlockPos chunkPos) {
        OFReflector.load();
        if (block instanceof BlockFluidloggedTE) {
            BlockRendererDispatcher renderer = Minecraft.func_71410_x().func_175602_ab();
            IBlockState stored = Objects.requireNonNull(FluidloggedUtils.getStored(chunkCacheOF, pos)).func_185899_b(chunkCacheOF, pos);
            if (stored.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!stored.func_177230_c().canRenderInLayer(stored, layer)) continue;
                    try {
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                        BufferBuilder buffer = generator.func_178545_d().func_179038_a(layer);
                        Objects.requireNonNull(OFReflector.setBlockLayer).invoke((Object)buffer, layer);
                        Object renderEnv = Objects.requireNonNull(OFReflector.getRenderEnv).invoke((Object)buffer, stored, pos);
                        Objects.requireNonNull(OFReflector.setRegionRenderCacheBuilder).invoke(renderEnv, generator.func_178545_d());
                        if (!compiledChunk.func_178492_d(layer)) {
                            compiledChunk.func_178493_c(layer);
                            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                            buffer.func_178969_c((double)(-chunkPos.func_177958_n()), (double)(-chunkPos.func_177956_o()), (double)(-chunkPos.func_177952_p()));
                        }
                        IBakedModel model = renderer.func_184389_a(stored);
                        if ((stored = stored.func_177230_c().getExtendedState(stored, chunkCacheOF, pos)).func_177230_c() instanceof BlockWall && ((Boolean)stored.func_177229_b((IProperty)BlockWall.field_176256_a)).booleanValue()) {
                            boolean north = (Boolean)stored.func_177229_b((IProperty)BlockWall.field_176254_b);
                            boolean south = (Boolean)stored.func_177229_b((IProperty)BlockWall.field_176258_N);
                            boolean east = (Boolean)stored.func_177229_b((IProperty)BlockWall.field_176257_M);
                            boolean west = (Boolean)stored.func_177229_b((IProperty)BlockWall.field_176259_O);
                            if (north && south && !east && !west || !north && !south && east && west) {
                                IBlockState up = FluidloggedUtils.getStoredOrReal(chunkCacheOF, pos.func_177984_a());
                                stored = stored.func_177226_a((IProperty)BlockWall.field_176256_a, (Comparable)Boolean.valueOf(!up.func_185904_a().func_76224_d() && up.func_177230_c() != Blocks.field_150350_a));
                            }
                        }
                        int n = layer.ordinal();
                        array[n] = array[n] | renderer.func_175019_b().func_178267_a(chunkCacheOF, model, stored, pos, buffer, true);
                        if (!((Boolean)Objects.requireNonNull(OFReflector.isOverlaysRendered).invoke(renderEnv, new Object[0])).booleanValue()) continue;
                        Objects.requireNonNull(OFReflector.postRenderOverlays).invoke((Object)renderChunk, generator.func_178545_d(), compiledChunk, array);
                        Objects.requireNonNull(OFReflector.setOverlaysRendered).invoke(renderEnv, false);
                    }
                    catch (Exception e) {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + e.toString()));
                    }
                }
                ForgeHooksClient.setRenderLayer(null);
            }
        }
    }
}

