/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged.asm;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public enum ASMUtils {


    @Nonnull
    public static AbstractInsnNode getPrevious(@Nonnull AbstractInsnNode insn, int count) {
        for (int i = 0; i < count; ++i) {
            insn = Objects.requireNonNull(insn.getPrevious());
        }
        return insn;
    }

    @Nonnull
    public static AbstractInsnNode getNext(@Nonnull AbstractInsnNode insn, int count) {
        for (int i = 0; i < count; ++i) {
            insn = Objects.requireNonNull(insn.getNext());
        }
        return insn;
    }

    public static boolean checkMethod(@Nullable AbstractInsnNode insn, @Nullable String name, @Nullable String desc) {
        if (!(insn instanceof MethodInsnNode)) {
            return false;
        }
        if (name == null && desc == null) {
            return true;
        }
        if (name == null) {
            return ((MethodInsnNode)insn).desc.equals(desc);
        }
        if (desc == null) {
            return ((MethodInsnNode)insn).name.equals(name);
        }
        return ((MethodInsnNode)insn).name.equals(name) && ((MethodInsnNode)insn).desc.equals(desc);
    }
}

