/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged.asm;

import java.util.List;
import javax.annotation.Nonnull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class AbstractPlugin {
    @Nonnull
    public abstract String getMethodName(boolean var1);

    @Nonnull
    public abstract String getMethodDesc();

    protected abstract boolean transform(InsnList var1, MethodNode var2, AbstractInsnNode var3, boolean var4);

    protected int addLocalVariables(List<LocalVariableNode> variables, LabelNode start, LabelNode end) {
        return 0;
    }

    protected boolean isMethodValid(MethodNode method, boolean obfuscated) {
        return method.name.equals(this.getMethodName(obfuscated)) && method.desc.equals(this.getMethodDesc());
    }

    public byte[] transform(byte[] basicClass, boolean obfuscated) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)classNode, 0);
        block0: for (MethodNode method : classNode.methods) {
            if (!this.isMethodValid(method, obfuscated)) continue;
            LabelNode start = new LabelNode();
            LabelNode end = new LabelNode();
            int localVariablesAdded = this.addLocalVariables(method.localVariables, start, end);
            if (localVariablesAdded > 0) {
                method.instructions.insertBefore(method.instructions.getFirst(), (AbstractInsnNode)start);
                method.instructions.insert(method.instructions.getLast(), (AbstractInsnNode)end);
                method.maxLocals += localVariablesAdded;
            }
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (this.transform(method.instructions, method, insn, obfuscated)) break block0;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

