/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged.common.block;

import java.lang.reflect.Field;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractFluidloggedBlock
extends BlockFluidClassic {
    public static final Field canCreateSourcesField = ObfuscationReflectionHelper.findField(BlockFluidClassic.class, (String)"canCreateSources");
    public static final Field quantaPerBlockField = ObfuscationReflectionHelper.findField(BlockFluidBase.class, (String)"quantaPerBlock");
    public static final Field nextStepDistance = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_70150_b");
    public final Fluid fluid = this.definedFluid;
    private boolean isQuantaDirty = true;

    protected AbstractFluidloggedBlock(Fluid fluid, Material material, MapColor mapColor) {
        super(fluid, material, mapColor);
        if (fluid.getBlock() instanceof BlockFluidClassic) {
            try {
                this.canCreateSources = canCreateSourcesField.getBoolean(fluid.getBlock());
            }
            catch (Exception e) {
                this.canCreateSources = false;
            }
        } else {
            this.canCreateSources = material == Material.field_151586_h;
        }
    }

    protected AbstractFluidloggedBlock(Fluid fluid, Material material) {
        super(fluid, material);
        if (fluid.getBlock() instanceof BlockFluidClassic) {
            try {
                this.canCreateSources = canCreateSourcesField.getBoolean(fluid.getBlock());
            }
            catch (Exception e) {
                this.canCreateSources = false;
            }
        } else {
            this.canCreateSources = material == Material.field_151586_h;
        }
    }

    protected final void updateQuanta() {
        if (this.isQuantaDirty) {
            try {
                this.setQuantaPerBlock(quantaPerBlockField.getInt(this.fluid.getBlock()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isQuantaDirty = false;
        }
    }

    public boolean canSideFlow(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state.func_193401_d(world, pos, side) != BlockFaceShape.SOLID;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_176209_a(@Nonnull IBlockState state, boolean fullHit) {
        return true;
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int func_149745_a(@Nonnull Random par1Random) {
        return 1;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        world.func_180501_a(pos, this.fluid.getBlock().func_176223_P(), 11);
        this.fluid.getBlock().func_180652_a(world, pos, explosion);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, this.fluid.getBlock().func_176223_P(), 11);
    }

    public boolean isSourceBlock(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return 0;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.renderLayer == layer || this.fluid.getBlock().canRenderInLayer(this.fluid.getBlock().func_176223_P(), layer);
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            BlockDynamicLiquid fluidBlock = this.fluid.getBlock() instanceof BlockLiquid ? BlockLiquid.func_176361_a((Material)this.field_149764_J) : this.fluid.getBlock();
            world.func_175656_a(pos, fluidBlock.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta)));
        }
    }

    protected boolean canFlowInto(IBlockAccess world, BlockPos pos) {
        boolean flag3;
        IBlockState state = world.func_180495_p(pos);
        boolean flag = state.func_177230_c() instanceof BlockLiquid && (Integer)state.func_177229_b((IProperty)LEVEL) == 0;
        boolean flag2 = state.func_177230_c() instanceof IFluidBlock && (Integer)state.func_177229_b((IProperty)LEVEL) == 0;
        boolean bl = flag3 = state.func_177230_c() instanceof IFluidBlock && ((IFluidBlock)state.func_177230_c()).getFluid() == this.fluid;
        boolean flag4 = this.fluid.getBlock() instanceof BlockLiquid ? state.func_185904_a() == this.field_149764_J : flag3;
        return !flag && !flag2 && (flag4 || this.canDisplace(world, pos));
    }

    public Vec3d getFlowVector(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int speedX = 0;
        int speedZ = 0;
        for (EnumFacing face : EnumFacing.field_176754_o) {
            if (!this.canSideFlow(state, world, pos, face) || !this.canFlowInto(world, pos.func_177972_a(face))) continue;
            speedX += face.func_176730_m().func_177958_n();
            speedZ += face.func_176730_m().func_177952_p();
        }
        return new Vec3d((double)speedX, super.getFlowVector((IBlockAccess)world, (BlockPos)pos).field_72448_b, (double)speedZ);
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        if (block.isAir(state, world, pos)) {
            return true;
        }
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return (Boolean)this.displacements.get(block);
        }
        if (material.func_76230_c() || material == Material.field_151567_E || material == Material.field_189963_J) {
            return false;
        }
        boolean replaceable = block.func_176200_f(world, pos);
        int density = AbstractFluidloggedBlock.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            return replaceable;
        }
        return replaceable && this.density > density;
    }

    @Nullable
    public FluidStack drain(World world, BlockPos pos, boolean doDrain) {
        if (doDrain) {
            IBlockState state = world.func_180495_p(pos);
            this.func_176226_b(world, pos, state, 0);
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            world.func_175698_g(pos);
        }
        return this.stack.copy();
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        this.updateQuanta();
        boolean canFlowVertical = this.canSideFlow(state, (IBlockAccess)world, pos, this.densityDir < 0 ? EnumFacing.DOWN : EnumFacing.UP);
        if (canFlowVertical && this.canDisplace((IBlockAccess)world, pos.func_177981_b(this.densityDir))) {
            this.flowIntoBlock(world, pos.func_177981_b(this.densityDir), 1);
            return;
        }
        if (1 >= this.quantaPerBlock) {
            return;
        }
        if (!canFlowVertical || !this.isFlowingVertically((IBlockAccess)world, pos)) {
            boolean[] flowTo = this.getOptimalFlowDirections(world, pos);
            for (int i = 0; i < 4; ++i) {
                int meta;
                int n = meta = !this.canSideFlow(state, (IBlockAccess)world, pos, (EnumFacing)SIDES.get(i)) ? -1 : 1;
                if (!flowTo[i]) continue;
                this.flowIntoBlock(world, pos.func_177972_a((EnumFacing)SIDES.get(i)), meta);
            }
        }
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState oldState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        boolean e;
        boolean w;
        boolean s;
        boolean n;
        int j;
        int i;
        this.updateQuanta();
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty((IUnlistedProperty)FLOW_DIRECTION, (Object)Float.valueOf((float)AbstractFluidloggedBlock.getFlowDirection((IBlockAccess)world, (BlockPos)pos)));
        IBlockState[][] upBlockState = new IBlockState[3][3];
        upBlockState[1][1] = world.func_180495_p(pos.func_177979_c(this.densityDir));
        float[][] corner = new float[2][2];
        float[][] height = new float[3][3];
        height[1][1] = this.getFluidHeightForRender(world, pos, upBlockState[1][1]);
        if (height[1][1] == 1.0f) {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = 1.0f;
                }
            }
        } else {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (i == 1 && j == 1) continue;
                    upBlockState[i][j] = world.func_180495_p(pos.func_177982_a(i - 1, 0, j - 1).func_177979_c(this.densityDir));
                    height[i][j] = this.getFluidHeightForRender(world, pos.func_177982_a(i - 1, 0, j - 1), upBlockState[i][j]);
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = this.getFluidHeightAverage(new float[]{height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]});
                }
            }
            n = AbstractFluidloggedBlock.isFluid(upBlockState[0][1]);
            s = AbstractFluidloggedBlock.isFluid(upBlockState[2][1]);
            w = AbstractFluidloggedBlock.isFluid(upBlockState[1][0]);
            e = AbstractFluidloggedBlock.isFluid(upBlockState[1][2]);
            boolean nw = AbstractFluidloggedBlock.isFluid(upBlockState[0][0]);
            boolean ne = AbstractFluidloggedBlock.isFluid(upBlockState[0][2]);
            boolean sw = AbstractFluidloggedBlock.isFluid(upBlockState[2][0]);
            boolean se = AbstractFluidloggedBlock.isFluid(upBlockState[2][2]);
            if (nw || n || w) {
                corner[0][0] = 1.0f;
            }
            if (ne || n || e) {
                corner[0][1] = 1.0f;
            }
            if (sw || s || w) {
                corner[1][0] = 1.0f;
            }
            if (se || s || e) {
                corner[1][1] = 1.0f;
            }
        }
        if (height[1][1] != 1.0f || !this.canSideFlow(oldState, world, pos, this.densityDir == 1 ? EnumFacing.UP : EnumFacing.DOWN)) {
            n = !this.canSideFlow(oldState, world, pos, EnumFacing.NORTH);
            s = !this.canSideFlow(oldState, world, pos, EnumFacing.SOUTH);
            w = !this.canSideFlow(oldState, world, pos, EnumFacing.WEST);
            e = !this.canSideFlow(oldState, world, pos, EnumFacing.EAST);
            boolean nFull = AbstractFluidloggedBlock.isFullFluid(world, pos.func_177972_a(EnumFacing.NORTH));
            boolean sFull = AbstractFluidloggedBlock.isFullFluid(world, pos.func_177972_a(EnumFacing.SOUTH));
            boolean eFull = AbstractFluidloggedBlock.isFullFluid(world, pos.func_177972_a(EnumFacing.EAST));
            boolean wFull = AbstractFluidloggedBlock.isFullFluid(world, pos.func_177972_a(EnumFacing.WEST));
            if ((n || w) && !nFull && !wFull) {
                corner[0][0] = this.quantaFraction;
            }
            if ((s || w) && !sFull && !wFull) {
                corner[0][1] = this.quantaFraction;
            }
            if ((n || e) && !nFull && !eFull) {
                corner[1][0] = this.quantaFraction;
            }
            if ((s || e) && !sFull && !eFull) {
                corner[1][1] = this.quantaFraction;
            }
        }
        for (i = 0; i < 4; ++i) {
            EnumFacing side = EnumFacing.func_176731_b((int)i);
            BlockPos offset = pos.func_177972_a(side);
            boolean useOverlay = world.func_180495_p(offset).func_193401_d(world, offset, side.func_176734_d()) == BlockFaceShape.SOLID;
            state = state.withProperty((IUnlistedProperty)SIDE_OVERLAYS[i], (Object)useOverlay);
        }
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[0], (Object)Float.valueOf(corner[0][0]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[1], (Object)Float.valueOf(corner[0][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[2], (Object)Float.valueOf(corner[1][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[3], (Object)Float.valueOf(corner[1][0]));
        return state;
    }

    protected static boolean isFluid(IBlockState state) {
        return state.func_185904_a().func_76224_d() || state.func_177230_c() instanceof IFluidBlock;
    }

    protected static boolean isFullFluid(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!AbstractFluidloggedBlock.isFluid(state)) {
            return false;
        }
        if (state.func_177230_c() instanceof BlockFluidClassic) {
            return !((BlockFluidClassic)state.func_177230_c()).isSourceBlock(world, pos);
        }
        return state.func_177230_c() instanceof BlockFluidFinite || state.func_177230_c().func_176201_c(state) != 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, this.fluid.getBlock().func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        try {
            double z;
            double x;
            if (entityIn.field_70163_u - (double)((int)entityIn.field_70163_u) < 1.0 && (double)entityIn.field_82151_R + (double)MathHelper.func_76133_a((double)((x = entityIn.field_70165_t - entityIn.field_70169_q) * x + (z = entityIn.field_70161_v - entityIn.field_70166_s) * z)) * 0.6 > (double)nextStepDistance.getInt(entityIn)) {
                SoundType type = this.getSoundType(worldIn.func_180495_p(pos), worldIn, pos, entityIn);
                IBlockState up = worldIn.func_180495_p(pos.func_177984_a());
                if (up.func_177230_c() instanceof BlockSnow) {
                    type = up.func_177230_c().getSoundType(up, worldIn, pos.func_177984_a(), entityIn);
                }
                entityIn.func_184185_a(type.func_185844_d(), type.func_185843_a() * 0.15f, type.func_185847_b());
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public float getFilledPercentage(IBlockAccess world, BlockPos pos) {
        if (!(this.fluid.getBlock() instanceof BlockFluidBase)) {
            return super.getFilledPercentage(world, pos);
        }
        return ((BlockFluidBase)this.fluid.getBlock()).getFilledPercentage(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        return this.fluid.getBlock().getFogColor(world, pos, this.fluid.getBlock().func_176223_P(), entity, originalColor, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.fluid.getBlock().func_180655_c(this.fluid.getBlock().func_176223_P(), worldIn, pos, rand);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        this.fluid.getBlock().func_180634_a(worldIn, pos, this.fluid.getBlock().func_176223_P(), entityIn);
    }

    @Nullable
    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        return this.fluid.getBlock().isEntityInsideMaterial(world, blockpos, this.fluid.getBlock().func_176223_P(), entity, yToTest, materialIn, testingHead);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.fluid.getBlock().isFireSource(world, pos, side);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fluid.getBlock().getFlammability(world, pos, face);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fluid.getBlock().isFlammable(world, pos, face);
    }

    public int func_149750_m(IBlockState state) {
        return this.fluid.getBlock().func_176223_P().func_185906_d();
    }

    public int func_149717_k(IBlockState state) {
        return this.fluid.getBlock().func_176223_P().func_185891_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return this.fluid.getBlock().func_176223_P().func_185889_a(world, pos);
    }

    public boolean func_176205_b(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return this.fluid.getBlock().func_176205_b(world, pos);
    }

    static {
        canCreateSourcesField.setAccessible(true);
        quantaPerBlockField.setAccessible(true);
        nextStepDistance.setAccessible(true);
    }
}

