/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged.common.block;

import com.google.common.collect.ImmutableList;
import git.jbredwards.fluidlogged.common.block.AbstractFluidloggedBlock;
import git.jbredwards.fluidlogged.common.block.TileEntityFluidlogged;
import git.jbredwards.fluidlogged.util.FluidloggedUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFluidloggedTE
extends AbstractFluidloggedBlock
implements ITileEntityProvider,
IGrowable,
IShearable {
    public static final Method doubleSlabMethod = ObfuscationReflectionHelper.findMethod(ItemSlab.class, (String)"func_185055_a", IBlockState.class, (Class[])new Class[]{IProperty.class, Comparable.class});

    public BlockFluidloggedTE(Fluid fluid, Material material, MapColor mapColor) {
        super(fluid, material, mapColor);
    }

    public BlockFluidloggedTE(Fluid fluid, Material material) {
        super(fluid, material);
    }

    @Nonnull
    public IBlockState getStored(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFluidlogged) {
            return ((TileEntityFluidlogged)te).getStored();
        }
        return Blocks.field_180401_cv.func_176223_P();
    }

    public void setStored(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState stored, boolean notify) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFluidlogged) {
            if (FluidloggedUtils.isStateFluidloggable(stored)) {
                ((TileEntityFluidlogged)te).setStored(stored, notify);
            } else if (world instanceof World) {
                if (stored.func_185904_a() != Material.field_151579_a) {
                    ((World)world).func_175656_a(pos, stored);
                } else {
                    ((World)world).func_175656_a(pos, this.fluid.getBlock().func_176223_P());
                }
            }
        }
    }

    public String func_149739_a() {
        return this.fluid.getBlock().func_149739_a();
    }

    public String func_149732_F() {
        return this.fluid.getBlock().func_149732_F();
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        return id == 1;
    }

    @Nullable
    public TileEntityFluidlogged createNewTileEntity(World worldIn, int meta) {
        return new TileEntityFluidlogged();
    }

    @Nullable
    public TileEntityFluidlogged createTileEntity(World world, IBlockState state) {
        return new TileEntityFluidlogged();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        boolean ret = super.func_176225_a(state, world, pos, side);
        IBlockState stored = this.getStored(world, pos);
        if (ret && stored.func_185901_i() == EnumBlockRenderType.INVISIBLE) {
            return true;
        }
        if (ret && stored.func_177230_c().func_180664_k() != BlockRenderLayer.SOLID) {
            return true;
        }
        if (ret && !this.canSideFlow(stored, world, pos, side)) {
            return false;
        }
        return ret;
    }

    @Override
    public boolean canRenderInLayer(IBlockState ignored, BlockRenderLayer layer) {
        return this.fluid.getBlock().canRenderInLayer(this.fluid.getBlock().func_176223_P(), layer);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    @Override
    @Nullable
    public FluidStack drain(World world, BlockPos pos, boolean doDrain) {
        if (doDrain && !FluidloggedUtils.tryUnfluidlogBlock(world, pos, null)) {
            return null;
        }
        return this.stack.copy();
    }

    @Override
    public boolean canSideFlow(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState stored = this.getStored(world, pos);
        if (stored.func_177230_c() instanceof BlockTrapDoor) {
            if (!((Boolean)stored.func_177229_b((IProperty)BlockTrapDoor.field_176283_b)).booleanValue()) {
                boolean bottom;
                boolean bl = bottom = stored.func_177229_b((IProperty)BlockTrapDoor.field_176285_M) == BlockTrapDoor.DoorHalf.BOTTOM;
                if (bottom && side == EnumFacing.DOWN) {
                    return false;
                }
                return bottom || side != EnumFacing.UP;
            }
            return ((EnumFacing)stored.func_177229_b((IProperty)BlockTrapDoor.field_176284_a)).func_176734_d() != side;
        }
        return stored.func_193401_d(world, pos, side) != BlockFaceShape.SOLID;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        float hardness = stored.func_185887_b(worldIn, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (this.canHarvestBlock(stored, player, (IBlockAccess)worldIn, pos)) {
            return player.getDigSpeed(stored, pos) / hardness / 30.0f;
        }
        return player.getDigSpeed(stored, pos) / hardness / 100.0f;
    }

    protected boolean canHarvestBlock(IBlockState state, EntityPlayer player, IBlockAccess world, BlockPos pos) {
        if ((state = state.func_185899_b(world, pos)).func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack held = player.func_184614_ca();
        String tool = state.func_177230_c().getHarvestTool(state);
        String string = tool = tool == null && state.func_185904_a() == Material.field_151576_e ? "pickaxe" : tool;
        if (held.func_190926_b() || tool == null) {
            return player.func_184823_b(state);
        }
        int level = held.func_77973_b().getHarvestLevel(held, tool, player, state);
        if (level > 0) {
            return player.func_184823_b(state);
        }
        return level >= state.func_177230_c().getHarvestLevel(state);
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        state = this.getStored((IBlockAccess)worldObj, blockPosition);
        if (!state.func_177230_c().addLandingEffects(state, worldObj, blockPosition, iblockstate, entity, numberOfParticles)) {
            worldObj.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)state)});
        }
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        state = this.getStored((IBlockAccess)world, pos);
        if (state.func_185901_i() != EnumBlockRenderType.INVISIBLE && !state.func_177230_c().addRunningEffects(state, world, pos, entity)) {
            world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + (double)new Random().nextFloat() - 0.5 * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + (double)new Random().nextFloat() - 0.5 * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a();
        EnumFacing side = target.field_178784_b;
        state = this.getStored((IBlockAccess)worldObj, pos);
        if (!state.func_177230_c().addHitEffects(state, worldObj, target, manager) && state.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            AxisAlignedBB aabb = state.func_185900_c((IBlockAccess)worldObj, pos);
            double x = (double)pos.func_177958_n() + worldObj.field_73012_v.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a - (double)0.2f) + (double)0.1f + aabb.field_72340_a;
            double y = (double)pos.func_177956_o() + worldObj.field_73012_v.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b - (double)0.2f) + (double)0.1f + aabb.field_72338_b;
            double z = (double)pos.func_177952_p() + worldObj.field_73012_v.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c - (double)0.2f) + (double)0.1f + aabb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                y = (double)pos.func_177956_o() + aabb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                y = (double)pos.func_177956_o() + aabb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                z = (double)pos.func_177952_p() + aabb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                z = (double)pos.func_177952_p() + aabb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                x = (double)pos.func_177958_n() + aabb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                x = (double)pos.func_177958_n() + aabb.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(((ParticleDigging)Objects.requireNonNull(new ParticleDigging.Factory().func_178902_a(0, worldObj, x, y, z, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)}))).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState stored = this.getStored((IBlockAccess)world, pos);
        if (!stored.func_177230_c().addDestroyEffects(world, pos, manager)) {
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    for (int z = 0; z < 4; ++z) {
                        double posX = ((double)x + 0.5) / 4.0;
                        double posY = ((double)y + 0.5) / 4.0;
                        double posZ = ((double)z + 0.5) / 4.0;
                        manager.func_78873_a((Particle)((ParticleDigging)Objects.requireNonNull(new ParticleDigging.Factory().func_178902_a(0, world, (double)pos.func_177958_n() + posX, (double)pos.func_177956_o() + posY, (double)pos.func_177952_p() + posZ, posX - 0.5, posY - 0.5, posZ - 0.5, new int[]{Block.func_176210_f((IBlockState)stored)}))).func_174846_a(pos));
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IBlockState stored = this.getStored((IBlockAccess)world, pos);
        if (!player.func_184812_l_() && this.canHarvestBlock(stored, player, (IBlockAccess)world, pos)) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
            List drops = stored.func_177230_c().getDrops((IBlockAccess)world, pos, stored, fortune);
            for (ItemStack drop : drops) {
                BlockFluidloggedTE.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
        }
        return world.func_180501_a(pos, this.fluid.getBlock().func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState stored = this.getStored(world, pos);
        if (stored.func_177230_c() instanceof BlockWall) {
            BlockFaceShape shape = stored.func_193401_d(world, pos, facing);
            return (shape == BlockFaceShape.MIDDLE_POLE_THICK || shape == BlockFaceShape.MIDDLE_POLE) && stored.func_177230_c() instanceof BlockFenceGate;
        }
        if (stored.func_177230_c() instanceof BlockFence) {
            BlockFaceShape shape = stored.func_193401_d(world, pos, facing);
            IBlockState neighbor = FluidloggedUtils.getStoredOrReal(world, pos.func_177972_a(facing));
            return shape == BlockFaceShape.MIDDLE_POLE && stored.func_185904_a() == neighbor.func_185904_a();
        }
        return stored.func_177230_c().canBeConnectedTo(world, pos, facing);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        ItemStack held = playerIn.func_184586_b(hand);
        boolean storedAction = stored.func_177230_c().func_180639_a(worldIn, pos, stored, playerIn, hand, facing, hitX, hitY, hitZ);
        if (!storedAction && stored.func_177230_c() instanceof BlockSlab && held.func_77973_b() instanceof ItemSlab && ((ItemSlab)held.func_77973_b()).func_179223_d() == stored.func_177230_c()) {
            boolean topHalf;
            ItemSlab itemSlab = (ItemSlab)held.func_77973_b();
            BlockSlab blockSlab = (BlockSlab)stored.func_177230_c();
            boolean bl = topHalf = stored.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
            if (topHalf && facing == EnumFacing.DOWN || !topHalf && facing == EnumFacing.UP) {
                try {
                    IBlockState doubleSlab = (IBlockState)doubleSlabMethod.invoke((Object)itemSlab, blockSlab.func_176551_l(), stored.func_177229_b(blockSlab.func_176551_l()));
                    AxisAlignedBB slabAABB = doubleSlab.func_185890_d((IBlockAccess)worldIn, pos);
                    if ((slabAABB == null || worldIn.func_72855_b(slabAABB.func_186670_a(pos))) && worldIn.func_180501_a(pos, doubleSlab, 11)) {
                        SoundType sound = doubleSlab.func_177230_c().getSoundType(doubleSlab, worldIn, pos, (Entity)playerIn);
                        worldIn.func_184133_a(null, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                        if (playerIn instanceof EntityPlayerMP) {
                            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)playerIn, pos, held);
                        }
                        if (!playerIn.func_184812_l_()) {
                            held.func_190918_g(1);
                        }
                        worldIn.func_175684_a(pos, (Block)this, this.tickRate);
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (storedAction) {
            worldIn.func_175684_a(pos, (Block)this, this.tickRate);
        }
        return storedAction;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        stored.func_177230_c().func_180649_a(worldIn, pos, playerIn);
    }

    @Override
    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        stored.func_177230_c().func_176199_a(worldIn, pos, entityIn);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        stored.func_177230_c().func_180634_a(worldIn, pos, stored, entityIn);
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return this.canHarvestBlock(this.getStored(world, pos), player, world, pos);
    }

    @Nonnull
    public Vec3d func_176197_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Entity entity, @Nonnull Vec3d vec) {
        Vec3d oldSpeed = super.func_176197_a(world, pos, entity, vec);
        Vec3d newSpeed = this.getStored((IBlockAccess)world, pos).func_177230_c().func_176197_a(world, pos, entity, vec);
        return oldSpeed.func_178787_e(newSpeed);
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighbourPos) {
        this.getStored((IBlockAccess)world, pos).func_189546_a(world, pos, neighborBlock, neighbourPos);
        super.func_189540_a(state, world, pos, neighborBlock, neighbourPos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        stored.func_177230_c().func_180655_c(stored, worldIn, pos, rand);
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityLiving entity) {
        IBlockState stored = this.getStored(world, pos);
        return stored.func_177230_c().getAiPathNodeType(stored, world, pos, entity);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        stored.func_177230_c().func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState stored = this.getStored(world, pos);
        return stored.func_177230_c().getAiPathNodeType(stored, world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState stored = this.getStored(source, pos);
        return stored.func_185900_c(source, pos);
    }

    @Override
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        IBlockState stored = this.getStored(worldIn, pos);
        return stored.func_185890_d(worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        return stored.func_185918_c(worldIn, pos);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        stored.func_177230_c().func_180657_a(worldIn, player, pos, stored, te, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        stored.func_177230_c().func_176208_a(worldIn, pos, stored, player);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState stored = this.getStored(world, pos);
        return stored.func_177230_c().getExpDrop(stored, world, pos, fortune);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        return stored.func_177230_c().func_185473_a(worldIn, pos, stored);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IBlockState stored = this.getStored((IBlockAccess)world, pos);
        return stored.func_177230_c().getPickBlock(stored, target, world, pos, player);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        IBlockState stored = this.getStored((IBlockAccess)world, pos);
        return stored.func_177230_c().canSilkHarvest(world, pos, stored, player);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        IBlockState stored = this.getStored((IBlockAccess)world, pos);
        return stored.func_177230_c().getSoundType(stored, world, pos, entity);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        IBlockState stored = this.getStored((IBlockAccess)world, pos);
        return stored.func_177230_c().getExplosionResistance(world, pos, exploder, explosion);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        return stored.func_185887_b(worldIn, pos);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        return stored.func_185910_a(worldIn, pos, start, end);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        stored.func_185908_a(worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    @Override
    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        IBlockState stored = this.getStored(worldIn, pos);
        return stored.func_193401_d(worldIn, pos, face);
    }

    public int getLightValue(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockState stored = this.getStored(world, pos);
        return Math.min(stored.getLightValue(world, pos) + super.getLightValue(state, world, pos), 15);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        return stored.func_177230_c() instanceof IGrowable && ((IGrowable)stored.func_177230_c()).func_176473_a(worldIn, pos, stored, isClient);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        return stored.func_177230_c() instanceof IGrowable && ((IGrowable)stored.func_177230_c()).func_180670_a(worldIn, rand, pos, stored);
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        IBlockState stored = this.getStored((IBlockAccess)worldIn, pos);
        if (stored.func_177230_c() instanceof IGrowable) {
            ((IGrowable)stored.func_177230_c()).func_176474_b(worldIn, rand, pos, stored);
        }
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        IBlockState stored = this.getStored(world, pos);
        return stored.func_177230_c() instanceof IShearable && ((IShearable)stored.func_177230_c()).isShearable(item, world, pos);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState stored = this.getStored(world, pos);
        return stored.func_177230_c() instanceof IShearable ? ((IShearable)stored.func_177230_c()).onSheared(item, world, pos, fortune) : ImmutableList.of();
    }

    static {
        doubleSlabMethod.setAccessible(true);
    }
}

