/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged.common.event;

import git.jbredwards.fluidlogged.Fluidlogged;
import git.jbredwards.fluidlogged.common.block.AbstractFluidloggedBlock;
import git.jbredwards.fluidlogged.common.block.BlockFluidloggedTE;
import git.jbredwards.fluidlogged.common.block.TileEntityFluidlogged;
import git.jbredwards.fluidlogged.util.FluidloggedUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="fluidlogged_api")
public final class FluidloggedEvents {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ((Block)Fluidlogged.WATERLOGGED_TE.setRegistryName("waterlogged_te")).func_149663_c("water");
        ((Block)Fluidlogged.LAVALOGGED_TE.setRegistryName("lavalogged_te")).func_149663_c("lava");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{Fluidlogged.WATERLOGGED_TE, Fluidlogged.LAVALOGGED_TE});
        GameRegistry.registerTileEntity(TileEntityFluidlogged.class, (ResourceLocation)new ResourceLocation("fluidlogged_api", "te"));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomStateMapper((Block)Fluidlogged.WATERLOGGED_TE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)Fluidlogged.LAVALOGGED_TE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void showFluidloggedBarrier(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        WorldClient world = mc.field_71441_e;
        if (player != null && world != null) {
            BlockPos origin = new BlockPos((Entity)player);
            if (player.func_184812_l_() && world.func_82737_E() % 80L == 0L && player.func_184614_ca().func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv)) {
                for (int x = -32; x < 32; ++x) {
                    for (int y = -32; y < 32; ++y) {
                        for (int z = -32; z < 32; ++z) {
                            boolean flag;
                            BlockPos pos = origin.func_177982_a(x, y, z);
                            TileEntity te = world.func_175625_s(pos);
                            boolean bl = flag = te instanceof TileEntityFluidlogged && ((TileEntityFluidlogged)te).getStored().func_177230_c() == Blocks.field_180401_cv;
                            if (!flag) continue;
                            world.func_175688_a(EnumParticleTypes.BARRIER, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void showAdditionalDebugData(RenderGameOverlayEvent.Text event) {
        IBlockState stored;
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        RayTraceResult trace = mc.field_71476_x;
        if (world != null && trace != null && !event.getLeft().isEmpty() && !event.getRight().isEmpty() && (stored = FluidloggedUtils.getStored((IBlockAccess)world, trace.func_178782_a())) != null) {
            stored = stored.func_185899_b((IBlockAccess)world, trace.func_178782_a());
            event.getRight().add("");
            event.getRight().add(Optional.ofNullable(stored.func_177230_c().getRegistryName()).orElse(new ResourceLocation("barrier")).toString());
            for (Map.Entry entry : stored.func_177228_b().entrySet()) {
                String value = ((Comparable)entry.getValue()).toString();
                if (value.equals("true")) {
                    value = TextFormatting.GREEN + value;
                } else if (value.equals("false")) {
                    value = TextFormatting.RED + value;
                }
                event.getRight().add(((IProperty)entry.getKey()).func_177701_a() + ": " + value);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void fluidPlaceOrTake(FillBucketEvent event) {
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)event.getEmptyBucket());
        if (handler != null && event.getTarget() != null) {
            FluidStack fluidStack = handler.drain(1000, false);
            BlockPos pos = event.getTarget().func_178782_a();
            World world = event.getWorld();
            EnumFacing sideHit = event.getTarget().field_178784_b;
            if (fluidStack == null) {
                if (FluidloggedEvents.runBucketEmpty(event, world, world.func_180495_p(pos), pos, event.getEntityPlayer())) {
                    return;
                }
                FluidloggedEvents.runBucketEmpty(event, world, world.func_180495_p(pos.func_177972_a(sideHit)), pos.func_177972_a(sideHit), event.getEntityPlayer());
            } else {
                if (FluidloggedEvents.runBucketFull(event, world, world.func_180495_p(pos), pos, event.getEntityPlayer(), fluidStack)) {
                    return;
                }
                FluidloggedEvents.runBucketFull(event, world, world.func_180495_p(pos.func_177972_a(sideHit)), pos.func_177972_a(sideHit), event.getEntityPlayer(), fluidStack);
            }
        }
    }

    private static boolean runBucketEmpty(FillBucketEvent event, World world, IBlockState here, BlockPos pos, EntityPlayer player) {
        if (here.func_177230_c() instanceof BlockFluidloggedTE && FluidloggedUtils.tryUnfluidlogBlock(world, pos, here)) {
            Fluid fluid = ((BlockFluidloggedTE)here.func_177230_c()).fluid;
            SoundEvent sound = fluid.getFillSound(new FluidStack(fluid, 1000));
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.setFilledBucket(FluidloggedUtils.getFilledBucket(event.getEmptyBucket(), fluid));
            event.setResult(Event.Result.ALLOW);
            return true;
        }
        if (here.func_177230_c() instanceof AbstractFluidloggedBlock && !here.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    private static boolean runBucketFull(FillBucketEvent event, World world, IBlockState here, BlockPos pos, EntityPlayer player, FluidStack fluidStack) {
        if (FluidloggedUtils.tryFluidlogBlock(world, pos, here, fluidStack.getFluid(), false)) {
            SoundEvent sound = fluidStack.getFluid().getEmptySound(fluidStack);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.setFilledBucket(FluidloggedUtils.getEmptyBucket(event.getEmptyBucket()));
            event.setResult(Event.Result.ALLOW);
            return true;
        }
        if (here.func_177230_c() instanceof AbstractFluidloggedBlock && !here.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void placeBlockInFluid(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        World world;
        IBlockState here;
        Fluid fluid;
        EnumFacing facing = event.getFace();
        ItemStack held = event.getItemStack();
        if (facing != null && held.func_77973_b() instanceof ItemBlock && (fluid = FluidloggedEvents.getFluid(here = (world = event.getWorld()).func_180495_p(pos = event.getPos().func_177972_a(facing)))) != null && !(here.func_177230_c() instanceof AbstractFluidloggedBlock)) {
            int meta = held.func_77973_b().func_77647_b(held.func_77960_j());
            Vec3d hit = Optional.ofNullable(event.getHitVec()).orElse(new Vec3d((Vec3i)pos));
            EntityPlayer player = event.getEntityPlayer();
            IBlockState stored = ((ItemBlock)held.func_77973_b()).func_179223_d().getStateForPlacement(world, pos, facing, (float)hit.field_72450_a - (float)pos.func_177958_n(), (float)hit.field_72448_b - (float)pos.func_177956_o(), (float)hit.field_72449_c - (float)pos.func_177952_p(), meta, (EntityLivingBase)player, event.getHand());
            if (FluidloggedUtils.tryFluidlogBlock(world, pos, stored, fluid, true)) {
                SoundType sound = stored.func_177230_c().getSoundType(stored, world, pos, (Entity)player);
                world.func_184133_a(null, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, event.getItemStack());
                }
                if (!player.func_184812_l_()) {
                    event.getItemStack().func_190918_g(1);
                }
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        }
    }

    @Nullable
    public static Fluid getFluid(IBlockState state) {
        if ((state.func_177230_c() instanceof BlockFluidClassic || state.func_177230_c() instanceof BlockLiquid) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (state.func_177230_c() instanceof BlockFluidClassic) {
                return ((BlockFluidClassic)state.func_177230_c()).getFluid();
            }
            if (state.func_185904_a() == Material.field_151586_h) {
                return FluidRegistry.WATER;
            }
            return FluidRegistry.LAVA;
        }
        return null;
    }
}

