/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged.util;

import git.jbredwards.fluidlogged.common.block.BlockFluidloggedTE;
import git.jbredwards.fluidlogged.common.block.IFluidloggable;
import git.jbredwards.fluidlogged.common.block.TileEntityFluidlogged;
import git.jbredwards.fluidlogged.common.event.FluidloggedEvent;
import git.jbredwards.fluidlogged.util.FluidloggedConstants;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBarrier;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.ItemHandlerHelper;

public enum FluidloggedUtils {


    @Nullable
    public static IBlockState getStored(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityFluidlogged)) {
            return null;
        }
        return ((TileEntityFluidlogged)te).getStored();
    }

    public static IBlockState getStoredOrReal(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockState here = world.func_180495_p(pos);
        if (!(here.func_177230_c() instanceof BlockFluidloggedTE)) {
            return here;
        }
        return ((BlockFluidloggedTE)here.func_177230_c()).getStored(world, pos);
    }

    public static void setStoredOrReal(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState here, @Nullable IBlockState state, boolean notify) {
        IBlockState stored = FluidloggedUtils.getStored((IBlockAccess)world, pos);
        if (state == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        if (stored == null) {
            world.func_180501_a(pos, state, notify ? 3 : 0);
            return;
        }
        if (here == null) {
            here = world.func_180495_p(pos);
        }
        if (here.func_177230_c() instanceof BlockFluidloggedTE) {
            if (state.func_177230_c() == Blocks.field_150350_a) {
                world.func_180501_a(pos, ((BlockFluidloggedTE)here.func_177230_c()).fluid.getBlock().func_176223_P(), notify ? 3 : 0);
                return;
            }
            if (!FluidloggedUtils.isStateFluidloggable(state)) {
                world.func_180501_a(pos, state, notify ? 3 : 0);
                return;
            }
            ((BlockFluidloggedTE)here.func_177230_c()).setStored((IBlockAccess)world, pos, state, notify);
        } else {
            world.func_180501_a(pos, state, notify ? 3 : 0);
        }
    }

    public static boolean isStateFluidloggable(@Nullable IBlockState state) {
        return FluidloggedUtils.isStateFluidloggable(state, null);
    }

    public static boolean isStateFluidloggable(@Nullable IBlockState state, @Nullable Fluid fluid) {
        if (state == null) {
            return false;
        }
        FluidloggedEvent.CheckFluidloggable event = new FluidloggedEvent.CheckFluidloggable(state, fluid);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        Block block = state.func_177230_c();
        if (block instanceof IFluidloggable) {
            return ((IFluidloggable)block).isFluidValid(state, fluid);
        }
        if (block instanceof ITileEntityProvider) {
            return false;
        }
        return block instanceof BlockSlab && !((BlockSlab)block).func_176552_j() || block instanceof BlockStairs || block instanceof BlockPane || block instanceof BlockFence || block instanceof BlockEndRod || block instanceof BlockWall || block instanceof BlockBarrier || block instanceof BlockLeaves || block instanceof BlockFenceGate || block instanceof BlockTrapDoor;
    }

    public static boolean tryFluidlogBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Fluid fluid, boolean ignoreVaporize) {
        return FluidloggedUtils.tryFluidlogBlock(world, pos, world.func_180495_p(pos), fluid, ignoreVaporize);
    }

    public static boolean tryFluidlogBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState here, @Nonnull Fluid fluid, boolean ignoreVaporize) {
        if (FluidloggedUtils.isStateFluidloggable(here, fluid)) {
            IBlockState stored = here.func_177230_c() instanceof IFluidloggable ? ((IFluidloggable)here.func_177230_c()).getFluidloggedState(world, pos, here) : here;
            BlockFluidloggedTE block = FluidloggedConstants.FLUIDLOGGED_TE_LOOKUP.get(fluid);
            if (block != null) {
                FluidloggedEvent.Fluidlog event = new FluidloggedEvent.Fluidlog(world, pos, here, stored, block, new TileEntityFluidlogged(), ignoreVaporize);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                if (event.getResult() == Event.Result.DENY) {
                    return false;
                }
                if (event.getResult() == Event.Result.ALLOW) {
                    return true;
                }
                if (!event.ignoreVaporize && world.field_73011_w.func_177500_n() && fluid.doesVaporize(new FluidStack(fluid, 1000))) {
                    for (int i = 0; i < 8; ++i) {
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                    }
                    world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                    return false;
                }
                event.te.setStored(event.stored, false);
                world.func_175656_a(pos, event.block.func_176223_P());
                world.func_175690_a(pos, (TileEntity)event.te);
                return true;
            }
        }
        return false;
    }

    public static boolean tryUnfluidlogBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState here) {
        return FluidloggedUtils.tryUnfluidlogBlock(world, pos, here, FluidloggedUtils.getStored((IBlockAccess)world, pos));
    }

    public static boolean tryUnfluidlogBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState here, @Nullable IBlockState stored) {
        IBlockState toCreate;
        FluidloggedEvent.UnFluidlog event;
        if (stored == null) {
            return false;
        }
        if (here == null) {
            here = world.func_180495_p(pos);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new FluidloggedEvent.UnFluidlog(world, pos, here, stored, toCreate = stored.func_177230_c() instanceof IFluidloggable ? ((IFluidloggable)stored.func_177230_c()).getNonFluidloggedState(world, pos, stored) : stored)))) {
            return false;
        }
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        world.func_175656_a(pos, event.toCreate);
        return true;
    }

    public static ItemStack getFilledBucket(@Nonnull ItemStack empty, @Nonnull Fluid fluid) {
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)(empty = ItemHandlerHelper.copyStackWithSize((ItemStack)empty, (int)1)));
        if (handler != null) {
            handler.fill(new FluidStack(fluid, 1000), true);
            return handler.getContainer();
        }
        return empty;
    }

    public static ItemStack getEmptyBucket(@Nonnull ItemStack filled) {
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)(filled = ItemHandlerHelper.copyStackWithSize((ItemStack)filled, (int)1)));
        if (handler != null) {
            handler.drain(1000, true);
            return handler.getContainer();
        }
        return filled;
    }
}

