/*
 * Decompiled with CFR 0.152.
 */
package com.headfishindustries.hydrophobia;

import com.headfishindustries.hydrophobia.ConfigHandler;
import com.headfishindustries.hydrophobia.Hydrophobia;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class EventHandler {
    static double rainChance = ConfigHandler.rainCancelChance;
    static int thunderMode = ConfigHandler.thunderMode;
    private static Map<World, Boolean> rainingMap = new HashMap<World, Boolean>();

    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.world.field_72995_K) {
            return;
        }
        WorldInfo wi = e.world.func_72912_H();
        rainingMap.put(e.world, wi.func_76059_o());
        if (wi.func_76083_p() == 1000 && e.world.field_73012_v.nextDouble() <= rainChance / 100.0) {
            wi.func_76080_g(0);
            wi.func_76084_b(false);
            Hydrophobia.LOGGER.info("The rain is staved off.");
        }
        if (e.world.func_72911_I() && thunderMode > 0) {
            if (thunderMode == 1) {
                e.world.func_72912_H().func_76090_f(0);
                e.world.func_72912_H().func_76069_a(false);
                e.world.func_72912_H().func_76084_b(true);
            } else {
                e.world.func_72912_H().func_76080_g(0);
                e.world.func_72912_H().func_76090_f(0);
                e.world.func_72912_H().func_76084_b(false);
                e.world.func_72912_H().func_76069_a(false);
            }
            if (wi.func_76073_f() % 200L == 0L && wi.func_76061_m()) {
                switch (ConfigHandler.thunderMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        wi.func_76069_a(false);
                        wi.func_76084_b(true);
                        break;
                    }
                    case 2: {
                        wi.func_76069_a(false);
                        wi.func_76084_b(false);
                        wi.func_76080_g(0);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onWake(PlayerWakeUpEvent e) {
        final World w = e.getEntityPlayer().field_70170_p;
        if (w.field_72995_K) {
            return;
        }
        if (w.func_72820_D() % 24000L <= 10L && rainingMap.get(w).booleanValue() && w.field_73012_v.nextDouble() <= ConfigHandler.continueChance / 100.0) {
            Timer t = new Timer();
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    w.func_72912_H().func_76084_b(true);
                    w.func_72912_H().func_76080_g((300 + new Random().nextInt(600)) * 20);
                    Hydrophobia.LOGGER.info("The rain continues into the new day.");
                }
            }, 10L);
        }
    }
}

