/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.lumen.common.entities;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import ladysnake.lumen.common.config.LumenConfig;
import ladysnake.lumen.common.entities.AbstractLightOrb;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFirefly
extends AbstractLightOrb {
    private float scaleModifier;
    float colorModifier;
    private float alpha;
    private boolean canDespawn;
    protected boolean isAttractedByLight;
    protected boolean despawnOnDaytime;
    private double groundLevel;
    private BlockPos lightTarget;
    private double xTarget;
    private double yTarget;
    private double zTarget;
    private int targetChangeCooldown = 0;

    public EntityFirefly(World world) {
        super(world);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_70606_j(1.0f);
        this.scaleModifier = 0.1f + new Random().nextFloat() * 0.15f;
        this.colorModifier = 0.25f + new Random().nextFloat() * 0.75f;
        this.alpha = 1.0f;
        this.func_70105_a(this.scaleModifier, this.scaleModifier);
        this.canDespawn = true;
        this.isAttractedByLight = true;
        this.despawnOnDaytime = true;
    }

    public EntityFirefly(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public float getScaleModifier() {
        return this.scaleModifier;
    }

    public float getColorModifier() {
        return this.colorModifier;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    protected boolean func_70692_ba() {
        return this.canDespawn;
    }

    public void setCanDespawn(boolean canDespawn) {
        this.canDespawn = canDespawn;
    }

    public boolean isAttractedByLight() {
        return this.isAttractedByLight;
    }

    public void setAttractedByLight(boolean attractedByLight) {
        this.isAttractedByLight = attractedByLight;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.scaleModifier = compound.func_74760_g("scaleModifier");
        this.colorModifier = compound.func_74760_g("colorModifier");
        this.alpha = compound.func_74760_g("alpha");
        this.canDespawn = compound.func_74767_n("canDespawn");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("scaleModifier", this.scaleModifier);
        compound.func_74776_a("colorModifier", this.colorModifier);
        compound.func_74776_a("alpha", this.alpha);
        compound.func_74757_a("canDespawn", this.canDespawn);
    }

    @Override
    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70601_bi() {
        if (((Object)((Object)this)).getClass() == EntityFirefly.class) {
            return LumenConfig.spawnFireflies && !this.field_70170_p.func_72935_r() && !this.field_70170_p.func_72896_J() && super.func_70601_bi();
        }
        return super.func_70601_bi();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.despawnOnDaytime && this.canDespawn && this.alpha <= 0.0f) {
            this.func_70106_y();
        }
        if (this.field_70163_u > 300.0) {
            this.func_70076_C();
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.targetChangeCooldown -= this.func_174791_d().func_186679_c(this.field_70142_S, this.field_70137_T, this.field_70136_U) < 0.0125 ? 10 : 1;
            if (this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0 || this.func_180425_c().func_177954_c(this.xTarget, this.yTarget, this.zTarget) < 9.0 || this.targetChangeCooldown <= 0) {
                this.selectBlockTarget();
            }
            Vec3d targetVector = new Vec3d(this.xTarget - this.field_70165_t, this.yTarget - this.field_70163_u, this.zTarget - this.field_70161_v);
            double length = targetVector.func_72433_c();
            targetVector = targetVector.func_186678_a(0.1 / length);
            this.field_70159_w = 0.9 * this.field_70159_w + 0.1 * targetVector.field_72450_a;
            this.field_70181_x = 0.9 * this.field_70181_x + 0.1 * targetVector.field_72448_b;
            this.field_70179_y = 0.9 * this.field_70179_y + 0.1 * targetVector.field_72449_c;
            if (this.func_180425_c() != this.getTargetPosition()) {
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            if (this.func_70090_H()) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
            if (this.func_180799_ab()) {
                this.func_70097_a(DamageSource.field_76371_c, 1.0f);
            }
        }
    }

    private void selectBlockTarget() {
        if (this.lightTarget == null || !this.isAttractedByLight()) {
            this.groundLevel = 0.0;
            for (int i = 0; i < 20; ++i) {
                if (!this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)i, this.field_70161_v)).func_177230_c().func_181623_g()) {
                    this.groundLevel = this.field_70163_u - (double)i;
                }
                if (this.groundLevel != 0.0) break;
            }
            this.xTarget = this.field_70165_t + this.field_70146_Z.nextGaussian() * 10.0;
            this.yTarget = Math.min(Math.max(this.field_70163_u + this.field_70146_Z.nextGaussian() * 2.0, this.groundLevel), this.groundLevel + 4.0);
            this.zTarget = this.field_70161_v + this.field_70146_Z.nextGaussian() * 10.0;
            while (!this.field_70170_p.func_180495_p(new BlockPos(this.xTarget, this.yTarget, this.zTarget)).func_177230_c().func_181623_g()) {
                this.yTarget += 1.0;
            }
            if (this.field_70170_p.func_175721_c(this.func_180425_c(), true) > 8 && !this.field_70170_p.func_72935_r()) {
                this.lightTarget = this.getRandomLitBlockAround();
            }
        } else {
            BlockPos possibleTarget;
            this.xTarget = (double)this.lightTarget.func_177958_n() + this.field_70146_Z.nextGaussian();
            this.yTarget = (double)this.lightTarget.func_177956_o() + this.field_70146_Z.nextGaussian();
            this.zTarget = (double)this.lightTarget.func_177952_p() + this.field_70146_Z.nextGaussian();
            if (this.field_70170_p.func_175721_c(this.func_180425_c(), true) > 8 && this.field_70170_p.func_175721_c(possibleTarget = this.getRandomLitBlockAround(), true) > this.field_70170_p.func_175721_c(this.lightTarget, true)) {
                this.lightTarget = possibleTarget;
            }
            if (this.field_70170_p.func_175721_c(this.func_180425_c(), true) <= 8 || this.field_70170_p.func_72935_r()) {
                this.lightTarget = null;
            }
        }
        this.targetChangeCooldown = this.field_70146_Z.nextInt() % 100;
    }

    public BlockPos getTargetPosition() {
        return new BlockPos(this.xTarget, this.yTarget + 0.5, this.zTarget);
    }

    private void detectGroundLevel() {
        for (int i = 0; i < 20; ++i) {
            double groundTmp = 0.0;
            if (!this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)i, this.field_70161_v)).func_177230_c().func_181623_g()) {
                groundTmp = this.field_70163_u - (double)i;
            }
            if (groundTmp == 0.0) continue;
            this.groundLevel = groundTmp;
            break;
        }
    }

    private BlockPos getRandomLitBlockAround() {
        HashMap<BlockPos, Integer> randBlocks = new HashMap<BlockPos, Integer>();
        for (int i = 0; i < 15; ++i) {
            BlockPos randBP = new BlockPos(this.field_70165_t + this.field_70146_Z.nextGaussian() * 10.0, this.field_70163_u + this.field_70146_Z.nextGaussian() * 10.0, this.field_70161_v + this.field_70146_Z.nextGaussian() * 10.0);
            randBlocks.put(randBP, this.field_70170_p.func_175721_c(randBP, true));
        }
        return randBlocks.entrySet().stream().max(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(new BlockPos((Entity)this));
    }
}

