/*
 * Decompiled with CFR 0.152.
 */
package gatogamer887.meanmobs.init.entity;

import gatogamer887.meanmobs.MeanMobs;
import gatogamer887.meanmobs.init.MeanMobsConfig;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class EntityUtils {
    public static boolean applyGear(EntityLiving entity, String gearFormat) {
        String[] strs = gearFormat.split(",");
        try {
            if (entity.func_70681_au().nextInt(Integer.parseInt(strs[1])) == 0) {
                if (!strs[0].equals("default")) {
                    entity.func_96094_a(strs[0]);
                }
                entity.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Item.func_111206_d((String)strs[2])));
                entity.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Item.func_111206_d((String)strs[3])));
                entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(Item.func_111206_d((String)strs[4])));
                entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(Item.func_111206_d((String)strs[5])));
                entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Item.func_111206_d((String)strs[6])));
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Item.func_111206_d((String)strs[7])));
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(EntityUtils.getSpeedMod(entity.func_70681_au(), Double.parseDouble(strs[8])));
                entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(EntityUtils.getFollowRangeMod(entity.func_70681_au(), Double.parseDouble(strs[9])));
                entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(EntityUtils.getHealthMod(entity.func_70681_au(), Double.parseDouble(strs[10])));
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            MeanMobs.logger.warn("The gear format " + gearFormat + " is invalid");
        }
        return false;
    }

    public static AttributeModifier getSpeedMod(Random rand, double modifier, double base) {
        return new AttributeModifier("speedMod", base + rand.nextDouble() * MeanMobsConfig.mobBuffs.maxSpeedBoost * modifier, 0);
    }

    public static AttributeModifier getSpeedMod(Random rand, double modifier) {
        return EntityUtils.getSpeedMod(rand, modifier, 0.0);
    }

    public static AttributeModifier getSpeedMod(Random rand) {
        return EntityUtils.getSpeedMod(rand, 1.0);
    }

    public static AttributeModifier getFollowRangeMod(Random rand, double modifier, double base) {
        return new AttributeModifier("followRangeMod", base + rand.nextDouble() * MeanMobsConfig.mobBuffs.maxFollowRangeBoost * modifier, 0);
    }

    public static AttributeModifier getFollowRangeMod(Random rand, double modifier) {
        return EntityUtils.getFollowRangeMod(rand, modifier, 0.0);
    }

    public static AttributeModifier getFollowRangeMod(Random rand) {
        return EntityUtils.getFollowRangeMod(rand, 1.0);
    }

    public static AttributeModifier getHealthMod(Random rand, double modifier, double base) {
        return new AttributeModifier("healthMod", base + rand.nextDouble() * MeanMobsConfig.mobBuffs.maxHealthBoost * modifier, 0);
    }

    public static AttributeModifier getHealthMod(Random rand, double modifier) {
        return EntityUtils.getHealthMod(rand, modifier, 0.0);
    }

    public static AttributeModifier getHealthMod(Random rand) {
        return EntityUtils.getHealthMod(rand, 1.0);
    }

    public static void summonMob(EntityLiving summoner, int chance, String[] helpers, LivingEvent event) {
        EntityLiving newMob = null;
        boolean otherSummoned = false;
        for (String str : helpers) {
            String[] strs = str.split(",");
            String id = strs[0];
            double chance1 = Double.parseDouble(strs[1]);
            if (!(summoner.func_70681_au().nextDouble() < chance1)) continue;
            newMob = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(id), (World)summoner.field_70170_p);
            otherSummoned = true;
            break;
        }
        if (!otherSummoned) {
            newMob = (EntityLiving)EntityList.func_188429_b((ResourceLocation)EntityList.func_191301_a((Entity)summoner), (World)summoner.field_70170_p);
        }
        EntityLivingBase entitylivingbase = summoner.func_70638_az();
        EntityLivingBase entitylivingbase1 = summoner.func_70643_av();
        Vec3d location = new Vec3d(summoner.field_70165_t, summoner.field_70163_u + (double)summoner.func_70047_e(), summoner.field_70161_v);
        if (event instanceof LivingHurtEvent) {
            DamageSource source = ((LivingHurtEvent)event).getSource();
            if (entitylivingbase == null && source.func_76346_g() instanceof EntityLivingBase) {
                entitylivingbase = (EntityLivingBase)source.func_76346_g();
            }
        }
        int i = MathHelper.func_76128_c((double)summoner.field_70165_t);
        int j = MathHelper.func_76128_c((double)summoner.field_70163_u);
        int k = MathHelper.func_76128_c((double)summoner.field_70161_v);
        if (summoner.func_70681_au().nextInt(chance) == 0) {
            for (int l = 0; l < 50; ++l) {
                int k1;
                int j1;
                int i1 = i + MathHelper.func_76136_a((Random)summoner.func_70681_au(), (int)7, (int)40) * MathHelper.func_76136_a((Random)summoner.func_70681_au(), (int)-1, (int)1);
                if (!summoner.field_70170_p.func_180495_p(new BlockPos(i1, (j1 = j + MathHelper.func_76136_a((Random)summoner.func_70681_au(), (int)7, (int)40) * MathHelper.func_76136_a((Random)summoner.func_70681_au(), (int)-1, (int)1)) - 1, k1 = k + MathHelper.func_76136_a((Random)summoner.func_70681_au(), (int)7, (int)40) * MathHelper.func_76136_a((Random)summoner.func_70681_au(), (int)-1, (int)1))).isSideSolid((IBlockAccess)summoner.field_70170_p, new BlockPos(i1, j1 - 1, k1), EnumFacing.UP) || summoner.field_70170_p.func_175671_l(new BlockPos(i1, j1, k1)) >= 10) continue;
                newMob.func_70107_b((double)i1, (double)j1, (double)k1);
                Vec3d newMobLocation = new Vec3d(newMob.field_70165_t, newMob.field_70163_u + (double)newMob.func_70047_e(), newMob.field_70161_v);
                Vec3d direction = location.func_178788_d(newMobLocation).func_72432_b();
                direction = direction.func_178788_d(direction.func_178787_e(direction));
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)newMob, (World)summoner.field_70170_p, (float)((float)newMob.field_70165_t), (float)((float)newMob.field_70163_u), (float)((float)newMob.field_70161_v), null);
                if (summoner.field_70170_p.func_175636_b((double)i1, (double)j1, (double)k1, 7.0) || !summoner.field_70170_p.func_72917_a(newMob.func_174813_aQ(), (Entity)newMob) || !summoner.field_70170_p.func_184144_a((Entity)newMob, newMob.func_174813_aQ()).isEmpty() || summoner.field_70170_p.func_72953_d(newMob.func_174813_aQ()) || canSpawn != Event.Result.ALLOW && canSpawn != Event.Result.DEFAULT) continue;
                summoner.field_70170_p.func_72838_d((Entity)newMob);
                if (MeanMobsConfig.debugging.logAssistanceSummoning) {
                    MeanMobs.logger.debug(EntityList.func_191301_a((Entity)summoner) + " summoned an entity of type " + EntityList.func_191301_a((Entity)newMob) + " at " + newMobLocation);
                }
                if (entitylivingbase != null) {
                    newMob.func_70624_b(entitylivingbase);
                }
                if (entitylivingbase1 != null) {
                    newMob.func_70604_c(entitylivingbase1);
                }
                if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)newMob, (World)summoner.field_70170_p, (float)((float)newMob.field_70165_t), (float)((float)newMob.field_70163_u), (float)((float)newMob.field_70161_v), null)) {
                    newMob.func_180482_a(summoner.field_70170_p.func_175649_E(new BlockPos((Entity)newMob)), (IEntityLivingData)null);
                }
                if (!MeanMobsConfig.summoning.summoningEffects) break;
                summoner.func_184185_a(SoundEvents.field_187853_gC, 1.0f, 2.0f);
                newMob.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 0.85f);
                if (MeanMobs.side != Side.CLIENT || Minecraft.func_71410_x().field_71441_e == null || !Minecraft.func_71410_x().field_71441_e.field_72995_K) break;
                double dist = summoner.func_70011_f(newMobLocation.field_72450_a, newMobLocation.field_72448_b, newMobLocation.field_72449_c);
                for (double e1 = 0.0; e1 < dist; e1 += 0.2) {
                    Vec3d dir = direction.func_186678_a(e1);
                    Vec3d pos = location.func_178787_e(dir);
                    Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                }
                for (int e = 0; e < 40; ++e) {
                    double d2 = newMob.func_70681_au().nextGaussian() * 0.02;
                    double d0 = newMob.func_70681_au().nextGaussian() * 0.02;
                    double d1 = newMob.func_70681_au().nextGaussian() * 0.02;
                    Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_LARGE, newMob.field_70165_t + (double)(newMob.func_70681_au().nextFloat() * newMob.field_70130_N * 2.0f) - (double)newMob.field_70130_N, newMob.field_70163_u + (double)(newMob.func_70681_au().nextFloat() * newMob.field_70131_O), newMob.field_70161_v + (double)(newMob.func_70681_au().nextFloat() * newMob.field_70130_N * 2.0f) - (double)newMob.field_70130_N, d2, d0, d1, new int[0]);
                }
                break;
            }
        }
    }

    public static void applyZombieSpawnBuffs(EntityZombie zombie) {
        zombie.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(EntityUtils.getSpeedMod(zombie.func_70681_au()));
        zombie.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(EntityUtils.getFollowRangeMod(zombie.func_70681_au(), 1.0, 15.0));
        zombie.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(EntityUtils.getHealthMod(zombie.func_70681_au()));
        for (String str : MeanMobsConfig.mobBuffs.zombieGearPresets) {
            if (EntityUtils.applyGear((EntityLiving)zombie, str)) break;
        }
    }

    public static void applySkeletonSpawnBuffs(AbstractSkeleton skeleton) {
        skeleton.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(EntityUtils.getSpeedMod(skeleton.func_70681_au()));
        skeleton.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(EntityUtils.getFollowRangeMod(skeleton.func_70681_au(), 1.0, 34.0));
        skeleton.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(EntityUtils.getHealthMod(skeleton.func_70681_au()));
        for (String str : MeanMobsConfig.mobBuffs.skeletonGearPresets) {
            if (EntityUtils.applyGear((EntityLiving)skeleton, str)) break;
        }
    }
}

