/*
 * Decompiled with CFR 0.152.
 */
package gatogamer887.meanmobs.init.eventhandlers;

import com.google.common.collect.Sets;
import gatogamer887.meanmobs.MeanMobs;
import gatogamer887.meanmobs.init.MeanMobsConfig;
import gatogamer887.meanmobs.init.entity.EntityUtils;
import gatogamer887.meanmobs.init.entity.ai.EntityAIAttackDamager;
import gatogamer887.meanmobs.init.entity.ai.EntityAIBreakDoorBetter;
import gatogamer887.meanmobs.init.entity.ai.EntityAIBreakFenceGate;
import gatogamer887.meanmobs.init.entity.ai.EntityAIBreakTorch;
import gatogamer887.meanmobs.init.entity.ai.EntityAIBreakTrapdoor;
import gatogamer887.meanmobs.init.entity.ai.EntityAISwimmingBetter;
import gatogamer887.meanmobs.init.entity.ai.SpiderAISpiderTarget;
import gatogamer887.meanmobs.init.entity.pathfinding.PathNavigateGroundBetter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MeanMobsEntityEditor {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (MeanMobsConfig.apocalypseMode.enabled) {
            boolean disabled = true;
            for (String str : MeanMobsConfig.apocalypseMode.allowedSpawns) {
                if (!EntityList.func_191301_a((Entity)event.getEntity()).toString().equals(str)) continue;
                disabled = false;
                if (!MeanMobsConfig.debugging.logSpawningCancellations) break;
                MeanMobs.logger.debug("Not cancelling spawn of type " + EntityList.func_191301_a((Entity)event.getEntity()) + " because it is in the allowed spawns list");
                break;
            }
            if (event.getEntityLiving().func_70668_bt() != EnumCreatureAttribute.UNDEAD && disabled) {
                event.setResult(Event.Result.DENY);
                if (MeanMobsConfig.debugging.logSpawningCancellations) {
                    MeanMobs.logger.debug("Cancelled spawn of type " + EntityList.func_191301_a((Entity)event.getEntity()));
                }
            } else {
                event.setResult(Event.Result.DEFAULT);
                if (MeanMobsConfig.apocalypseMode.extraSpawns && event.getEntityLiving() instanceof EntityLiving) {
                    int times = event.getEntityLiving().func_70681_au().nextInt(MeanMobsConfig.apocalypseMode.maxSummonTimes + 1);
                    for (int i = 0; i < times; ++i) {
                        IEntityLivingData ientitylivingdata = null;
                        EntityLiving newMob = (EntityLiving)EntityList.func_188429_b((ResourceLocation)EntityList.func_191301_a((Entity)event.getEntity()), (World)event.getWorld());
                        newMob.func_180482_a(event.getWorld().func_175649_E(new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ())), null);
                        float x = event.getX() + (newMob.func_70681_au().nextFloat() - newMob.func_70681_au().nextFloat()) * 5.0f;
                        float y = event.getY();
                        float z = event.getZ() + (newMob.func_70681_au().nextFloat() - newMob.func_70681_au().nextFloat()) * 5.0f;
                        newMob.func_70012_b((double)x, (double)y, (double)z, newMob.func_70681_au().nextFloat() * 360.0f, 0.0f);
                        if (!newMob.func_70601_bi() || !newMob.func_70058_J()) continue;
                        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)newMob, (World)event.getWorld(), (float)x, (float)y, (float)z, null)) {
                            ientitylivingdata = newMob.func_180482_a(event.getWorld().func_175649_E(new BlockPos((Entity)newMob)), ientitylivingdata);
                        }
                        if (newMob.func_70058_J()) {
                            event.getWorld().func_72838_d((Entity)newMob);
                            continue;
                        }
                        newMob.func_70106_y();
                    }
                    MeanMobs.logger.debug("Spawned extra mobs of " + EntityList.func_191301_a((Entity)event.getEntity()) + " " + times + " times");
                }
            }
        }
    }

    @SubscribeEvent
    public static void onZombieJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityZombie && !(event.getEntity() instanceof EntityPigZombie) || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.zombieEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            EntityZombie zombie = (EntityZombie)event.getEntity();
            try {
                Field navigatorField = EntityLiving.class.getDeclaredField("navigator");
                navigatorField.setAccessible(true);
                navigatorField.set(zombie, (Object)new PathNavigateGroundBetter((EntityLiving)zombie, zombie.func_130014_f_()));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                MeanMobs.logger.error("Problem editing navigator: " + e);
            }
            zombie.func_146070_a(false);
            zombie.func_98053_h(MeanMobsConfig.mobBuffs.lootSystemMode > 0);
            ((PathNavigateGround)zombie.func_70661_as()).func_179688_b(true);
            ((PathNavigateGround)zombie.func_70661_as()).func_179691_c(true);
            LinkedHashSet taskEntries = Sets.newLinkedHashSet();
            taskEntries.addAll(zombie.field_70714_bg.field_75782_a);
            for (EntityAITasks.EntityAITaskEntry task : zombie.field_70714_bg.field_75782_a) {
                if (!(task.field_75733_a instanceof EntityAISwimming)) continue;
                taskEntries.remove(task);
            }
            zombie.field_70714_bg.field_75782_a.clear();
            zombie.field_70714_bg.field_75782_a.addAll(taskEntries);
            zombie.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimmingBetter((EntityLiving)zombie));
            zombie.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoorBetter((EntityLiving)zombie));
            zombie.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakTrapdoor((EntityLiving)zombie));
            zombie.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakFenceGate((EntityLiving)zombie));
            zombie.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIBreakTorch((EntityCreature)zombie, 1.1, 60));
            if (!(zombie instanceof EntityHusk) && !zombie.func_70631_g_()) {
                zombie.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)zombie));
                zombie.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFleeSun((EntityCreature)zombie, 1.0));
            }
            zombie.field_70715_bh.func_85156_a((EntityAIBase)new EntityAIHurtByTarget((EntityCreature)zombie, true, new Class[]{EntityPigZombie.class}));
            zombie.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIAttackDamager((EntityCreature)zombie, true, new Class[]{EntityPigZombie.class}, AbstractSkeleton.class));
            zombie.field_70715_bh.func_85156_a((EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)zombie, EntityPlayer.class, true));
            zombie.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)zombie, EntityPlayer.class, !MeanMobsConfig.mobBuffs.mobsSeeThroughWalls));
        }
    }

    @SubscribeEvent
    public static void onZombieSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntity() instanceof EntityZombie && !(event.getEntity() instanceof EntityPigZombie) || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.zombieEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            EntityZombie zombie = (EntityZombie)event.getEntity();
            EntityUtils.applyZombieSpawnBuffs(zombie);
        }
    }

    @SubscribeEvent
    public static void onZombieSpawn(LivingPackSizeEvent event) {
        if (event.getEntity() instanceof EntityZombie && !(event.getEntity() instanceof EntityPigZombie) || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.zombieEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            EntityZombie zombie = (EntityZombie)event.getEntity();
            EntityUtils.applyZombieSpawnBuffs(zombie);
        }
    }

    @SubscribeEvent
    public static void onSkeletonJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AbstractSkeleton || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.skeletonEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            AbstractSkeleton skeleton = (AbstractSkeleton)event.getEntity();
            try {
                Field navigatorField = EntityLiving.class.getDeclaredField("navigator");
                navigatorField.setAccessible(true);
                navigatorField.set(skeleton, (Object)new PathNavigateGroundBetter((EntityLiving)skeleton, skeleton.func_130014_f_()));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                MeanMobs.logger.error("Problem editing navigator: " + e);
            }
            skeleton.func_98053_h(MeanMobsConfig.mobBuffs.lootSystemMode > 0);
            ((PathNavigateGround)skeleton.func_70661_as()).func_179688_b(true);
            ((PathNavigateGround)skeleton.func_70661_as()).func_179691_c(true);
            LinkedHashSet taskEntries = Sets.newLinkedHashSet();
            taskEntries.addAll(skeleton.field_70714_bg.field_75782_a);
            for (EntityAITasks.EntityAITaskEntry task : skeleton.field_70714_bg.field_75782_a) {
                if (!(task.field_75733_a instanceof EntityAISwimming)) continue;
                taskEntries.remove(task);
            }
            skeleton.field_70714_bg.field_75782_a.clear();
            skeleton.field_70714_bg.field_75782_a.addAll(taskEntries);
            skeleton.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimmingBetter((EntityLiving)skeleton));
            skeleton.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoorBetter((EntityLiving)skeleton));
            skeleton.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakTrapdoor((EntityLiving)skeleton));
            skeleton.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakFenceGate((EntityLiving)skeleton));
            skeleton.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIBreakTorch((EntityCreature)skeleton, 1.1, 60));
            skeleton.field_70715_bh.func_85156_a((EntityAIBase)new EntityAIHurtByTarget((EntityCreature)skeleton, false, new Class[0]));
            skeleton.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIAttackDamager((EntityCreature)skeleton, true, new Class[0], EntityZombie.class));
            skeleton.field_70715_bh.func_85156_a((EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)skeleton, EntityPlayer.class, true));
            skeleton.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)skeleton, EntityPlayer.class, !MeanMobsConfig.mobBuffs.mobsSeeThroughWalls));
            skeleton.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)skeleton, EntityVillager.class, !MeanMobsConfig.mobBuffs.mobsSeeThroughWalls));
        }
    }

    @SubscribeEvent
    public static void onSkeletonSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntity().func_70089_S() && event.getEntity() instanceof AbstractSkeleton || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.skeletonEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            AbstractSkeleton skeleton = (AbstractSkeleton)event.getEntity();
            EntityUtils.applySkeletonSpawnBuffs(skeleton);
        }
    }

    @SubscribeEvent
    public static void onSkeletonSpawn(LivingPackSizeEvent event) {
        if (event.getEntity().func_70089_S() && event.getEntity() instanceof AbstractSkeleton || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.skeletonEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            AbstractSkeleton skeleton = (AbstractSkeleton)event.getEntity();
            EntityUtils.applySkeletonSpawnBuffs(skeleton);
        }
    }

    @SubscribeEvent
    public static void onSpiderJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntitySpider || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.spiderEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            EntitySpider spider = (EntitySpider)event.getEntity();
            spider.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFleeSun((EntityCreature)spider, 1.0));
            spider.field_70715_bh.func_75776_a(3, new SpiderAISpiderTarget<EntityVillager>(spider, EntityVillager.class));
            spider.field_70715_bh.func_75776_a(3, new SpiderAISpiderTarget<EntityWitch>(spider, EntityWitch.class));
        }
    }

    @SubscribeEvent
    public static void onSpiderSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntity() instanceof EntitySpider || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.spiderEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            EntitySpider spider = (EntitySpider)event.getEntity();
            spider.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(EntityUtils.getSpeedMod(spider.func_70681_au()));
            spider.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(EntityUtils.getFollowRangeMod(spider.func_70681_au(), 1.0, 19.0));
        }
    }

    @SubscribeEvent
    public static void onBlazeSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntity() instanceof EntityBlaze || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.blazeEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            EntityBlaze blaze = (EntityBlaze)event.getEntity();
            blaze.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(EntityUtils.getSpeedMod(blaze.func_70681_au()));
            blaze.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(EntityUtils.getFollowRangeMod(blaze.func_70681_au(), 2.0));
        }
    }

    @SubscribeEvent
    public static void onZombieHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityZombie || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.zombieEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            EntityZombie zombie = (EntityZombie)event.getEntity();
            EntityUtils.summonMob((EntityLiving)zombie, MeanMobsConfig.summoning.zombieSummonChance, MeanMobsConfig.summoning.zombieHelpers, (LivingEvent)event);
        }
    }

    @SubscribeEvent
    public static void onSkeletonHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof AbstractSkeleton || EntityList.func_191301_a((Entity)event.getEntity()) != null && Arrays.asList(MeanMobsConfig.skeletonEntities).contains(EntityList.func_191301_a((Entity)event.getEntity()).toString())) {
            AbstractSkeleton skeleton = (AbstractSkeleton)event.getEntity();
            EntityUtils.summonMob((EntityLiving)skeleton, MeanMobsConfig.summoning.skeletonSummonChance, MeanMobsConfig.summoning.skeletonHelpers, (LivingEvent)event);
        }
    }
}

