/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_teleportation.client.TeleportationManagerClient;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ImagesLoaderClient {
    private final TeleportationManagerClient manager;

    protected ImagesLoaderClient(TeleportationManagerClient manager) {
        this.manager = manager;
    }

    public void loadCampPreviewImagesAsync() {
        OxygenHelperClient.addIOTask(this::loadCampPreviewImages);
    }

    public void loadCampPreviewImages() {
        String folder = OxygenHelperClient.getDataFolder() + "/client/players/" + OxygenHelperClient.getPlayerUUID() + "/teleportation/images/camps";
        String[] files = new File(folder).list((file, name) -> name.endsWith(".png"));
        if (files != null) {
            for (String fileName : files) {
                File file2 = new File(folder + "/" + fileName);
                try {
                    BufferedImage bufferedImage = ImageIO.read(file2);
                    try {
                        Validate.validState((bufferedImage.getWidth() == TeleportationConfig.IMAGE_WIDTH.asInt() ? 1 : 0) != 0);
                        Validate.validState((bufferedImage.getHeight() == TeleportationConfig.IMAGE_HEIGHT.asInt() ? 1 : 0) != 0);
                    }
                    catch (IllegalStateException exception) {
                        OxygenMain.LOGGER.error("[Teleportation] Invalid camp preview image {}.", (Object)fileName);
                        return;
                    }
                    this.manager.getImagesManager().getPreviewImages().put(Long.parseLong(StringUtils.remove((String)fileName, (String)".png")), bufferedImage);
                }
                catch (IOException exception) {
                    OxygenMain.LOGGER.error("[Teleportation] Failed to load camp preview image {}.", (Object)fileName);
                    exception.printStackTrace();
                }
            }
            OxygenMain.LOGGER.info("[Teleportation] Loaded camps preview images.");
        }
    }

    public void saveLatestCampPreviewImageAsync(long pointId) {
        OxygenHelperClient.addIOTask(() -> this.saveCampPreviewImage(pointId, this.manager.getImagesManager().getLatestImage()));
    }

    public void saveCampPreviewImageAsync(long pointId, BufferedImage image) {
        OxygenHelperClient.addIOTask(() -> this.saveCampPreviewImage(pointId, image));
    }

    public void saveCampPreviewImage(long pointId, BufferedImage image) {
        String folder = OxygenHelperClient.getDataFolder() + "/client/players/" + OxygenHelperClient.getPlayerUUID() + "/teleportation/images/camps/" + pointId + ".png";
        Path path = Paths.get(folder, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "png", path.toFile());
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("[Teleportation] Failed to save camp preview image {}.png.", (Object)pointId);
            exception.printStackTrace();
        }
    }

    public void removeUnusedCampPreviewImagesAsync() {
        OxygenHelperClient.addIOTask(this::removeUnusedCampPreviewImages);
    }

    public void removeUnusedCampPreviewImages() {
        String folder = OxygenHelperClient.getDataFolder() + "/client/players/" + OxygenHelperClient.getPlayerUUID() + "/teleportation/images/camps";
        String[] files = new File(folder).list((file, name) -> name.endsWith(".png"));
        if (files != null) {
            for (String fileName : files) {
                Path path = Paths.get(folder + "/" + fileName, new String[0]);
                if (this.manager.getPlayerData().isCampExist(Long.parseLong(StringUtils.remove((String)fileName, (String)".png")))) continue;
                try {
                    Files.delete(path);
                }
                catch (IOException exception) {
                    OxygenMain.LOGGER.error("[Teleportation] Failed to remove camp preview image {}.", (Object)fileName);
                    exception.printStackTrace();
                }
            }
            OxygenMain.LOGGER.info("[Teleportation] Removed unused camps preview images.");
        }
    }

    public void removeCampPreviewImage(long pointId) {
        String folder = OxygenHelperClient.getDataFolder() + "/client/players/" + OxygenHelperClient.getPlayerUUID() + "/teleportation/images/camps/" + pointId + ".png";
        Path path = Paths.get(folder, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Teleportation] Failed to remove camp preview image {}.png.", (Object)pointId);
                exception.printStackTrace();
            }
        }
    }

    public void renameCampPreviewImageAsync(long oldPointId, long newPointId) {
        OxygenHelperClient.addIOTask(() -> this.renameCampPreviewImage(oldPointId, newPointId));
    }

    public void renameCampPreviewImage(long oldPointId, long newPointId) {
        String folder = OxygenHelperClient.getDataFolder() + "/client/players/" + OxygenHelperClient.getPlayerUUID() + "/teleportation/images/camps/" + oldPointId + ".png";
        Path path = Paths.get(folder, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.move(path, path.resolveSibling(newPointId + ".png"), new CopyOption[0]);
                OxygenMain.LOGGER.info("[Teleportation] Renamed camp preview image {}.png to {}.png", (Object)oldPointId, (Object)newPointId);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Teleportation] Failed to rename camp preview image {}.png.", (Object)oldPointId);
                exception.printStackTrace();
            }
        }
    }

    public void loadLocationPreviewImagesAsync() {
        OxygenHelperClient.addIOTask(this::loadLocationPreviewImages);
    }

    public void loadLocationPreviewImages() {
        String folder = OxygenHelperClient.getDataFolder() + "/client/world/teleportation/locations/images";
        String[] files = new File(folder).list((file, name) -> name.endsWith(".png"));
        if (files != null) {
            for (String fileName : files) {
                File file2 = new File(folder + "/" + fileName);
                try {
                    BufferedImage bufferedImage = ImageIO.read(file2);
                    try {
                        Validate.validState((bufferedImage.getWidth() == TeleportationConfig.IMAGE_WIDTH.asInt() ? 1 : 0) != 0);
                        Validate.validState((bufferedImage.getHeight() == TeleportationConfig.IMAGE_HEIGHT.asInt() ? 1 : 0) != 0);
                    }
                    catch (IllegalStateException exception) {
                        OxygenMain.LOGGER.error("[Teleportation] Invalid location preview image: {}.", (Object)fileName);
                        return;
                    }
                    this.manager.getImagesManager().getPreviewImages().put(Long.parseLong(StringUtils.remove((String)fileName, (String)".png")), bufferedImage);
                }
                catch (IOException exception) {
                    OxygenMain.LOGGER.error("[Teleportation] Failed to load location preview image: {}.", (Object)fileName);
                    exception.printStackTrace();
                }
            }
            OxygenMain.LOGGER.info("[Teleportation] Loaded locations preview images.");
        }
    }

    public void saveLatestLocationPreviewImageAsync(long pointId) {
        OxygenHelperClient.addIOTask(() -> this.saveLocationPreviewImage(pointId, this.manager.getImagesManager().getLatestImage()));
    }

    public void saveLocationPreviewImageAsync(long pointId, BufferedImage image) {
        OxygenHelperClient.addIOTask(() -> this.saveLocationPreviewImage(pointId, image));
    }

    public void saveLocationPreviewImage(long pointId, BufferedImage image) {
        String folder = OxygenHelperClient.getDataFolder() + "/client/world/teleportation/locations/images/" + pointId + ".png";
        Path path = Paths.get(folder, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "png", path.toFile());
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("[Teleportation] Failed to save location preview image: {}.png", (Object)pointId);
            exception.printStackTrace();
        }
    }

    public void removeUnusedLocationPreviewImagesAsync() {
        OxygenHelperClient.addIOTask(() -> this.removeUnusedLocationPreviewImages());
    }

    public void removeUnusedLocationPreviewImages() {
        String folder = OxygenHelperClient.getDataFolder() + "/client/world/teleportation/locations/images";
        String[] files = new File(folder).list((file, name) -> name.endsWith(".png"));
        if (files != null) {
            for (String fileName : files) {
                Path path = Paths.get(folder + "/" + fileName, new String[0]);
                if (this.manager.getLocationsContainer().locationExist(Long.parseLong(StringUtils.remove((String)fileName, (String)".png")))) continue;
                try {
                    Files.delete(path);
                }
                catch (IOException exception) {
                    OxygenMain.LOGGER.error("[Teleportation] Failed to remove location preview image {}.", (Object)fileName);
                    exception.printStackTrace();
                }
            }
            OxygenMain.LOGGER.info("[Teleportation] Removed unused locations preview images.");
        }
    }

    public void removeLocationPreviewImageAsync(long pointId) {
        OxygenHelperClient.addIOTask(() -> this.removeLocationPreviewImage(pointId));
    }

    public void removeLocationPreviewImage(long pointId) {
        String folder = OxygenHelperClient.getDataFolder() + "/client/world/teleportation/locations/images/" + pointId + ".png";
        Path path = Paths.get(folder, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Teleportation] Failed to remove location preview image {}.png.", (Object)pointId);
                exception.printStackTrace();
            }
        }
    }

    public void renameLocationPreviewImageAsync(long oldPointId, long newPointId) {
        OxygenHelperClient.addIOTask(() -> this.renameLocationPreviewImage(oldPointId, newPointId));
    }

    public void renameLocationPreviewImage(long oldPointId, long newPointId) {
        String folder = OxygenHelperClient.getDataFolder() + "/client/world/teleportation/locations/images/" + oldPointId + ".png";
        Path path = Paths.get(folder, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.move(path, path.resolveSibling(newPointId + ".png"), new CopyOption[0]);
                OxygenMain.LOGGER.info("[Teleportation] Renamed location preview image {}.png to {}.png", (Object)oldPointId, (Object)newPointId);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Teleportation] Failed to rename location preview image {}.png.", (Object)oldPointId);
                exception.printStackTrace();
            }
        }
    }
}

