/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.util.ScreenshotHelper;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_teleportation.client.TeleportationManagerClient;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.network.server.SPStartImageUpload;
import austeretony.oxygen_teleportation.common.network.server.SPUploadImagePart;
import austeretony.oxygen_teleportation.common.util.ImageTransferingServerBuffer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;

public class ImagesManagerClient {
    private final TeleportationManagerClient manager;
    private final Map<Long, BufferedImage> images = new ConcurrentHashMap<Long, BufferedImage>();
    private BufferedImage latestImage;

    protected ImagesManagerClient(TeleportationManagerClient manager) {
        this.manager = manager;
    }

    public void preparePreviewImage() {
        this.latestImage = ScreenshotHelper.createScreenshot((int)TeleportationConfig.IMAGE_WIDTH.asInt(), (int)TeleportationConfig.IMAGE_HEIGHT.asInt());
    }

    @Nullable
    public BufferedImage getLatestImage() {
        return this.latestImage;
    }

    public Map<Long, BufferedImage> getPreviewImages() {
        return this.images;
    }

    public void cacheImage(long pointId, BufferedImage image) {
        this.images.put(pointId, image);
    }

    public void cacheLatestImage(long pointId) {
        this.images.put(pointId, this.getLatestImage());
    }

    public void removeCachedImage(long pointId) {
        this.images.remove(pointId);
    }

    public void replaceCachedImage(long oldPointId, long newPointId) {
        if (this.images.containsKey(oldPointId)) {
            this.images.put(newPointId, this.images.get(oldPointId));
            this.images.remove(oldPointId);
        }
    }

    public void uploadCampPreviewToServerAsync(long pointId) {
        OxygenHelperClient.addIOTask(() -> this.uploadCampPreviewToServer(pointId));
    }

    public void uploadCampPreviewToServer(long pointId) {
        byte[] imageRaw = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.getLatestImage(), "png", baos);
            imageRaw = baos.toByteArray();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        if (imageRaw != null) {
            List<byte[]> fragments = ImagesManagerClient.divideArray(imageRaw, 16383);
            OxygenMain.network().sendToServer((Packet)new SPStartImageUpload(ImageTransferingServerBuffer.EnumImageTransfer.UPLOAD_CAMP, pointId, fragments.size()));
            int index = 0;
            for (byte[] part : fragments) {
                OxygenMain.network().sendToServer((Packet)new SPUploadImagePart(ImageTransferingServerBuffer.EnumImageTransfer.UPLOAD_CAMP, pointId, index, part, fragments.size()));
                ++index;
            }
        }
    }

    public static List<byte[]> divideArray(byte[] array, int size) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int start = 0; start < array.length; start += size) {
            int end = Math.min(array.length, start + size);
            result.add(Arrays.copyOfRange(array, start, end));
        }
        return result;
    }

    public void uploadLocationPreviewToServerAsync(long pointId) {
        OxygenHelperClient.addIOTask(() -> this.uploadLocationPreviewToServer(pointId));
    }

    public void uploadLocationPreviewToServer(long pointId) {
        byte[] imageRaw = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.getLatestImage(), "png", baos);
            imageRaw = baos.toByteArray();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        if (imageRaw != null) {
            List<byte[]> fragments = ImagesManagerClient.divideArray(imageRaw, 16383);
            OxygenMain.network().sendToServer((Packet)new SPStartImageUpload(ImageTransferingServerBuffer.EnumImageTransfer.UPLOAD_LOCATION, pointId, fragments.size()));
            int index = 0;
            for (byte[] part : fragments) {
                OxygenMain.network().sendToServer((Packet)new SPUploadImagePart(ImageTransferingServerBuffer.EnumImageTransfer.UPLOAD_LOCATION, pointId, index, part, fragments.size()));
                ++index;
            }
        }
    }

    public void processDownloadedPreviewImage(WorldPoint.EnumWorldPoint type, long pointId, byte[] imageRaw) {
        ByteArrayInputStream baos = new ByteArrayInputStream(imageRaw);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(baos);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        if (bufferedImage != null) {
            if (type == WorldPoint.EnumWorldPoint.CAMP) {
                TeleportationManagerClient.instance().getImagesLoader().saveCampPreviewImageAsync(pointId, bufferedImage);
            } else {
                TeleportationManagerClient.instance().getImagesLoader().saveLocationPreviewImageAsync(pointId, bufferedImage);
            }
            TeleportationManagerClient.instance().getImagesManager().cacheImage(pointId, bufferedImage);
            OxygenMain.LOGGER.info("[Teleportation] Image {}.png saved.", (Object)pointId);
        } else {
            OxygenMain.LOGGER.info("[Teleportation] Failed to create and save image {}.png.", (Object)pointId);
        }
    }
}

