/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_teleportation.common.WorldPoint;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LocationsContainerClient
extends AbstractPersistentData {
    private final Map<Long, WorldPoint> locations = new ConcurrentHashMap<Long, WorldPoint>();

    protected LocationsContainerClient() {
    }

    public Collection<WorldPoint> getLocations() {
        return this.locations.values();
    }

    public int getLocationsAmount() {
        return this.locations.size();
    }

    public boolean isLocationsExist() {
        return !this.locations.isEmpty();
    }

    public Set<Long> getLocationIds() {
        return this.locations.keySet();
    }

    public boolean locationExist(long pointId) {
        return this.locations.containsKey(pointId);
    }

    public WorldPoint getLocation(long pointId) {
        return this.locations.get(pointId);
    }

    public void addLocation(WorldPoint worldPoint) {
        this.locations.put(worldPoint.getId(), worldPoint);
    }

    public void removeLocation(long pointId) {
        this.locations.remove(pointId);
    }

    public String getDisplayName() {
        return "teleportation:locations_client";
    }

    public String getPath() {
        return OxygenHelperClient.getDataFolder() + "/client/world/teleportation/locations.dat";
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((short)((short)this.getLocationsAmount()), (OutputStream)bos);
        for (WorldPoint worldPoint : this.getLocations()) {
            worldPoint.write(bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        int size = StreamUtils.readShort((InputStream)bis);
        for (int i = 0; i < size; ++i) {
            this.addLocation(WorldPoint.read(bis));
        }
    }

    public void reset() {
        this.locations.clear();
    }
}

