/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.ConcurrentSetWrapper;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_teleportation.client.InvitationsContainerClient;
import austeretony.oxygen_teleportation.client.TeleportationManagerClient;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class SharedCampsManagerContainer
extends AbstractPersistentData {
    private final TeleportationManagerClient manager;
    private final InvitationsContainerClient invitations = new InvitationsContainerClient();

    protected SharedCampsManagerContainer(TeleportationManagerClient manager) {
        this.manager = manager;
    }

    public InvitationsContainerClient getInvitationsContainer() {
        return this.invitations;
    }

    public boolean invitedPlayersExist(long pointId) {
        return this.invitations.invitedPlayers.containsKey(pointId) && !this.invitations.invitedPlayers.get(pointId).isEmpty();
    }

    public int getInvitedPlayersAmountForCamp(long pointId) {
        if (!this.invitations.invitedPlayers.containsKey(pointId)) {
            return 0;
        }
        return this.invitations.invitedPlayers.get(pointId).size();
    }

    public Set<UUID> getInvitedPlayers(long pointId) {
        return this.invitations.invitedPlayers.get((Object)Long.valueOf((long)pointId)).set;
    }

    public void uninvite(long pointId, UUID invitedUUID) {
        this.invitations.invitedPlayers.get(pointId).remove((Object)invitedUUID);
    }

    public void invitationsDataReceived(ByteBuf buffer) {
        try {
            this.reset();
            this.getInvitationsContainer().read(buffer);
            this.setChanged(true);
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    public String getDisplayName() {
        return "teleportation:shared_camps_client";
    }

    public String getPath() {
        return OxygenHelperClient.getDataFolder() + "/client/players/" + OxygenHelperClient.getPlayerUUID() + "/teleportation/invitations.dat";
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((long)this.invitations.getId(), (OutputStream)bos);
        StreamUtils.write((short)((short)this.invitations.invitedPlayers.size()), (OutputStream)bos);
        for (Map.Entry<Long, ConcurrentSetWrapper<UUID>> entry : this.invitations.invitedPlayers.entrySet()) {
            StreamUtils.write((short)((short)entry.getValue().size()), (OutputStream)bos);
            for (UUID playerUUID : entry.getValue().set) {
                StreamUtils.write((UUID)playerUUID, (OutputStream)bos);
            }
            StreamUtils.write((long)entry.getKey(), (OutputStream)bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.invitations.setId(StreamUtils.readLong((InputStream)bis));
        int amountOuter = StreamUtils.readShort((InputStream)bis);
        for (int i = 0; i < amountOuter; ++i) {
            ConcurrentSetWrapper players = new ConcurrentSetWrapper();
            int amountInner = StreamUtils.readShort((InputStream)bis);
            for (int j = 0; j < amountInner; ++j) {
                players.add((Object)StreamUtils.readUUID((InputStream)bis));
            }
            this.invitations.invitedPlayers.put(StreamUtils.readLong((InputStream)bis), (ConcurrentSetWrapper<UUID>)players);
        }
    }

    public void reset() {
        this.invitations.invitedPlayers.clear();
        this.invitations.setId(0L);
    }
}

