/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client.gui.teleportation;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.text.GUITextField;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenGUIHelper;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.api.PrivilegesProviderClient;
import austeretony.oxygen_core.client.gui.elements.OxygenActivityStatusSwitcher;
import austeretony.oxygen_core.client.gui.elements.OxygenCurrencyValue;
import austeretony.oxygen_core.client.gui.elements.OxygenDefaultBackgroundWithButtonsFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenDropDownList;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenScrollablePanel;
import austeretony.oxygen_core.client.gui.elements.OxygenSectionSwitcher;
import austeretony.oxygen_core.client.gui.elements.OxygenSorter;
import austeretony.oxygen_core.client.gui.elements.OxygenTextField;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.common.EnumActivityStatus;
import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.common.main.EnumOxygenPrivilege;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_teleportation.client.TeleportationManagerClient;
import austeretony.oxygen_teleportation.client.gui.teleportation.TeleportationMenuScreen;
import austeretony.oxygen_teleportation.client.gui.teleportation.players.PlayerPanelEntry;
import austeretony.oxygen_teleportation.common.TeleportationPlayerData;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationPrivilege;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.gui.ScaledResolution;

public class PlayersSection
extends AbstractGUISection {
    private final TeleportationMenuScreen screen;
    private OxygenTextLabel playersAmountTextLabel;
    private OxygenTextLabel cooldownTextLabel;
    private OxygenKeyButton moveButton;
    private OxygenSorter statusSorter;
    private OxygenSorter usernameSorter;
    private OxygenScrollablePanel playersPanel;
    private OxygenTextField searchField;
    private OxygenActivityStatusSwitcher activityStatusSwitcher;
    private OxygenDropDownList jumpProfileSwitcher;
    private OxygenCurrencyValue feeValue;
    private OxygenCurrencyValue balanceValue;
    private final int cooldownTime = PrivilegesProviderClient.getAsInt((int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.asInt()) * 1000;
    private PlayerPanelEntry currentEntry;
    private boolean cooldownActive;

    public PlayersSection(TeleportationMenuScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
        this.setDisplayText(ClientReference.localize((String)"oxygen_teleportation.gui.menu.players", (Object[])new Object[0]));
    }

    public void init() {
        this.addElement((GUIBaseElement)new OxygenDefaultBackgroundWithButtonsFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenTextLabel(4, 12, ClientReference.localize((String)"oxygen_teleportation.gui.menu.title", (Object[])new Object[0]), EnumBaseGUISetting.TEXT_TITLE_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.playersAmountTextLabel = new OxygenTextLabel(0, 22, "", EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.05f, EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt());
        this.addElement((GUIBaseElement)this.playersAmountTextLabel);
        this.statusSorter = new OxygenSorter(13, 28, OxygenSorter.EnumSorting.DOWN, ClientReference.localize((String)"oxygen_core.gui.status", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.statusSorter);
        this.statusSorter.setSortingListener(sorting -> {
            this.usernameSorter.reset();
            this.sortPlayers(sorting == OxygenSorter.EnumSorting.DOWN ? 0 : 1);
        });
        this.usernameSorter = new OxygenSorter(19, 28, OxygenSorter.EnumSorting.INACTIVE, ClientReference.localize((String)"oxygen_core.gui.username", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.usernameSorter);
        this.usernameSorter.setSortingListener(sorting -> {
            this.statusSorter.reset();
            this.sortPlayers(sorting == OxygenSorter.EnumSorting.DOWN ? 2 : 3);
        });
        this.playersPanel = new OxygenScrollablePanel((AbstractGUIScreen)this.screen, 6, 36, this.getWidth() - 15, 10, 1, 100, 10, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), true);
        this.addElement((GUIBaseElement)this.playersPanel);
        this.searchField = new OxygenTextField(180, 16, 60, 20, "");
        this.addElement((GUIBaseElement)this.searchField);
        this.playersPanel.initSearchField((GUITextField)this.searchField);
        this.playersPanel.setElementClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (this.currentEntry != clicked) {
                if (this.currentEntry != null) {
                    this.currentEntry.setToggled(false);
                }
                this.currentEntry = clicked;
                clicked.toggle();
                this.showPlayerInfo((Integer)clicked.getWrapped());
            }
        });
        this.activityStatusSwitcher = new OxygenActivityStatusSwitcher(7, 16);
        this.addElement((GUIBaseElement)this.activityStatusSwitcher);
        this.jumpProfileSwitcher = new OxygenDropDownList(80, 16, 75, "");
        this.addElement((GUIBaseElement)this.jumpProfileSwitcher);
        for (TeleportationPlayerData.EnumJumpProfile jumpProfile : TeleportationPlayerData.EnumJumpProfile.values()) {
            this.jumpProfileSwitcher.addElement(new OxygenDropDownList.OxygenDropDownListWrapperEntry((Object)jumpProfile, jumpProfile.localizedName()));
        }
        this.jumpProfileSwitcher.setElementClickListener(element -> TeleportationManagerClient.instance().getPlayerDataManager().changeJumpProfileSynced((TeleportationPlayerData.EnumJumpProfile)((Object)((Object)element.getWrapped()))));
        this.cooldownTextLabel = (OxygenTextLabel)new OxygenTextLabel(0, this.getY() + this.getHeight() + this.screen.guiTop - 2, "", EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.05f, EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()).setVisible(false);
        this.addElement((GUIBaseElement)this.cooldownTextLabel);
        this.moveButton = (OxygenKeyButton)new OxygenKeyButton(0, this.getY() + this.getHeight() + this.screen.guiTop - 8, ClientReference.localize((String)"oxygen_teleportation.gui.menu.button.moveToPlayer", (Object[])new Object[0]), 33, this::move).disable();
        this.addElement((GUIBaseElement)this.moveButton);
        this.feeValue = (OxygenCurrencyValue)new OxygenCurrencyValue(0, this.getY() + this.getHeight() + this.screen.guiTop - 8).disableFull();
        this.addElement((GUIBaseElement)this.feeValue);
        this.balanceValue = (OxygenCurrencyValue)new OxygenCurrencyValue(0, this.getY() + this.getHeight() + this.screen.guiTop - 8).disableFull();
        this.addElement((GUIBaseElement)this.balanceValue);
        if (TeleportationConfig.FEE_MODE.asInt() == 1) {
            this.feeValue.setValue(TeleportationManagerClient.instance().getFeeStackWrapper().getCachedItemStack(), 0);
            this.balanceValue.setValue(TeleportationManagerClient.instance().getFeeStackWrapper().getCachedItemStack(), (int)this.screen.balance);
        } else {
            this.feeValue.setValue(0, 0L);
            this.balanceValue.setValue(0, this.screen.balance);
        }
        this.addElement((GUIBaseElement)new OxygenSectionSwitcher(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getCampsSection(), this.screen.getLocationsSection()}));
    }

    private void calculateButtonsHorizontalPosition() {
        ScaledResolution sr = new ScaledResolution(this.mc);
        this.moveButton.setX((sr.func_78326_a() - (12 + this.textWidth(this.moveButton.getDisplayText(), this.moveButton.getTextScale()))) / 2 - this.screen.guiLeft);
        long fee = PrivilegesProviderClient.getAsLong((int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_FEE.id(), (long)TeleportationConfig.TELEPORTATION_TO_PLAYER_FEE.asLong());
        if (fee > 0L) {
            this.cooldownTextLabel.setX(this.moveButton.getX() - 40);
            this.feeValue.setX(this.moveButton.getX() - 10);
            this.balanceValue.setX(sr.func_78326_a() - 10 - this.screen.guiLeft);
        }
    }

    public void sortPlayers(int mode) {
        List players = OxygenHelperClient.getPlayersSharedData().stream().filter(s -> OxygenHelperClient.isPlayerOnline((UUID)s.getPlayerUUID()) && PrivilegesProviderClient.getAsBoolean((int)EnumOxygenPrivilege.EXPOSE_OFFLINE_PLAYERS.id(), (OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s) != EnumActivityStatus.OFFLINE ? 1 : 0) != 0) && (PlayersSection.getJumpProfile(s) != TeleportationPlayerData.EnumJumpProfile.DISABLED || PrivilegesProviderClient.getAsBoolean((int)EnumTeleportationPrivilege.ENABLE_TELEPORTATION_TO_ANY_PLAYER.id(), (boolean)false))).collect(Collectors.toList());
        players.remove(OxygenHelperClient.getPlayerSharedData());
        if (mode == 0) {
            Collections.sort(players, (s1, s2) -> OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s1).ordinal() - OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s2).ordinal());
        } else if (mode == 1) {
            Collections.sort(players, (s1, s2) -> OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s2).ordinal() - OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s1).ordinal());
        } else if (mode == 2) {
            Collections.sort(players, (s1, s2) -> s1.getUsername().compareTo(s2.getUsername()));
        } else if (mode == 3) {
            Collections.sort(players, (s1, s2) -> s2.getUsername().compareTo(s1.getUsername()));
        }
        this.playersPanel.reset();
        for (PlayerSharedData sharedData : players) {
            this.playersPanel.addEntry((GUIButton)new PlayerPanelEntry(sharedData));
        }
        this.playersAmountTextLabel.setDisplayText(String.format("%d/%d", players.size(), OxygenHelperClient.getMaxPlayers()));
        this.playersAmountTextLabel.setX(327 - this.textWidth(this.playersAmountTextLabel.getDisplayText(), this.playersAmountTextLabel.getTextScale()));
        this.searchField.reset();
        this.playersPanel.getScroller().reset();
        this.playersPanel.getScroller().updateRowsAmount(MathUtils.clamp((int)players.size(), (int)10, (int)MathUtils.greaterOfTwo((int)players.size(), (int)OxygenHelperClient.getMaxPlayers())));
    }

    public static TeleportationPlayerData.EnumJumpProfile getJumpProfile(PlayerSharedData sharedData) {
        return TeleportationPlayerData.EnumJumpProfile.values()[sharedData.getByte(5)];
    }

    private void move() {
        if (!this.searchField.isDragged()) {
            TeleportationManagerClient.instance().getPlayerDataManager().moveToPlayerSynced((Integer)this.currentEntry.getWrapped());
            this.screen.close();
        }
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0 && element == this.moveButton) {
            this.move();
        }
    }

    public void sharedDataSynchronized() {
        this.activityStatusSwitcher.updateActivityStatus();
        this.jumpProfileSwitcher.setDisplayText(PlayersSection.getJumpProfile(OxygenHelperClient.getPlayerSharedData()).localizedName());
        this.sortPlayers(0);
        this.calculateButtonsHorizontalPosition();
    }

    public void cooldownSynchronized() {
        this.cooldownActive = this.getCooldownElapsedTimeSeconds() > 0L;
    }

    private void showPlayerInfo(int playerIndex) {
        this.moveButton.setEnabled(this.screen.jumpsEnabled);
        this.cooldownTextLabel.setVisible(this.cooldownActive);
        PlayerSharedData sharedData = OxygenHelperClient.getPlayerSharedData((int)playerIndex);
        this.moveButton.setDisplayText(PlayersSection.getJumpProfile(sharedData) == TeleportationPlayerData.EnumJumpProfile.FREE ? ClientReference.localize((String)"oxygen_teleportation.gui.menu.button.moveToPlayer", (Object[])new Object[0]) : ClientReference.localize((String)"oxygen_teleportation.gui.menu.button.requestTeleportation", (Object[])new Object[0]));
        long fee = PrivilegesProviderClient.getAsLong((int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_FEE.id(), (long)TeleportationConfig.TELEPORTATION_TO_PLAYER_FEE.asLong());
        if (fee > 0L) {
            this.feeValue.updateValue(fee);
            this.feeValue.enableFull();
            this.balanceValue.enableFull();
            if (fee > this.balanceValue.getValue()) {
                this.moveButton.disable();
                this.feeValue.setRed(true);
            }
        }
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (!this.searchField.isDragged() && !this.hasCurrentCallback()) {
            if (OxygenGUIHelper.isOxygenMenuEnabled()) {
                if (keyCode == TeleportationMenuScreen.TELEPORTATIOIN_MENU_ENTRY.getKeyCode()) {
                    this.screen.close();
                }
            } else if (TeleportationConfig.ENABLE_TELEPORTATION_MENU_KEY.asBoolean() && keyCode == TeleportationManagerClient.instance().getKeyHandler().getTeleportationMenuKeybinding().func_151463_i()) {
                this.screen.close();
            }
        }
        return super.keyTyped(typedChar, keyCode);
    }

    public void update() {
        if (this.cooldownActive) {
            if (this.getCooldownElapsedTimeSeconds() > 0L) {
                this.cooldownTextLabel.setDisplayText("[" + String.valueOf(this.getCooldownElapsedTimeSeconds()) + "]");
            } else if (this.cooldownActive) {
                this.cooldownActive = false;
                this.cooldownTextLabel.setVisible(false);
            }
        }
    }

    private long getCooldownElapsedTimeSeconds() {
        return (TeleportationManagerClient.instance().getPlayerData().getCooldownData().getNextJumpTime() - System.currentTimeMillis()) / 1000L;
    }

    public boolean isCooldownActive() {
        return this.cooldownActive;
    }
}

