/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client.gui.teleportation;

import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.core.GUIWorkspace;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.InventoryProviderClient;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.api.PrivilegesProviderClient;
import austeretony.oxygen_core.client.api.WatcherHelperClient;
import austeretony.oxygen_core.client.gui.menu.OxygenMenuEntry;
import austeretony.oxygen_teleportation.client.TeleportationManagerClient;
import austeretony.oxygen_teleportation.client.gui.menu.TeleportationMenuEntry;
import austeretony.oxygen_teleportation.client.gui.teleportation.CampsSection;
import austeretony.oxygen_teleportation.client.gui.teleportation.LocationsSection;
import austeretony.oxygen_teleportation.client.gui.teleportation.PlayersSection;
import austeretony.oxygen_teleportation.client.settings.gui.EnumTeleportationGUISetting;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationPrivilege;
import java.util.UUID;

public class TeleportationMenuScreen
extends AbstractGUIScreen {
    public static final OxygenMenuEntry TELEPORTATIOIN_MENU_ENTRY = new TeleportationMenuEntry();
    private CampsSection campsSection;
    private LocationsSection locationsSection;
    private PlayersSection playersSection;
    public final long balance;
    public final boolean campsEnabled;
    public final boolean locationsEnabled;
    public final boolean jumpsEnabled;

    public TeleportationMenuScreen() {
        OxygenHelperClient.syncSharedData((int)10);
        OxygenHelperClient.syncData((int)10);
        OxygenHelperClient.syncData((int)11);
        this.balance = TeleportationConfig.FEE_MODE.asInt() == 1 ? (long)InventoryProviderClient.getPlayerInventory().getEqualItemAmount(ClientReference.getClientPlayer(), TeleportationManagerClient.instance().getFeeStackWrapper()) : WatcherHelperClient.getLong((int)0);
        this.campsEnabled = PrivilegesProviderClient.getAsBoolean((int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean());
        this.locationsEnabled = PrivilegesProviderClient.getAsBoolean((int)EnumTeleportationPrivilege.ALLOW_LOCATIONS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_LOCATIONS.asBoolean());
        this.jumpsEnabled = PrivilegesProviderClient.getAsBoolean((int)EnumTeleportationPrivilege.ALLOW_PLAYER_TELEPORTATION_USAGE.id(), (boolean)TeleportationConfig.ENABLE_PLAYER_TELEPORTATION.asBoolean());
    }

    protected GUIWorkspace initWorkspace() {
        EnumGUIAlignment alignment = EnumGUIAlignment.CENTER;
        switch (EnumTeleportationGUISetting.TELEPORTATION_MENU_ALIGNMENT.get().asInt()) {
            case -1: {
                alignment = EnumGUIAlignment.LEFT;
                break;
            }
            case 0: {
                alignment = EnumGUIAlignment.CENTER;
                break;
            }
            case 1: {
                alignment = EnumGUIAlignment.RIGHT;
                break;
            }
            default: {
                alignment = EnumGUIAlignment.CENTER;
            }
        }
        return new GUIWorkspace((AbstractGUIScreen)this, 333, 152).setAlignment(alignment, 0, 0);
    }

    protected void initSections() {
        this.campsSection = (CampsSection)new CampsSection(this).setEnabled(this.campsEnabled);
        this.getWorkspace().initSection((AbstractGUISection)this.campsSection);
        this.locationsSection = (LocationsSection)new LocationsSection(this).setEnabled(this.locationsEnabled);
        this.getWorkspace().initSection((AbstractGUISection)this.locationsSection);
        this.playersSection = (PlayersSection)new PlayersSection(this).setEnabled(this.jumpsEnabled);
        this.getWorkspace().initSection((AbstractGUISection)this.playersSection);
    }

    protected AbstractGUISection getDefaultSection() {
        if (this.campsEnabled) {
            return this.campsSection;
        }
        if (this.locationsEnabled) {
            return this.locationsSection;
        }
        if (this.jumpsEnabled) {
            return this.playersSection;
        }
        return null;
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element) {
    }

    protected boolean doesGUIPauseGame() {
        return false;
    }

    public void sharedDataSynchronized() {
        this.playersSection.sharedDataSynchronized();
    }

    public void campsSynchronized() {
        this.campsSection.campsSynchronized();
    }

    public void locationsSynchronized() {
        this.locationsSection.locationsSynchronized();
    }

    public void cooldownSynchronized() {
        this.campsSection.cooldownSynchronized();
        this.locationsSection.cooldownSynchronized();
        this.playersSection.cooldownSynchronized();
    }

    public void campCreated(WorldPoint worldPoint) {
        this.campsSection.campCreated(worldPoint);
    }

    public void campEdited(long oldPointId, WorldPoint worldPoint, boolean updateImage) {
        this.campsSection.campEdited(oldPointId, worldPoint, updateImage);
    }

    public void campRemoved(long pointId) {
        this.campsSection.campRemoved(pointId);
    }

    public void favoriteCampSet(long pointId) {
        this.campsSection.favoriteCampSet(pointId);
    }

    public void playerUninvited(long pointId, UUID playerUUID) {
        this.campsSection.playerUninvited(pointId, playerUUID);
    }

    public void locationCreated(WorldPoint worldPoint) {
        this.locationsSection.locationCreated(worldPoint);
    }

    public void locationEdited(long oldPoiintId, WorldPoint worldPoint, boolean updateImage) {
        this.locationsSection.locationEdited(oldPoiintId, worldPoint, updateImage);
    }

    public void locationRemoved(long pointId) {
        this.locationsSection.locationRemoved(pointId);
    }

    public CampsSection getCampsSection() {
        return this.campsSection;
    }

    public LocationsSection getLocationsSection() {
        return this.locationsSection;
    }

    public PlayersSection getPlayersSection() {
        return this.playersSection;
    }
}

