/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client.gui.teleportation.camps;

import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenWrapperPanelEntry;
import austeretony.oxygen_teleportation.client.TeleportationManagerClient;
import austeretony.oxygen_teleportation.common.WorldPoint;
import net.minecraft.client.renderer.GlStateManager;

public class WorldPointPanelEntry
extends OxygenWrapperPanelEntry<Long> {
    private boolean favorite;
    private boolean locked;
    private boolean shared;
    private boolean downloaded;

    public WorldPointPanelEntry(WorldPoint.EnumWorldPoint type, WorldPoint worldPoint) {
        super((Object)worldPoint.getId());
        this.setLocked(worldPoint.isLocked());
        if (type == WorldPoint.EnumWorldPoint.CAMP) {
            this.setFavorite(worldPoint.getId() == TeleportationManagerClient.instance().getPlayerData().getFavoriteCampId());
            this.setDownloaded(!worldPoint.isOwner(OxygenHelperClient.getPlayerUUID()));
            this.setShared(TeleportationManagerClient.instance().getSharedCampsContainer().invitedPlayersExist(worldPoint.getId()));
        }
        this.setDisplayText(worldPoint.getName());
        this.setDynamicBackgroundColor(EnumBaseGUISetting.ELEMENT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
    }

    public void draw(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
        GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = this.getEnabledBackgroundColor();
        int textColor = this.getEnabledTextColor();
        int textY = (this.getHeight() - this.textHeight(this.getTextScale())) / 2 + 1;
        if (!this.isEnabled()) {
            color = this.getDisabledBackgroundColor();
            textColor = this.getDisabledTextColor();
        } else if (this.isHovered() || this.isToggled()) {
            color = this.getHoveredBackgroundColor();
            textColor = this.getHoveredTextColor();
        }
        int third = this.getWidth() / 3;
        OxygenGUIUtils.drawGradientRect((double)0.0, (double)0.0, (double)third, (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.RIGHT);
        WorldPointPanelEntry.drawRect((int)third, (int)0, (int)(this.getWidth() - third), (int)this.getHeight(), (int)color);
        OxygenGUIUtils.drawGradientRect((double)(this.getWidth() - third), (double)0.0, (double)this.getWidth(), (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.LEFT);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)2.0f, (float)textY, (float)0.0f);
        GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
        this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, this.isTextShadowEnabled());
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        int iconX = this.getWidth() - 2;
        if (this.shared) {
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.SHARE_ICONS);
            WorldPointPanelEntry.drawCustomSizedTexturedRect((int)(iconX -= 8), (int)1, (int)0, (int)0, (int)8, (int)8, (int)24, (int)8);
        } else if (this.downloaded) {
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.DOWNLOAD_ICONS);
            WorldPointPanelEntry.drawCustomSizedTexturedRect((int)(iconX -= 8), (int)1, (int)0, (int)0, (int)8, (int)8, (int)24, (int)8);
        }
        if (this.locked) {
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.LOCK_ICONS);
            WorldPointPanelEntry.drawCustomSizedTexturedRect((int)(iconX -= 8), (int)1, (int)0, (int)0, (int)8, (int)8, (int)24, (int)8);
        }
        if (this.favorite) {
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.STAR_ICONS);
            WorldPointPanelEntry.drawCustomSizedTexturedRect((int)(iconX -= 8), (int)1, (int)0, (int)0, (int)8, (int)8, (int)24, (int)8);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void setFavorite(boolean flag) {
        this.favorite = flag;
    }

    public void setShared(boolean flag) {
        this.shared = flag;
    }

    public void setDownloaded(boolean flag) {
        this.downloaded = flag;
    }

    public void setLocked(boolean flag) {
        this.locked = flag;
    }
}

