/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client.gui.teleportation.camps;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.api.TimeHelperClient;
import austeretony.oxygen_teleportation.client.TeleportationManagerClient;
import austeretony.oxygen_teleportation.common.WorldPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class WorldPointPreview
extends GUIAdvancedElement<WorldPointPreview> {
    private String name;
    private String owner;
    private String creationDate;
    private String position;
    private String dimension;
    private boolean hasImage;
    private final Map<Long, ResourceLocation> cache = new HashMap<Long, ResourceLocation>();
    private final List<String> description = new ArrayList<String>(2);

    public WorldPointPreview(int xPosition, int yPosition) {
        this.setPosition(xPosition, yPosition);
        this.setDynamicBackgroundColor(EnumBaseGUISetting.ELEMENT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.setStaticBackgroundColor(EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt());
        this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat());
        this.setTooltipScaleFactor(EnumBaseGUISetting.TEXT_TITLE_SCALE.get().asFloat());
        this.setDebugColor(EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt());
        this.disableFull();
    }

    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            if (this.hasImage) {
                this.mc.func_110434_K().func_110577_a(this.getTexture());
                WorldPointPreview.drawCustomSizedTexturedRect((int)0, (int)0, (int)this.getTextureU(), (int)this.getTextureV(), (int)this.getTextureWidth(), (int)this.getTextureHeight(), (int)this.getImageWidth(), (int)this.getImageHeight());
            } else {
                WorldPointPreview.drawRect((int)0, (int)0, (int)241, (int)135, (int)-13421773);
            }
            WorldPointPreview.drawGradientRect((int)0, (int)0, (int)241, (int)70, (int)0, (int)-939524096);
            GlStateManager.func_179084_k();
            float textScale = this.getTooltipScaleFactor() + 0.2f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)5.0f, (float)6.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.name, 0.0f, 0.0f, this.getEnabledTextColor(), true);
            GlStateManager.func_179121_F();
            textScale = this.getTextScale() - 0.05f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)5.0f, (float)18.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.owner, 0.0f, 0.0f, this.getEnabledTextColor(), true);
            GlStateManager.func_179121_F();
            textScale = this.getTextScale() - 0.02f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)5.0f, (float)28.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.creationDate, 0.0f, 0.0f, this.getEnabledTextColor(), true);
            this.mc.field_71466_p.func_175065_a(this.position, 0.0f, 12.0f, this.getEnabledTextColor(), true);
            this.mc.field_71466_p.func_175065_a(this.dimension, 0.0f, 24.0f, this.getEnabledTextColor(), true);
            GlStateManager.func_179121_F();
            textScale = this.getTextScale() + 0.05f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)15.0f, (float)56.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
            int index = 0;
            for (String line : this.description) {
                this.mc.field_71466_p.func_175065_a(line, 0.0f, ((float)this.mc.field_71466_p.field_78288_b + 2.0f) * (float)index, this.getDebugColor(), true);
                ++index;
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    public void show(WorldPoint worldPoint, boolean reloadImage) {
        ResourceLocation image = this.getPreviewImage(worldPoint.getId(), reloadImage);
        if (image != null) {
            this.setTexture(image, 241, 135);
        }
        this.name = worldPoint.getName();
        this.owner = ClientReference.localize((String)"oxygen_teleportation.gui.menu.info.owner", (Object[])new Object[0]) + " " + worldPoint.getOwnerName();
        this.creationDate = TimeHelperClient.getDateTimeFormatter().format(TimeHelperClient.getZonedDateTime((long)worldPoint.getId()));
        this.position = String.valueOf((int)worldPoint.getXPos()) + ", " + String.valueOf((int)worldPoint.getYPos()) + ", " + String.valueOf((int)worldPoint.getZPos());
        this.dimension = OxygenHelperClient.getDimensionName((int)worldPoint.getDimensionId());
        this.processDescription(worldPoint.getDescription());
        this.setVisible(true);
    }

    private void processDescription(String description) {
        this.description.clear();
        int width = 300;
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int wordStartIndex = 0;
        boolean rechedLimit = false;
        boolean wordProcessing = false;
        char prevSymbol = '0';
        for (char symbol : description.toCharArray()) {
            if ((this.textHeight(this.getTextScale()) + 2) * this.description.size() >= 80) break;
            if (symbol != ' ') {
                wordProcessing = true;
                if (prevSymbol == ' ') {
                    wordStartIndex = index;
                }
            }
            if (symbol == '\n') {
                this.description.add(builder.toString());
                builder.delete(0, builder.length());
                index = 0;
                continue;
            }
            if (this.textWidth(builder.toString() + String.valueOf(symbol), this.getTextScale()) <= width) {
                builder.append(symbol);
            } else {
                if (symbol == '.' || symbol == ',' || symbol == '!' || symbol == '?') {
                    builder.append(symbol);
                }
                if (wordProcessing) {
                    this.description.add(builder.toString().substring(0, wordStartIndex));
                    builder.delete(0, wordStartIndex);
                } else {
                    this.description.add(builder.toString());
                    builder.delete(0, builder.length());
                }
                if (symbol != ' ') {
                    builder.append(symbol);
                }
                index = builder.length() - 1;
            }
            wordProcessing = false;
            prevSymbol = symbol;
            ++index;
        }
        if (builder.length() != 0) {
            this.description.add(builder.toString());
        }
    }

    public void hide() {
        this.setVisible(false);
    }

    private ResourceLocation getPreviewImage(long pointId, boolean reloadImage) {
        this.hasImage = true;
        if (!this.cache.containsKey(pointId) || reloadImage) {
            if (TeleportationManagerClient.instance().getImagesManager().getPreviewImages().get(pointId) != null) {
                ResourceLocation image = this.mc.func_110434_K().func_110578_a(String.valueOf(pointId), new DynamicTexture(TeleportationManagerClient.instance().getImagesManager().getPreviewImages().get(pointId)));
                this.cache.put(pointId, image);
                this.hasImage = true;
                return image;
            }
            this.hasImage = false;
            return null;
        }
        return this.cache.get(pointId);
    }
}

