/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client.gui.teleportation.camps.callback;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackBackgroundFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenScrollablePanel;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_teleportation.client.TeleportationManagerClient;
import austeretony.oxygen_teleportation.client.gui.teleportation.CampsSection;
import austeretony.oxygen_teleportation.client.gui.teleportation.TeleportationMenuScreen;
import austeretony.oxygen_teleportation.client.gui.teleportation.camps.InvitedPlayerPanelEntry;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import java.util.UUID;

public class InvitationsCallback
extends AbstractGUICallback {
    private final TeleportationMenuScreen screen;
    protected final CampsSection section;
    private OxygenScrollablePanel invitedPanel;
    private OxygenKeyButton closeButton;

    public InvitationsCallback(TeleportationMenuScreen screen, CampsSection section, int width, int height) {
        super((AbstractGUIScreen)screen, (AbstractGUISection)section, width, height);
        this.screen = screen;
        this.section = section;
    }

    public void init() {
        this.enableDefaultBackground(EnumBaseGUISetting.FILL_CALLBACK_COLOR.get().asInt());
        this.addElement((GUIBaseElement)new OxygenCallbackBackgroundFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenTextLabel(4, 12, ClientReference.localize((String)"oxygen_teleportation.gui.menu.callback.invitations", (Object[])new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.invitedPanel = new OxygenScrollablePanel((AbstractGUIScreen)this.screen, 6, 15, this.getWidth() - 12, 10, 1, TeleportationConfig.MAX_INVITED_PLAYERS_PER_CAMP.asInt(), 5, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), true);
        this.addElement((GUIBaseElement)this.invitedPanel);
        this.closeButton = new OxygenKeyButton(this.getWidth() - 55, this.getHeight() - 10, ClientReference.localize((String)"oxygen_core.gui.close", (Object[])new Object[0]), 45, () -> ((InvitationsCallback)this).close());
        this.addElement((GUIBaseElement)this.closeButton);
    }

    private void updateInvited() {
        this.invitedPanel.reset();
        for (UUID playerUUID : TeleportationManagerClient.instance().getSharedCampsContainer().getInvitedPlayers(this.section.getCurrentPoint().getId())) {
            this.invitedPanel.addEntry((GUIButton)new InvitedPlayerPanelEntry(OxygenHelperClient.getPlayerSharedData((UUID)playerUUID), this.section.getCurrentPoint().getId()));
        }
        int maxAmount = TeleportationConfig.MAX_INVITED_PLAYERS_PER_CAMP.asInt();
        int amount = TeleportationManagerClient.instance().getSharedCampsContainer().getInvitedPlayers(this.section.getCurrentPoint().getId()).size();
        this.invitedPanel.getScroller().reset();
        this.invitedPanel.getScroller().updateRowsAmount(MathUtils.clamp((int)amount, (int)5, (int)maxAmount));
    }

    protected void onOpen() {
        this.updateInvited();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0 && element == this.closeButton) {
            this.close();
        }
    }

    public void playerUninvited(long pointId, UUID playerUUID) {
        this.updateInvited();
    }
}

