/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.client.gui.teleportation.players;

import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenWrapperPanelEntry;
import austeretony.oxygen_core.client.privilege.RoleData;
import austeretony.oxygen_core.common.EnumActivityStatus;
import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_teleportation.common.TeleportationPlayerData;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;

public class PlayerPanelEntry
extends OxygenWrapperPanelEntry<Integer> {
    private int tooltipBackgroundColor;
    private int tooltipFrameColor;
    private int statusIconU;
    private int rolesAmount;
    private int rolesWidth;
    private String dimensionStr;
    private String jumpProfileStr;
    private String[] roles = new String[5];

    public PlayerPanelEntry(PlayerSharedData sharedData) {
        super((Object)sharedData.getIndex());
        EnumActivityStatus activityStatus = OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)sharedData);
        this.statusIconU = activityStatus.ordinal() * 3;
        this.setDisplayText(sharedData.getUsername());
        this.dimensionStr = OxygenHelperClient.getDimensionName((int)OxygenHelperClient.getPlayerDimension((PlayerSharedData)sharedData));
        this.jumpProfileStr = TeleportationPlayerData.EnumJumpProfile.values()[sharedData.getByte(5)].localizedName();
        this.tooltipBackgroundColor = EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt();
        this.tooltipFrameColor = EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt();
        this.setDynamicBackgroundColor(EnumBaseGUISetting.ELEMENT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.setTooltipScaleFactor(EnumBaseGUISetting.TEXT_TOOLTIP_SCALE.get().asFloat());
        for (int i = 0; i < this.roles.length; ++i) {
            int roleId = sharedData.getByte(i + 10);
            if (roleId == -1) continue;
            RoleData roleData = OxygenManagerClient.instance().getPrivilegesContainer().getRoleData(roleId);
            this.roles[i] = roleData != null ? roleData.nameColor + roleData.name : TextFormatting.ITALIC + "Undefined";
            this.rolesAmount = i + 1;
            int width = this.textWidth(roleData.name, this.getTooltipScaleFactor()) + 4;
            if (this.rolesWidth >= width) continue;
            this.rolesWidth = width;
        }
    }

    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            int textColor;
            int color;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredBackgroundColor();
                textColor = this.getHoveredTextColor();
            } else {
                color = this.getEnabledBackgroundColor();
                textColor = this.getEnabledTextColor();
            }
            int third = this.getWidth() / 3;
            OxygenGUIUtils.drawGradientRect((double)0.0, (double)0.0, (double)third, (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.RIGHT);
            PlayerPanelEntry.drawRect((int)third, (int)0, (int)(this.getWidth() - third), (int)this.getHeight(), (int)color);
            OxygenGUIUtils.drawGradientRect((double)(this.getWidth() - third), (double)0.0, (double)this.getWidth(), (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.LEFT);
            int textY = (this.getHeight() - this.textHeight(this.getTextScale())) / 2 + 1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)18.0f, (float)textY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, this.isTextShadowEnabled());
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)120.0f, (float)textY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.dimensionStr, 0.0f, 0.0f, textColor, this.isTextShadowEnabled());
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)240.0f, (float)textY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.jumpProfileStr, 0.0f, 0.0f, textColor, this.isTextShadowEnabled());
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.STATUS_ICONS);
            PlayerPanelEntry.drawCustomSizedTexturedRect((int)7, (int)4, (int)this.statusIconU, (int)0, (int)3, (int)3, (int)12, (int)3);
            GlStateManager.func_179121_F();
        }
    }

    public void drawTooltip(int mouseX, int mouseY) {
        if (this.rolesAmount != 0 && mouseX >= this.getX() + 18 && mouseY >= this.getY() + 1 && mouseX < this.getX() + 60 && mouseY < this.getY() + 9) {
            this.drawRolesTooltip(mouseX, mouseY);
        }
    }

    private void drawRolesTooltip(int mouseX, int mouseY) {
        int height = 9;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)mouseX, (float)(mouseY - height * this.rolesAmount), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PlayerPanelEntry.drawRect((int)0, (int)0, (int)this.rolesWidth, (int)(height * this.rolesAmount), (int)this.tooltipBackgroundColor);
        OxygenGUIUtils.drawRect((double)0.0, (double)0.0, (double)0.4, (double)((double)height * (double)this.rolesAmount), (int)this.tooltipFrameColor);
        OxygenGUIUtils.drawRect((double)((double)this.rolesWidth - 0.4), (double)0.0, (double)this.rolesWidth, (double)((double)height * (double)this.rolesAmount), (int)this.tooltipFrameColor);
        OxygenGUIUtils.drawRect((double)0.0, (double)0.0, (double)this.rolesWidth, (double)0.4, (int)this.tooltipFrameColor);
        OxygenGUIUtils.drawRect((double)0.0, (double)((double)height * (double)this.rolesAmount - 0.4), (double)this.rolesWidth, (double)((double)height * (double)this.rolesAmount), (int)this.tooltipFrameColor);
        for (int i = 0; i < this.rolesAmount; ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)((float)(i * height + (height - this.textHeight(this.getTooltipScaleFactor())) / 2) + 1.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTooltipScaleFactor(), (float)this.getTooltipScaleFactor(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.roles[i], 0.0f, 0.0f, this.getEnabledTextColor(), false);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }
}

