/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common;

import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationPrivilege;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class CooldownData {
    private UUID playerUUID;
    private long nextCamp;
    private long nextLocation;
    private long nextJump;

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public void movedToCamp() {
        this.nextCamp = System.currentTimeMillis() + (long)PrivilegesProviderServer.getAsInt((UUID)this.playerUUID, (int)EnumTeleportationPrivilege.CAMP_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.CAMP_TELEPORTATION_COOLDOWN_SECONDS.asInt()) * 1000L;
    }

    public void movedToLocation() {
        this.nextLocation = System.currentTimeMillis() + (long)PrivilegesProviderServer.getAsInt((UUID)this.playerUUID, (int)EnumTeleportationPrivilege.LOCATION_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.LOCATION_TELEPORTATION_COOLDOWN_SECONDS.asInt()) * 1000L;
    }

    public void jumped() {
        this.nextJump = System.currentTimeMillis() + (long)PrivilegesProviderServer.getAsInt((UUID)this.playerUUID, (int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.asInt()) * 1000L;
    }

    public void updateCooldown(int campCooldownLeftSeconds, int locationCooldownLeftSeconds, int jumpCooldownLeftSeconds) {
        this.nextCamp = System.currentTimeMillis() + (long)campCooldownLeftSeconds * 1000L;
        this.nextLocation = System.currentTimeMillis() + (long)locationCooldownLeftSeconds * 1000L;
        this.nextJump = System.currentTimeMillis() + (long)jumpCooldownLeftSeconds * 1000L;
    }

    public long getNextCampTime() {
        return this.nextCamp;
    }

    public long getNextLocationTime() {
        return this.nextLocation;
    }

    public long getNextJumpTime() {
        return this.nextJump;
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((long)this.nextCamp, (OutputStream)bos);
        StreamUtils.write((long)this.nextLocation, (OutputStream)bos);
        StreamUtils.write((long)this.nextJump, (OutputStream)bos);
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.nextCamp = StreamUtils.readLong((InputStream)bis);
        this.nextLocation = StreamUtils.readLong((InputStream)bis);
        this.nextJump = StreamUtils.readLong((InputStream)bis);
    }
}

