/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common;

import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_teleportation.common.CooldownData;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class TeleportationPlayerData
extends AbstractPersistentData {
    private UUID playerUUID;
    private final Map<Long, WorldPoint> camps = new ConcurrentHashMap<Long, WorldPoint>(5);
    private long favoriteCamp;
    private EnumJumpProfile jumpProfile;
    private final CooldownData cooldown = new CooldownData();
    private String dataPath;

    public TeleportationPlayerData() {
        this.jumpProfile = EnumJumpProfile.values()[TeleportationConfig.DEFAULT_PLAYER_TELEPORTATION_PROFILE.asInt()];
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.cooldown.setPlayerUUID(playerUUID);
    }

    public void setPath(String path) {
        this.dataPath = path;
    }

    public Collection<WorldPoint> getCamps() {
        return this.camps.values();
    }

    public int getCampsAmount() {
        return this.camps.size();
    }

    public boolean isCampsExist() {
        return !this.camps.isEmpty();
    }

    public Set<Long> getCampIds() {
        return this.camps.keySet();
    }

    public boolean isCampExist(long pointId) {
        return this.camps.containsKey(pointId);
    }

    @Nullable
    public WorldPoint getCamp(long pointId) {
        return this.camps.get(pointId);
    }

    public void addCamp(WorldPoint worldPoint) {
        this.camps.put(worldPoint.getId(), worldPoint);
    }

    public void removeCamp(long pointId) {
        this.camps.remove(pointId);
        if (this.favoriteCamp == pointId) {
            this.favoriteCamp = 0L;
        }
    }

    public long getFavoriteCampId() {
        return this.favoriteCamp;
    }

    @Nullable
    public WorldPoint getFavoriteCamp() {
        return this.camps.get(this.favoriteCamp);
    }

    public void setFavoriteCampId(long pointId) {
        this.favoriteCamp = pointId;
    }

    public int getOwnedCampsAmount() {
        int amount = 0;
        for (WorldPoint camp : this.camps.values()) {
            if (!camp.isOwner(this.playerUUID)) continue;
            ++amount;
        }
        return amount;
    }

    public long createId(long seed) {
        long id = ++seed;
        while (this.camps.containsKey(id)) {
            ++id;
        }
        return id;
    }

    public EnumJumpProfile getJumpProfile() {
        return this.jumpProfile;
    }

    public void setJumpProfile(EnumJumpProfile jumpProfile) {
        this.jumpProfile = jumpProfile;
    }

    public CooldownData getCooldownData() {
        return this.cooldown;
    }

    public String getDisplayName() {
        return "teleportation:player_data";
    }

    public String getPath() {
        return this.dataPath;
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((UUID)this.playerUUID, (OutputStream)bos);
        StreamUtils.write((long)this.getFavoriteCampId(), (OutputStream)bos);
        StreamUtils.write((byte)((byte)this.getJumpProfile().ordinal()), (OutputStream)bos);
        StreamUtils.write((short)((short)this.getCampsAmount()), (OutputStream)bos);
        for (WorldPoint worldPoint : this.getCamps()) {
            worldPoint.write(bos);
        }
        this.cooldown.write(bos);
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.playerUUID = StreamUtils.readUUID((InputStream)bis);
        this.setFavoriteCampId(StreamUtils.readLong((InputStream)bis));
        this.setJumpProfile(EnumJumpProfile.values()[StreamUtils.readByte((InputStream)bis)]);
        int size = StreamUtils.readShort((InputStream)bis);
        for (int i = 0; i < size; ++i) {
            this.addCamp(WorldPoint.read(bis));
        }
        this.cooldown.read(bis);
    }

    public void reset() {
        this.camps.clear();
    }

    public static enum EnumJumpProfile {
        FREE,
        REQUEST,
        DISABLED;


        public String localizedName() {
            return ClientReference.localize((String)("oxygen_teleportation.jumpProfile." + this.toString().toLowerCase()), (Object[])new Object[0]);
        }
    }
}

