/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common;

import austeretony.oxygen_core.common.sync.SynchronousEntry;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class WorldPoint
implements SynchronousEntry {
    public static final int MAX_NAME_LENGTH = 20;
    public static final int MAX_DESCRIPTION_LENGTH = 400;
    private long id;
    private UUID ownerUUID;
    private String ownerName;
    private String name;
    private String desc;
    private float yaw;
    private float pitch;
    private float xPos;
    private float yPos;
    private float zPos;
    private int dimension;
    private boolean locked;

    public WorldPoint() {
    }

    public WorldPoint(long id, UUID ownerUUID, String ownerName, String name, String description, int dimension, float xPos, float yPos, float zPos, float yaw, float pitch) {
        this.id = id;
        this.ownerUUID = ownerUUID;
        this.ownerName = ownerName;
        this.name = name;
        this.desc = description;
        this.dimension = dimension;
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long pointId) {
        this.id = pointId;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String description) {
        this.desc = description;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getXPos() {
        return this.xPos;
    }

    public float getYPos() {
        return this.yPos;
    }

    public float getZPos() {
        return this.zPos;
    }

    public int getDimensionId() {
        return this.dimension;
    }

    public void setPosition(float x, float y, float z, int dimension, float yaw, float pitch) {
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.dimension = dimension;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public boolean isOwner(UUID playerUUID) {
        return playerUUID.equals(this.ownerUUID);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean flag) {
        this.locked = flag;
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((long)this.id, (OutputStream)bos);
        StreamUtils.write((UUID)this.ownerUUID, (OutputStream)bos);
        StreamUtils.write((String)this.ownerName, (OutputStream)bos);
        StreamUtils.write((String)this.getName(), (OutputStream)bos);
        StreamUtils.write((String)this.getDescription(), (OutputStream)bos);
        StreamUtils.write((int)this.getDimensionId(), (OutputStream)bos);
        StreamUtils.write((float)this.getXPos(), (OutputStream)bos);
        StreamUtils.write((float)this.getYPos(), (OutputStream)bos);
        StreamUtils.write((float)this.getZPos(), (OutputStream)bos);
        StreamUtils.write((float)this.getYaw(), (OutputStream)bos);
        StreamUtils.write((float)this.getPitch(), (OutputStream)bos);
        StreamUtils.write((long)this.getId(), (OutputStream)bos);
        StreamUtils.write((boolean)this.isLocked(), (OutputStream)bos);
    }

    public static WorldPoint read(BufferedInputStream bis) throws IOException {
        WorldPoint worldPoint = new WorldPoint(StreamUtils.readLong((InputStream)bis), StreamUtils.readUUID((InputStream)bis), StreamUtils.readString((InputStream)bis), StreamUtils.readString((InputStream)bis), StreamUtils.readString((InputStream)bis), StreamUtils.readInt((InputStream)bis), StreamUtils.readFloat((InputStream)bis), StreamUtils.readFloat((InputStream)bis), StreamUtils.readFloat((InputStream)bis), StreamUtils.readFloat((InputStream)bis), StreamUtils.readFloat((InputStream)bis));
        worldPoint.setId(StreamUtils.readLong((InputStream)bis));
        worldPoint.setLocked(StreamUtils.readBoolean((InputStream)bis));
        return worldPoint;
    }

    public void write(ByteBuf buffer) {
        buffer.writeLong(this.id);
        ByteBufUtils.writeUUID((UUID)this.ownerUUID, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.ownerName, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.getName(), (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.getDescription(), (ByteBuf)buffer);
        buffer.writeInt(this.getDimensionId());
        buffer.writeFloat(this.getXPos());
        buffer.writeFloat(this.getYPos());
        buffer.writeFloat(this.getZPos());
        buffer.writeFloat(this.getPitch());
        buffer.writeFloat(this.getYaw());
        buffer.writeBoolean(this.isLocked());
    }

    public void read(ByteBuf buffer) {
        this.id = buffer.readLong();
        this.ownerUUID = ByteBufUtils.readUUID((ByteBuf)buffer);
        this.ownerName = ByteBufUtils.readString((ByteBuf)buffer);
        this.name = ByteBufUtils.readString((ByteBuf)buffer);
        this.desc = ByteBufUtils.readString((ByteBuf)buffer);
        this.dimension = buffer.readInt();
        this.xPos = buffer.readFloat();
        this.yPos = buffer.readFloat();
        this.zPos = buffer.readFloat();
        this.yaw = buffer.readFloat();
        this.pitch = buffer.readFloat();
        this.locked = buffer.readBoolean();
    }

    public static enum EnumWorldPoint {
        CAMP,
        LOCATION;

    }
}

