/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common.network.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_teleportation.client.TeleportationManagerClient;
import austeretony.oxygen_teleportation.common.WorldPoint;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.INetHandler;

public class CPWorldPointEdited
extends Packet {
    private int ordinal;
    private long oldPointId;
    private WorldPoint worldPoint;
    private boolean updateImage;

    public CPWorldPointEdited() {
    }

    public CPWorldPointEdited(WorldPoint.EnumWorldPoint type, long oldPointId, WorldPoint worldPoint, boolean updateImage) {
        this.ordinal = type.ordinal();
        this.oldPointId = oldPointId;
        this.worldPoint = worldPoint;
        this.updateImage = updateImage;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeLong(this.oldPointId);
        this.worldPoint.write(buffer);
        buffer.writeBoolean(this.updateImage);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        WorldPoint.EnumWorldPoint type = WorldPoint.EnumWorldPoint.values()[buffer.readByte()];
        long oldPointId = buffer.readLong();
        WorldPoint worldPoint = new WorldPoint();
        worldPoint.read(buffer);
        boolean updateImage = buffer.readBoolean();
        switch (type) {
            case CAMP: {
                OxygenHelperClient.addRoutineTask(() -> TeleportationManagerClient.instance().getPlayerDataManager().campEdited(oldPointId, worldPoint, updateImage));
                break;
            }
            case LOCATION: {
                OxygenHelperClient.addRoutineTask(() -> TeleportationManagerClient.instance().getLocationsManager().locationEdited(oldPointId, worldPoint, updateImage));
            }
        }
    }
}

