/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPChangePointLockState
extends Packet {
    private int ordinal;
    private long pointId;
    private boolean flag;

    public SPChangePointLockState() {
    }

    public SPChangePointLockState(WorldPoint.EnumWorldPoint point, long pointId, boolean flag) {
        this.ordinal = point.ordinal();
        this.pointId = pointId;
        this.flag = flag;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeLong(this.pointId);
        buffer.writeBoolean(this.flag);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        byte ordinal;
        EntityPlayerMP playerMP = SPChangePointLockState.getEntityPlayerMP((INetHandler)netHandler);
        if (OxygenHelperServer.isNetworkRequestAvailable((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)15) && (ordinal = buffer.readByte()) >= 0 && ordinal < WorldPoint.EnumWorldPoint.values().length) {
            WorldPoint.EnumWorldPoint point = WorldPoint.EnumWorldPoint.values()[ordinal];
            long pointId = buffer.readLong();
            boolean flag = buffer.readBoolean();
            switch (point) {
                case CAMP: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getPlayersDataManager().changeCampLockState(playerMP, pointId, flag));
                    break;
                }
                case LOCATION: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getLocationsManager().changeLocationLockState(playerMP, pointId, flag));
                }
            }
        }
    }
}

